/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.packages.InputFile;
import com.google.devtools.build.lib.packages.License;
import com.google.devtools.build.lib.packages.Package;
import com.google.devtools.build.lib.packages.RuleVisibility;
import javax.annotation.Nullable;
import net.starlark.java.syntax.Location;

public final class VisibilityLicenseSpecifiedInputFile
extends InputFile {
    @Nullable
    private final RuleVisibility visibility;
    @Nullable
    private final License license;

    VisibilityLicenseSpecifiedInputFile(Package pkg, Label label, Location location, @Nullable RuleVisibility visibility, @Nullable License license) {
        super(pkg, label, location);
        this.visibility = visibility;
        this.license = license;
    }

    @Override
    public boolean isVisibilitySpecified() {
        return this.visibility != null;
    }

    @Override
    public RuleVisibility getVisibility() {
        if (this.visibility != null) {
            return this.visibility;
        }
        return this.getPackage().getDefaultVisibility();
    }

    @Override
    public boolean isLicenseSpecified() {
        return this.license != null && this.license.isSpecified();
    }

    @Override
    public License getLicense() {
        if (this.license != null) {
            return this.license;
        }
        return this.getPackage().getDefaultLicense();
    }
}

