/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.collect.nestedset.Depset;
import com.google.devtools.build.lib.packages.Attribute;
import com.google.devtools.build.lib.packages.LabelConverter;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.SerializationConstant;
import com.google.devtools.build.lib.util.LoggingUtil;
import com.google.devtools.build.lib.util.StringCanonicalizer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nullable;
import net.starlark.java.eval.Dict;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Printer;
import net.starlark.java.eval.Sequence;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkInt;

public abstract class Type<T> {
    @SerializationConstant
    public static final Type<StarlarkInt> INTEGER = new IntegerType();
    @SerializationConstant
    public static final Type<String> STRING = new StringType();
    @SerializationConstant
    public static final Type<Boolean> BOOLEAN = new BooleanType();
    @SerializationConstant
    public static final ObjectListType OBJECT_LIST = new ObjectListType();
    @SerializationConstant
    public static final ListType<String> STRING_LIST = ListType.create(STRING);
    @SerializationConstant
    public static final ListType<StarlarkInt> INTEGER_LIST = ListType.create(INTEGER);
    @SerializationConstant
    public static final DictType<String, String> STRING_DICT = DictType.create(STRING, STRING);
    @SerializationConstant
    public static final DictType<String, List<String>> STRING_LIST_DICT = DictType.create(STRING, STRING_LIST);

    Type() {
    }

    public abstract T convert(Object var1, Object var2, @Nullable LabelConverter var3) throws ConversionException;

    public final T convert(Object x, Object what) throws ConversionException {
        return this.convert(x, what, null);
    }

    @Nullable
    public final T convertOptional(Object x, String what, @Nullable LabelConverter labelConverter, T defaultValue) throws ConversionException {
        if (Starlark.isNullOrNone(x)) {
            return defaultValue;
        }
        return this.convert(x, what, labelConverter);
    }

    @Nullable
    public final T convertOptional(Object x, String what, @Nullable LabelConverter labelConverter) throws ConversionException {
        return this.convertOptional(x, what, labelConverter, null);
    }

    @Nullable
    public final T convertOptional(Object x, String what) throws ConversionException {
        return this.convertOptional(x, what, null);
    }

    public abstract T cast(Object var1);

    public abstract String toString();

    public abstract T getDefaultValue();

    public abstract void visitLabels(LabelVisitor var1, T var2, @Nullable Attribute var3);

    public LabelClass getLabelClass() {
        return LabelClass.NONE;
    }

    public T concat(Iterable<T> elements) {
        return null;
    }

    public Set<String> toTagSet(Object value, String name) {
        String msg = "Attribute " + name + " does not support tag conversion.";
        throw new UnsupportedOperationException(msg);
    }

    public Type<?> getListElementType() {
        return null;
    }

    public static class ObjectListType
    extends ListType<Object> {
        private static final Type<Object> elemType = new ObjectType();

        private ObjectListType() {
            super(elemType);
        }

        @Override
        public List<Object> convert(Object x, Object what, LabelConverter labelConverter) throws ConversionException {
            if (x instanceof Sequence) {
                return ((Sequence)x).getImmutableList();
            }
            if (x instanceof List) {
                return (List)x;
            }
            if (x instanceof Iterable) {
                return ImmutableList.copyOf((Iterable)x);
            }
            throw new ConversionException(this, x, what);
        }
    }

    public static class ListType<ElemT>
    extends Type<List<ElemT>> {
        private final Type<ElemT> elemType;
        private final List<ElemT> empty = ImmutableList.of();

        public static <ELEM> ListType<ELEM> create(Type<ELEM> elemType) {
            return new ListType<ELEM>(elemType);
        }

        private ListType(Type<ElemT> elemType) {
            this.elemType = elemType;
        }

        @Override
        public final List<ElemT> cast(Object value) {
            return (List)value;
        }

        @Override
        public Type<ElemT> getListElementType() {
            return this.elemType;
        }

        @Override
        public LabelClass getLabelClass() {
            return this.elemType.getLabelClass();
        }

        @Override
        public List<ElemT> getDefaultValue() {
            return this.empty;
        }

        @Override
        public final void visitLabels(LabelVisitor visitor, List<ElemT> value, @Nullable Attribute context) {
            if (this.elemType.getLabelClass() == LabelClass.NONE) {
                return;
            }
            if (value instanceof RandomAccess) {
                for (int i = 0; i < value.size(); ++i) {
                    this.elemType.visitLabels(visitor, value.get(i), context);
                }
            } else {
                for (ElemT elem : value) {
                    this.elemType.visitLabels(visitor, elem, context);
                }
            }
        }

        @Override
        public String toString() {
            return "list(" + this.elemType + ")";
        }

        @Override
        public List<ElemT> convert(Object x, Object what, LabelConverter labelConverter) throws ConversionException {
            ImmutableList<?> iterable;
            if (x instanceof Iterable) {
                iterable = (ImmutableList<?>)x;
            } else if (x instanceof Depset) {
                iterable = ((Depset)x).toList();
            } else {
                throw new ConversionException(this, x, what);
            }
            int index = 0;
            ArrayList<ElemT> result = new ArrayList<ElemT>(Iterables.size(iterable));
            ListConversionContext conversionContext = new ListConversionContext(what);
            for (Object elem : iterable) {
                conversionContext.update(index);
                ElemT converted = this.elemType.convert(elem, conversionContext, labelConverter);
                if (converted != null) {
                    result.add(converted);
                } else {
                    String message = "Converting a list with a null element: element " + index + " of " + what + " in " + labelConverter;
                    LoggingUtil.logToRemote(Level.WARNING, message, new ConversionException(message));
                }
                ++index;
            }
            return result;
        }

        @Override
        public List<ElemT> concat(Iterable<List<ElemT>> elements) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (List<ElemT> list : elements) {
                builder.addAll(list);
            }
            return builder.build();
        }

        @Override
        public Set<String> toTagSet(Object items, String name) {
            if (items == null) {
                String msg = "Illegal tag conversion from null on Attribute" + name + ".";
                throw new IllegalStateException(msg);
            }
            LinkedHashSet<String> tags = new LinkedHashSet<String>();
            List itemsAsListofElem = (List)items;
            for (Object element : itemsAsListofElem) {
                tags.add(element.toString());
            }
            return tags;
        }

        private static class ListConversionContext {
            private final Object what;
            private int index = 0;

            ListConversionContext(Object what) {
                this.what = what;
            }

            void update(int index) {
                this.index = index;
            }

            public String toString() {
                return "element " + this.index + " of " + this.what;
            }
        }
    }

    public static class DictType<KeyT, ValueT>
    extends Type<Map<KeyT, ValueT>> {
        private final Type<KeyT> keyType;
        private final Type<ValueT> valueType;
        private final Map<KeyT, ValueT> empty = ImmutableMap.of();
        private final LabelClass labelClass;

        @Override
        public final void visitLabels(LabelVisitor visitor, Map<KeyT, ValueT> value, @Nullable Attribute context) {
            if (this.labelClass != LabelClass.NONE) {
                for (Map.Entry<KeyT, ValueT> entry : value.entrySet()) {
                    this.keyType.visitLabels(visitor, entry.getKey(), context);
                    this.valueType.visitLabels(visitor, entry.getValue(), context);
                }
            }
        }

        public static <KEY, VALUE> DictType<KEY, VALUE> create(Type<KEY> keyType, Type<VALUE> valueType) {
            LabelClass keyLabelClass = keyType.getLabelClass();
            LabelClass valueLabelClass = valueType.getLabelClass();
            Preconditions.checkArgument(keyLabelClass == LabelClass.NONE || valueLabelClass == LabelClass.NONE || keyLabelClass == valueLabelClass, "A DictType's keys and values must be the same class of label if both contain labels, but the key type %s contains %s labels, while the value type %s contains %s labels.", keyType, (Object)keyLabelClass, valueType, (Object)valueLabelClass);
            LabelClass labelClass = keyLabelClass != LabelClass.NONE ? keyLabelClass : valueLabelClass;
            return new DictType<KEY, VALUE>(keyType, valueType, labelClass);
        }

        DictType(Type<KeyT> keyType, Type<ValueT> valueType, LabelClass labelClass) {
            this.keyType = keyType;
            this.valueType = valueType;
            this.labelClass = labelClass;
        }

        public Type<KeyT> getKeyType() {
            return this.keyType;
        }

        public Type<ValueT> getValueType() {
            return this.valueType;
        }

        @Override
        public LabelClass getLabelClass() {
            return this.labelClass;
        }

        @Override
        public Map<KeyT, ValueT> cast(Object value) {
            return (Map)value;
        }

        @Override
        public String toString() {
            return "dict(" + this.keyType + ", " + this.valueType + ")";
        }

        @Override
        public Map<KeyT, ValueT> convert(Object x, Object what, LabelConverter labelConverter) throws ConversionException {
            if (!(x instanceof Map)) {
                throw new ConversionException(this, x, what);
            }
            Map o = (Map)x;
            LinkedHashMap<KeyT, ValueT> result = new LinkedHashMap<KeyT, ValueT>();
            for (Map.Entry elem : o.entrySet()) {
                result.put(this.keyType.convert(elem.getKey(), "dict key element", labelConverter), this.valueType.convert(elem.getValue(), "dict value element", labelConverter));
            }
            return ImmutableMap.copyOf(result);
        }

        @Override
        public Map<KeyT, ValueT> concat(Iterable<Map<KeyT, ValueT>> iterable) {
            Dict.Builder<KeyT, ValueT> output = new Dict.Builder<KeyT, ValueT>();
            for (Map<KeyT, ValueT> map : iterable) {
                output.putAll(map);
            }
            return output.buildImmutable();
        }

        @Override
        public Map<KeyT, ValueT> getDefaultValue() {
            return this.empty;
        }
    }

    private static final class StringType
    extends Type<String> {
        private StringType() {
        }

        @Override
        public String cast(Object value) {
            return (String)value;
        }

        @Override
        public String getDefaultValue() {
            return "";
        }

        @Override
        public void visitLabels(LabelVisitor visitor, String value, @Nullable Attribute context) {
        }

        @Override
        public String toString() {
            return "string";
        }

        @Override
        public String convert(Object x, Object what, LabelConverter labelConverter) throws ConversionException {
            if (!(x instanceof String)) {
                throw new ConversionException(this, x, what);
            }
            return StringCanonicalizer.intern((String)x);
        }

        @Override
        public String concat(Iterable<String> elements) {
            return Joiner.on("").join(elements);
        }

        @Override
        public Set<String> toTagSet(Object value, String name) {
            if (value == null) {
                String msg = "Illegal tag conversion from null on Attribute " + name + ".";
                throw new IllegalStateException(msg);
            }
            return ImmutableSet.of((String)value);
        }
    }

    private static final class BooleanType
    extends Type<Boolean> {
        private BooleanType() {
        }

        @Override
        public Boolean cast(Object value) {
            return (Boolean)value;
        }

        @Override
        public Boolean getDefaultValue() {
            return false;
        }

        @Override
        public void visitLabels(LabelVisitor visitor, Boolean value, @Nullable Attribute context) {
        }

        @Override
        public String toString() {
            return "boolean";
        }

        @Override
        public Boolean convert(Object x, Object what, LabelConverter labelConverter) throws ConversionException {
            if (x instanceof Boolean) {
                return (Boolean)x;
            }
            int xAsInteger = ((StarlarkInt)INTEGER.convert(x, what, labelConverter)).toIntUnchecked();
            if (xAsInteger == 0) {
                return false;
            }
            if (xAsInteger == 1) {
                return true;
            }
            throw new ConversionException("boolean is not one of [0, 1]");
        }

        @Override
        public Set<String> toTagSet(Object value, String name) {
            if (value == null) {
                String msg = "Illegal tag conversion from null on Attribute " + name + ".";
                throw new IllegalStateException(msg);
            }
            Object tag = (Boolean)value != false ? name : "no" + name;
            return ImmutableSet.of(tag);
        }
    }

    private static final class IntegerType
    extends Type<StarlarkInt> {
        private IntegerType() {
        }

        @Override
        public StarlarkInt cast(Object value) {
            return (StarlarkInt)value;
        }

        @Override
        public StarlarkInt getDefaultValue() {
            return StarlarkInt.of(0);
        }

        @Override
        public void visitLabels(LabelVisitor visitor, StarlarkInt value, @Nullable Attribute context) {
        }

        @Override
        public String toString() {
            return "int";
        }

        @Override
        public StarlarkInt convert(Object x, Object what, LabelConverter labelConverter) throws ConversionException {
            if (x instanceof StarlarkInt) {
                StarlarkInt i = (StarlarkInt)x;
                try {
                    i.toIntUnchecked();
                }
                catch (IllegalArgumentException ex) {
                    Object prefix = what != null ? "for " + what + ", " : "";
                    throw new ConversionException(String.format("%sgot %s, want value in signed 32-bit range", prefix, i));
                }
                return i;
            }
            if (x instanceof Integer) {
                throw new IllegalArgumentException("Integer is not a legal Starlark value");
            }
            throw new ConversionException(this, x, what);
        }

        @Override
        public StarlarkInt concat(Iterable<StarlarkInt> elements) {
            StarlarkInt sum = StarlarkInt.of(0);
            for (StarlarkInt elem : elements) {
                sum = StarlarkInt.add(sum, elem);
            }
            return StarlarkInt.of(sum.truncateToInt());
        }
    }

    private static final class ObjectType
    extends Type<Object> {
        private ObjectType() {
        }

        @Override
        public Object cast(Object value) {
            return value;
        }

        @Override
        public String getDefaultValue() {
            throw new UnsupportedOperationException("ObjectType has no default value");
        }

        @Override
        public void visitLabels(LabelVisitor visitor, Object value, @Nullable Attribute context) {
        }

        @Override
        public String toString() {
            return "object";
        }

        @Override
        public Object convert(Object x, Object what, LabelConverter labelConverter) {
            return Preconditions.checkNotNull(x);
        }
    }

    public static class ConversionException
    extends EvalException {
        private static String message(Type<?> type, Object value, @Nullable Object what) {
            Printer printer = new Printer();
            printer.append("expected value of type '").append(type.toString()).append("'");
            if (what != null) {
                printer.append(" for ").append(what.toString());
            }
            printer.append(", but got ");
            printer.repr(value);
            printer.append(" (").append(Starlark.type(value)).append(")");
            return printer.toString();
        }

        ConversionException(Type<?> type, Object value, @Nullable Object what) {
            super(ConversionException.message(type, Preconditions.checkNotNull(value), what));
        }

        public ConversionException(String message) {
            super(message);
        }
    }

    public static enum LabelClass {
        NONE,
        DEPENDENCY,
        NONDEP_REFERENCE,
        GENQUERY_SCOPE_REFERENCE,
        OUTPUT,
        FILESET_ENTRY;

    }

    public static interface LabelVisitor {
        public void visit(@Nullable Label var1, @Nullable Attribute var2);
    }
}

