/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.devtools.build.lib.packages.EnumFilterConverter;
import com.google.devtools.build.lib.packages.NonconfigurableAttributeMapper;
import com.google.devtools.build.lib.packages.Rule;
import com.google.devtools.build.lib.packages.Type;
import com.google.devtools.common.options.Converter;
import com.google.devtools.common.options.OptionsParsingException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public enum TestTimeout {
    SHORT(60),
    MODERATE(300),
    LONG(900),
    ETERNAL(3600);

    public static final String COVERAGE_CMD_TIMEOUT = "--test_timeout=300,600,1200,3600";
    private static final RangeMap<Integer, TestTimeout> SUGGESTED_TIMEOUT;
    private static final Map<TestTimeout, Range<Integer>> TIMEOUT_FUZZY_RANGE;
    private final int timeout;

    private TestTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Nullable
    public static TestTimeout getTestTimeout(String attr) {
        if (!attr.equals(attr.toLowerCase())) {
            return null;
        }
        try {
            return TestTimeout.valueOf(attr.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Nullable
    public static TestTimeout getTestTimeout(Rule testTarget) {
        String attr = NonconfigurableAttributeMapper.of(testTarget).get("timeout", Type.STRING);
        if (!attr.equals(attr.toLowerCase())) {
            return null;
        }
        try {
            return TestTimeout.valueOf(attr.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String toString() {
        return super.toString().toLowerCase();
    }

    public String prettyPrint() {
        return super.toString().toUpperCase();
    }

    @Deprecated
    public int getTimeoutSeconds() {
        return this.timeout;
    }

    public Duration getTimeout() {
        return Duration.ofSeconds(this.timeout);
    }

    public boolean isInRangeFuzzy(int timeInSeconds) {
        return TIMEOUT_FUZZY_RANGE.get((Object)this).contains(timeInSeconds);
    }

    public static TestTimeout getSuggestedTestTimeout(int timeInSeconds) {
        return SUGGESTED_TIMEOUT.get(timeInSeconds);
    }

    static {
        int maxTimeout = 31536000;
        ImmutableRangeMap.Builder<Integer, TestTimeout> suggestedTimeoutBuilder = ImmutableRangeMap.builder();
        ImmutableMap.Builder<TestTimeout, Range<Integer>> timeoutFuzzyRangeBuilder = ImmutableMap.builder();
        int previousMaxSuggested = 0;
        int previousTimeout = 0;
        Iterator<TestTimeout> timeoutIterator = Arrays.asList(TestTimeout.values()).iterator();
        while (timeoutIterator.hasNext()) {
            TestTimeout timeout = timeoutIterator.next();
            int minSuggested = previousMaxSuggested;
            int maxSuggested = timeoutIterator.hasNext() ? (int)((double)timeout.timeout * 0.75) : 31536000;
            int minFuzzy = previousTimeout / 2;
            int maxFuzzy = timeoutIterator.hasNext() ? (int)((double)timeout.timeout * 0.9) : 31536000;
            timeoutFuzzyRangeBuilder.put(timeout, Range.closedOpen(minFuzzy, maxFuzzy));
            suggestedTimeoutBuilder.put(Range.closedOpen(minSuggested, maxSuggested), timeout);
            previousMaxSuggested = maxSuggested;
            previousTimeout = timeout.timeout;
        }
        SUGGESTED_TIMEOUT = suggestedTimeoutBuilder.build();
        TIMEOUT_FUZZY_RANGE = timeoutFuzzyRangeBuilder.buildOrThrow();
    }

    public static class TestTimeoutFilterConverter
    extends EnumFilterConverter<TestTimeout> {
        public TestTimeoutFilterConverter() {
            super(TestTimeout.class, "test timeout");
        }

        @Override
        public final Set<TestTimeout> convert(String input) throws OptionsParsingException {
            return super.convert(input);
        }
    }

    public static class TestTimeoutConverter
    extends Converter.Contextless<Map<TestTimeout, Duration>> {
        @Override
        public Map<TestTimeout, Duration> convert(String input) throws OptionsParsingException {
            ArrayList<Duration> values = new ArrayList<Duration>();
            for (String token : Splitter.on(',').limit(6).split(input)) {
                if (token.isEmpty() && values.size() <= 1) continue;
                try {
                    values.add(Duration.ofSeconds(Integer.parseInt(token)));
                }
                catch (NumberFormatException e) {
                    throw new OptionsParsingException("'" + input + "' is not an int", e);
                }
            }
            EnumMap<TestTimeout, Duration> timeouts = Maps.newEnumMap(TestTimeout.class);
            if (values.size() == 1) {
                timeouts.put(SHORT, (Duration)values.get(0));
                timeouts.put(MODERATE, (Duration)values.get(0));
                timeouts.put(LONG, (Duration)values.get(0));
                timeouts.put(ETERNAL, (Duration)values.get(0));
            } else if (values.size() == 4) {
                timeouts.put(SHORT, (Duration)values.get(0));
                timeouts.put(MODERATE, (Duration)values.get(1));
                timeouts.put(LONG, (Duration)values.get(2));
                timeouts.put(ETERNAL, (Duration)values.get(3));
            } else {
                throw new OptionsParsingException("Invalid number of comma-separated entries");
            }
            for (TestTimeout label : TestTimeout.values()) {
                if (timeouts.containsKey((Object)label) && timeouts.get((Object)label).compareTo(Duration.ZERO) > 0) continue;
                timeouts.put(label, label.getTimeout());
            }
            return timeouts;
        }

        @Override
        public String getTypeDescription() {
            return "a single integer or comma-separated list of 4 integers";
        }
    }
}

