/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.devtools.build.lib.packages.NonconfigurableAttributeMapper;
import com.google.devtools.build.lib.packages.Rule;
import com.google.devtools.build.lib.packages.Target;
import com.google.devtools.build.lib.packages.Type;
import com.google.devtools.build.lib.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class TestTargetUtils {
    public static boolean testMatchesFilters(Collection<String> testTags, Collection<String> requiredTags, Collection<String> excludedTags, boolean mustMatchAllPositive) {
        for (String tag : excludedTags) {
            if (!testTags.contains(tag)) continue;
            return false;
        }
        if (requiredTags.isEmpty()) {
            return true;
        }
        if (mustMatchAllPositive) {
            for (String tag : requiredTags) {
                if (testTags.contains(tag)) continue;
                return false;
            }
            return true;
        }
        return !Collections.disjoint(requiredTags, testTags);
    }

    public static boolean testMatchesFilters(Collection<String> testTags, Collection<String> requiredTags, Collection<String> excludedTags) {
        return TestTargetUtils.testMatchesFilters(testTags, requiredTags, excludedTags, true);
    }

    private static boolean testMatchesFilters(Rule testTarget, Collection<String> requiredTags, Collection<String> excludedTags) {
        NonconfigurableAttributeMapper nonConfigurableAttrs = NonconfigurableAttributeMapper.of(testTarget);
        HashSet<String> testTags = new HashSet<String>((Collection)((Object)nonConfigurableAttrs.get("tags", Type.STRING_LIST)));
        testTags.add(nonConfigurableAttrs.get("size", Type.STRING));
        return TestTargetUtils.testMatchesFilters(testTags, requiredTags, excludedTags);
    }

    public static void filterTests(Rule testSuite, Set<Target> tests) {
        List tagsAttribute = (List)((Object)NonconfigurableAttributeMapper.of(testSuite).get("tags", Type.STRING_LIST));
        Pair<Collection<String>, Collection<String>> tagLists = TestTargetUtils.sortTagsBySense(tagsAttribute);
        Collection positiveTags = (Collection)tagLists.first;
        Collection negativeTags = (Collection)tagLists.second;
        tests.removeIf(t2 -> !TestTargetUtils.testMatchesFilters((Rule)t2, (Collection<String>)positiveTags, (Collection<String>)negativeTags));
    }

    public static Pair<Collection<String>, Collection<String>> sortTagsBySense(Iterable<String> tagList) {
        HashSet<String> requiredTags = new HashSet<String>();
        HashSet<String> excludedTags = new HashSet<String>();
        for (String tag : tagList) {
            if (tag.startsWith("-")) {
                excludedTags.add(tag.substring(1));
                continue;
            }
            if (tag.startsWith("+")) {
                requiredTags.add(tag.substring(1));
                continue;
            }
            if (tag.equals("manual")) continue;
            requiredTags.add(tag);
        }
        return Pair.of(requiredTags, excludedTags);
    }
}

