/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.packages.NonconfigurableAttributeMapper;
import com.google.devtools.build.lib.packages.Rule;
import com.google.devtools.build.lib.packages.TargetUtils;
import com.google.devtools.build.lib.packages.TestTargetUtils;
import com.google.devtools.build.lib.packages.Type;
import com.google.devtools.build.lib.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class TestSuiteImplicitTestsAccumulator {
    private final Map<ImmutableSet<String>, ImplicitTestsAccumulator> testSuiteImplicitTests = new HashMap<ImmutableSet<String>, ImplicitTestsAccumulator>();

    TestSuiteImplicitTestsAccumulator() {
    }

    List<Label> getTestSuiteImplicitTestsRefForTags(List<String> tags) {
        ImplicitTestsAccumulator accumulatorForTags = this.testSuiteImplicitTests.computeIfAbsent(ImmutableSet.copyOf(tags), x$0 -> new ImplicitTestsAccumulator((Set<String>)x$0));
        return Collections.unmodifiableList(accumulatorForTags.tests);
    }

    void clearAccumulatedTests() {
        this.testSuiteImplicitTests.values().forEach(acc -> acc.tests.clear());
    }

    void processRule(Rule rule) {
        if (this.testSuiteImplicitTests.isEmpty()) {
            return;
        }
        if (TargetUtils.isTestRule(rule) && !TargetUtils.hasManualTag(rule)) {
            NonconfigurableAttributeMapper mapper = NonconfigurableAttributeMapper.of(rule);
            ImmutableCollection testSuiteTags = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll((Iterable)((Object)mapper.get("tags", Type.STRING_LIST)))).add(mapper.get("size", Type.STRING))).build();
            for (ImplicitTestsAccumulator acc : this.testSuiteImplicitTests.values()) {
                if (!TestTargetUtils.testMatchesFilters(testSuiteTags, acc.requiredTags, acc.excludedTags)) continue;
                acc.tests.add(rule.getLabel());
            }
        }
    }

    void sortTests() {
        this.testSuiteImplicitTests.values().forEach(acc -> Collections.sort(acc.tests));
    }

    private static class ImplicitTestsAccumulator {
        private final Collection<String> requiredTags;
        private final Collection<String> excludedTags;
        private final List<Label> tests = new ArrayList<Label>();

        private ImplicitTestsAccumulator(Set<String> testTags) {
            Pair<Collection<String>, Collection<String>> requiredAndExcludedTags = TestTargetUtils.sortTagsBySense(testTags);
            this.requiredTags = (Collection)requiredAndExcludedTags.first;
            this.excludedTags = (Collection)requiredAndExcludedTags.second;
        }
    }
}

