/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.collect.ImmutableMap;
import com.google.devtools.build.lib.packages.EnumFilterConverter;
import com.google.devtools.build.lib.packages.NonconfigurableAttributeMapper;
import com.google.devtools.build.lib.packages.Rule;
import com.google.devtools.build.lib.packages.TestTimeout;
import com.google.devtools.build.lib.packages.Type;
import com.google.devtools.common.options.OptionsParsingException;
import java.util.Set;
import javax.annotation.Nullable;

public enum TestSize {
    SMALL(TestTimeout.SHORT, 2),
    MEDIUM(TestTimeout.MODERATE, 10),
    LARGE(TestTimeout.LONG, 20),
    ENORMOUS(TestTimeout.ETERNAL, 30);

    private static final ImmutableMap<String, TestSize> CANONICAL_LOWER_CASE_NAME_TABLE;
    private final TestTimeout timeout;
    private final int defaultShards;

    private TestSize(TestTimeout defaultTimeout, int defaultShards) {
        this.timeout = defaultTimeout;
        this.defaultShards = defaultShards;
    }

    public TestTimeout getDefaultTimeout() {
        return this.timeout;
    }

    public int getDefaultShards() {
        return this.defaultShards;
    }

    public static TestSize getTestSize(Rule testTarget) {
        String attr = NonconfigurableAttributeMapper.of(testTarget).get("size", Type.STRING);
        return TestSize.getTestSize(attr);
    }

    @Nullable
    public static TestSize getTestSize(TestTimeout timeout) {
        for (TestSize size : TestSize.values()) {
            if (size.timeout != timeout) continue;
            return size;
        }
        return null;
    }

    @Nullable
    public static TestSize getTestSize(String attr) {
        if (!attr.equals(attr.toLowerCase())) {
            return null;
        }
        try {
            return CANONICAL_LOWER_CASE_NAME_TABLE.get(attr);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String toString() {
        return super.toString().toLowerCase();
    }

    static {
        ImmutableMap.Builder<String, TestSize> builder = ImmutableMap.builder();
        for (TestSize size : TestSize.values()) {
            builder.put(size.name().toLowerCase(), size);
        }
        CANONICAL_LOWER_CASE_NAME_TABLE = builder.buildOrThrow();
    }

    public static class TestSizeFilterConverter
    extends EnumFilterConverter<TestSize> {
        public TestSizeFilterConverter() {
            super(TestSize.class, "test size");
        }

        @Override
        public final Set<TestSize> convert(String input) throws OptionsParsingException {
            return super.convert(input);
        }
    }
}

