/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.packages.AggregatingAttributeMapper;
import com.google.devtools.build.lib.packages.Attribute;
import com.google.devtools.build.lib.packages.BuildType;
import com.google.devtools.build.lib.packages.DependencyFilter;
import com.google.devtools.build.lib.packages.InputFile;
import com.google.devtools.build.lib.packages.NoSuchThingException;
import com.google.devtools.build.lib.packages.NonconfigurableAttributeMapper;
import com.google.devtools.build.lib.packages.Rule;
import com.google.devtools.build.lib.packages.Target;
import com.google.devtools.build.lib.packages.TestTargetUtils;
import com.google.devtools.build.lib.packages.Type;
import com.google.devtools.build.lib.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.starlark.java.eval.Dict;
import net.starlark.java.eval.EvalException;
import net.starlark.java.syntax.Location;

public final class TargetUtils {
    private static final String CONSTRAINTS_ATTR = "tags";

    private static boolean legalExecInfoKeys(String tag) {
        return tag.startsWith("block-") || tag.startsWith("requires-") || tag.startsWith("no-") || tag.startsWith("supports-") || tag.startsWith("disable-") || tag.startsWith("cpu:") || tag.equals("local") || tag.equals("worker-key-mnemonic") || tag.startsWith("resources:");
    }

    private TargetUtils() {
    }

    public static boolean isTestRuleName(String name) {
        return name.endsWith("_test");
    }

    public static boolean isTestSuiteRuleName(String name) {
        return name.equals("test_suite");
    }

    public static boolean isTestRule(Target target) {
        return target instanceof Rule && TargetUtils.isTestRuleName(((Rule)target).getRuleClass());
    }

    public static boolean isTestSuiteRule(Target target) {
        return target instanceof Rule && TargetUtils.isTestSuiteRuleName(((Rule)target).getRuleClass());
    }

    public static boolean isTestOrTestSuiteRule(Target target) {
        return TargetUtils.isTestRule(target) || TargetUtils.isTestSuiteRule(target);
    }

    public static boolean hasManualTag(Target target) {
        return target instanceof Rule && TargetUtils.hasConstraint((Rule)target, "manual");
    }

    public static boolean isExclusiveTestRule(Rule rule) {
        return TargetUtils.hasConstraint(rule, "exclusive");
    }

    public static boolean isExclusiveIfLocalTestRule(Rule rule) {
        return TargetUtils.hasConstraint(rule, "exclusive-if-local");
    }

    public static boolean isLocalTestRule(Rule rule) {
        return TargetUtils.hasConstraint(rule, "local") || NonconfigurableAttributeMapper.of(rule).get("local", Type.BOOLEAN) != false;
    }

    public static boolean isExternalTestRule(Rule rule) {
        return TargetUtils.hasConstraint(rule, "external");
    }

    public static boolean isNoTestloasdTestRule(Rule rule) {
        return TargetUtils.hasConstraint(rule, "no-testloasd");
    }

    public static List<String> getStringListAttr(Target target, String attrName) {
        Preconditions.checkArgument(target instanceof Rule);
        return (List)((Object)NonconfigurableAttributeMapper.of((Rule)target).get(attrName, Type.STRING_LIST));
    }

    public static String getStringAttr(Target target, String attrName) {
        Preconditions.checkArgument(target instanceof Rule);
        return NonconfigurableAttributeMapper.of((Rule)target).get(attrName, Type.STRING);
    }

    public static Iterable<String> getAttrAsString(Target target, String attrName) {
        Preconditions.checkArgument(target instanceof Rule);
        ArrayList<String> values = new ArrayList<String>();
        Attribute attribute = ((Rule)target).getAttributeDefinition(attrName);
        if (attribute != null) {
            Type<?> attributeType = attribute.getType();
            block5: for (Object attrValue : AggregatingAttributeMapper.of((Rule)target).visitAttribute(attribute.getName(), attributeType)) {
                if (attributeType == Type.BOOLEAN) {
                    values.add(Type.BOOLEAN.cast(attrValue) != false ? "1" : "0");
                    continue;
                }
                if (attributeType == BuildType.TRISTATE) {
                    switch (BuildType.TRISTATE.cast(attrValue)) {
                        case AUTO: {
                            values.add("-1");
                            continue block5;
                        }
                        case NO: {
                            values.add("0");
                            continue block5;
                        }
                        case YES: {
                            values.add("1");
                            continue block5;
                        }
                    }
                    throw new AssertionError((Object)"This can't happen!");
                }
                values.add(attrValue == null ? null : attrValue.toString());
            }
        }
        return values;
    }

    @Nullable
    public static String getDeprecation(Target target) {
        if (!(target instanceof Rule)) {
            return null;
        }
        Rule rule = (Rule)target;
        return rule.isAttrDefined("deprecation", Type.STRING) ? NonconfigurableAttributeMapper.of(rule).get("deprecation", Type.STRING) : null;
    }

    private static boolean hasConstraint(Rule rule, String keyword) {
        return ((List)((Object)NonconfigurableAttributeMapper.of(rule).get(CONSTRAINTS_ATTR, Type.STRING_LIST))).contains(keyword);
    }

    public static Map<String, String> getExecutionInfo(Rule rule) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String tag : (List)((Object)NonconfigurableAttributeMapper.of(rule).get(CONSTRAINTS_ATTR, Type.STRING_LIST))) {
            if (!TargetUtils.legalExecInfoKeys(tag)) continue;
            map.put(tag, "");
        }
        return ImmutableMap.copyOf(map);
    }

    public static ImmutableMap<String, String> getExecutionInfo(Rule rule, boolean allowTagsPropagation) {
        if (allowTagsPropagation) {
            return ImmutableMap.copyOf(TargetUtils.getExecutionInfo(rule));
        }
        return ImmutableMap.of();
    }

    public static ImmutableSortedMap<String, String> getFilteredExecutionInfo(@Nullable Object executionRequirementsUnchecked, Rule rule, boolean allowTagsPropagation) throws EvalException {
        Map executionInfo;
        Map<Object, Object> map = executionInfo = executionRequirementsUnchecked == null ? ImmutableMap.of() : TargetUtils.filter(Dict.noneableCast(executionRequirementsUnchecked, String.class, String.class, "execution_requirements"));
        if (allowTagsPropagation) {
            executionInfo = new HashMap(executionInfo);
            Map<String, String> checkedTags = TargetUtils.getExecutionInfo(rule);
            checkedTags.forEach(executionInfo::putIfAbsent);
        }
        return ImmutableSortedMap.copyOf(executionInfo);
    }

    private static Map<String, String> filter(Map<String, String> executionInfo) {
        return Maps.filterKeys(executionInfo, TargetUtils::legalExecInfoKeys);
    }

    public static String getRuleLanguage(Target target) {
        return TargetUtils.getRuleLanguage(((Rule)target).getRuleClass());
    }

    public static String getRuleLanguage(String ruleClass) {
        int index = ruleClass.lastIndexOf(95);
        return index != -1 ? ruleClass.substring(0, index) : ruleClass;
    }

    private static boolean isExplicitDependency(Rule rule, Label label) {
        if (Iterables.contains(rule.getVisibilityDependencyLabels(), label)) {
            return true;
        }
        AggregatingAttributeMapper mapper = AggregatingAttributeMapper.of(rule);
        try {
            mapper.visitLabels(DependencyFilter.NO_IMPLICIT_DEPS, (depLabel, attribute) -> {
                if (label.equals(depLabel)) {
                    throw StopIteration.INSTANCE;
                }
            });
        }
        catch (StopIteration e) {
            return true;
        }
        return false;
    }

    public static Predicate<Target> tagFilter(List<String> tagFilterList) {
        Pair<Collection<String>, Collection<String>> tagLists = TestTargetUtils.sortTagsBySense(tagFilterList);
        Collection requiredTags = (Collection)tagLists.first;
        Collection excludedTags = (Collection)tagLists.second;
        return input -> {
            if (requiredTags.isEmpty() && excludedTags.isEmpty()) {
                return true;
            }
            if (!(input instanceof Rule)) {
                return requiredTags.isEmpty();
            }
            return TestTargetUtils.testMatchesFilters(((Rule)input).getRuleTags(), requiredTags, excludedTags, false);
        };
    }

    @Nullable
    public static Location getLocationMaybe(Target target) {
        return target instanceof Rule || target instanceof InputFile ? target.getLocation() : null;
    }

    public static String formatMissingEdge(@Nullable Target target, Label label, NoSuchThingException e, @Nullable Attribute attr) {
        if (target instanceof Rule) {
            Rule rule = (Rule)target;
            if (TargetUtils.isExplicitDependency(rule, label)) {
                return String.format("%s and referenced by '%s'", e.getMessage(), target.getLabel());
            }
            String additionalInfo = "";
            if (attr != null && !Strings.isNullOrEmpty(attr.getDoc())) {
                additionalInfo = String.format("\nDocumentation for implicit attribute %s of rules of type %s:\n%s", attr.getPublicName(), rule.getRuleClass(), attr.getDoc());
            }
            return String.format("every rule of type %s implicitly depends upon the target '%s', but this target could not be found because of: %s%s", rule.getRuleClass(), label, e.getMessage(), additionalInfo);
        }
        if (target instanceof InputFile) {
            return e.getMessage() + " (this is usually caused by a missing package group in the package-level visibility declaration)";
        }
        if (target != null) {
            return String.format("in target '%s', no such label '%s': %s", target.getLabel(), label, e.getMessage());
        }
        return e.getMessage();
    }

    public static String formatMissingEdge(@Nullable Target target, Label label, NoSuchThingException e) {
        return TargetUtils.formatMissingEdge(target, label, e, null);
    }

    private static final class StopIteration
    extends RuntimeException {
        private static final StopIteration INSTANCE = new StopIteration();

        private StopIteration() {
        }
    }
}

