/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

public final class SymbolGenerator<T> {
    private final T owner;
    private int index = 0;

    public SymbolGenerator(T owner) {
        this.owner = owner;
    }

    public synchronized Symbol<T> generate() {
        return new Symbol<T>(this.owner, this.index++);
    }

    private static final class Symbol<T> {
        private final T owner;
        private final int index;

        private Symbol(T owner, int index) {
            this.owner = owner;
            this.index = index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Symbol)) {
                return false;
            }
            Symbol symbol = (Symbol)o;
            return this.index == symbol.index && this.owner.equals(symbol.owner);
        }

        public int hashCode() {
            return this.owner.hashCode();
        }

        public String toString() {
            return "<symbol=" + this.owner + ", index=" + this.index + ">";
        }
    }
}

