/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Ordering;
import com.google.devtools.build.lib.packages.Info;
import com.google.devtools.build.lib.packages.Proto;
import com.google.devtools.build.lib.starlarkbuildapi.core.StructApi;
import com.google.protobuf.TextFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.starlark.java.eval.Dict;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Printer;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkInt;
import net.starlark.java.eval.Structure;
import net.starlark.java.syntax.Location;

public abstract class StructImpl
implements Info,
Structure,
StructApi {
    private final Location location;

    protected StructImpl(@Nullable Location location) {
        this.location = location != null ? location : Location.BUILTIN;
    }

    @Override
    public Location getCreationLocation() {
        return this.location;
    }

    public final <T> T getValue(String key, Class<T> type) throws EvalException {
        Object obj = this.getValue(key);
        if (obj == null) {
            return null;
        }
        try {
            return type.cast(obj);
        }
        catch (ClassCastException unused) {
            throw Starlark.errorf("for %s field, got %s, want %s", key, Starlark.type(obj), Starlark.classType(type));
        }
    }

    @Override
    public String getErrorMessageForUnknownField(String name) {
        return this.getProvider().getErrorMessageForUnknownField(name) + this.allAttributesSuffix();
    }

    final String allAttributesSuffix() {
        return "\nAvailable attributes: " + Joiner.on(", ").join(Ordering.natural().sortedCopy(this.getFieldNames()));
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof StructImpl)) {
            return false;
        }
        StructImpl other = (StructImpl)otherObject;
        if (this == other) {
            return true;
        }
        if (!this.getProvider().equals(other.getProvider())) {
            return false;
        }
        if (!this.getFieldNames().equals(other.getFieldNames())) {
            return false;
        }
        for (String field : this.getFieldNames()) {
            if (Objects.equal(this.getValueOrNull(field), other.getValueOrNull(field))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        ArrayList<String> fields = new ArrayList<String>(this.getFieldNames());
        Collections.sort(fields);
        ArrayList<Object> objectsToHash = new ArrayList<Object>();
        objectsToHash.add(this.getProvider());
        for (String field : fields) {
            objectsToHash.add(field);
            objectsToHash.add(this.getValueOrNull(field));
        }
        return Objects.hashCode(objectsToHash.toArray());
    }

    @Override
    public void repr(Printer printer) {
        boolean first = true;
        printer.append("struct(");
        for (String fieldName : Ordering.natural().sortedCopy(this.getFieldNames())) {
            if (!first) {
                printer.append(", ");
            }
            first = false;
            printer.append(fieldName);
            printer.append(" = ");
            printer.repr(this.getValueOrNull(fieldName));
        }
        printer.append(")");
    }

    @Nullable
    private Object getValueOrNull(String name) {
        try {
            return this.getValue(name);
        }
        catch (EvalException e) {
            return null;
        }
    }

    @Override
    public String toProto() throws EvalException {
        return Proto.INSTANCE.encodeText(this);
    }

    private static String escapeDoubleQuotesAndBackslashesAndNewlines(String string) {
        return TextFormat.escapeDoubleQuotesAndBackslashes(string).replace("\n", "\\n");
    }

    @Override
    public String toJson() throws EvalException {
        StringBuilder sb = new StringBuilder();
        StructImpl.printJson(this, sb, "struct field", null);
        return sb.toString();
    }

    private static void printJson(Object value, StringBuilder sb, String container, String key) throws EvalException {
        if (value == Starlark.NONE) {
            sb.append("null");
        } else if (value instanceof Structure) {
            sb.append("{");
            String join = "";
            for (String field : ((Structure)value).getFieldNames()) {
                sb.append(join);
                join = ",";
                StructImpl.appendJSONStringLiteral(sb, field);
                sb.append(':');
                StructImpl.printJson(((Structure)value).getValue(field), sb, "struct field", field);
            }
            sb.append("}");
        } else if (value instanceof Dict) {
            sb.append("{");
            String join = "";
            for (Map.Entry entry : ((Dict)value).entrySet()) {
                sb.append(join);
                join = ",";
                if (!(entry.getKey() instanceof String)) {
                    throw Starlark.errorf("Keys must be a string but got a %s for %s%s", Starlark.type(entry.getKey()), container, key != null ? " '" + key + "'" : "");
                }
                StructImpl.appendJSONStringLiteral(sb, (String)entry.getKey());
                sb.append(':');
                StructImpl.printJson(entry.getValue(), sb, "dict value", String.valueOf(entry.getKey()));
            }
            sb.append("}");
        } else if (value instanceof List) {
            sb.append("[");
            String join = "";
            for (Object item : (List)value) {
                sb.append(join);
                join = ",";
                StructImpl.printJson(item, sb, "list element in struct field", key);
            }
            sb.append("]");
        } else if (value instanceof String) {
            StructImpl.appendJSONStringLiteral(sb, (String)value);
        } else if (value instanceof StarlarkInt || value instanceof Boolean) {
            sb.append(value);
        } else {
            throw Starlark.errorf("Invalid text format, expected a struct, a string, a bool, or an int but got a %s for %s%s", Starlark.type(value), container, key != null ? " '" + key + "'" : "");
        }
    }

    private static void appendJSONStringLiteral(StringBuilder out, String s2) {
        out.append('\"');
        out.append(StructImpl.escapeDoubleQuotesAndBackslashesAndNewlines(s2).replace("\r", "\\r").replace("\t", "\\t"));
        out.append('\"');
    }

    public String toString() {
        return Starlark.repr(this);
    }
}

