/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Preconditions;
import com.google.common.collect.Interner;
import com.google.devtools.build.lib.concurrent.BlazeInterners;
import com.google.devtools.build.lib.packages.Provider;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.AutoCodec;
import com.google.devtools.build.lib.util.Fingerprint;
import java.util.Objects;
import javax.annotation.Nullable;

@AutoCodec
public final class StarlarkProviderIdentifier {
    private static final Interner<StarlarkProviderIdentifier> interner = BlazeInterners.newWeakInterner();
    @Nullable
    private final String legacyId;
    @Nullable
    private final Provider.Key key;

    @AutoCodec.Instantiator
    public static StarlarkProviderIdentifier forKey(Provider.Key key) {
        return interner.intern(new StarlarkProviderIdentifier(key));
    }

    public static StarlarkProviderIdentifier forLegacy(String legacyId) {
        return interner.intern(new StarlarkProviderIdentifier(legacyId));
    }

    private StarlarkProviderIdentifier(String legacyId) {
        this.legacyId = legacyId;
        this.key = null;
    }

    private StarlarkProviderIdentifier(Provider.Key key) {
        this.legacyId = null;
        this.key = key;
    }

    public boolean isLegacy() {
        return this.legacyId != null;
    }

    public String getLegacyId() {
        Preconditions.checkState(this.isLegacy(), "Check isLegacy() first");
        return this.legacyId;
    }

    public Provider.Key getKey() {
        Preconditions.checkState(!this.isLegacy(), "Check !isLegacy() first");
        return this.key;
    }

    void fingerprint(Fingerprint fp) {
        if (this.isLegacy()) {
            fp.addBoolean(true);
            fp.addString(this.legacyId);
        } else {
            fp.addBoolean(false);
            this.key.fingerprint(fp);
        }
    }

    public String toString() {
        if (this.isLegacy()) {
            return this.legacyId;
        }
        return this.key.toString();
    }

    public int hashCode() {
        return this.legacyId != null ? this.legacyId.hashCode() * 2 : this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StarlarkProviderIdentifier)) {
            return false;
        }
        StarlarkProviderIdentifier other = (StarlarkProviderIdentifier)obj;
        return Objects.equals(this.legacyId, other.legacyId) && Objects.equals(this.key, other.key);
    }
}

