/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.collect.nestedset.Depset;
import com.google.devtools.build.lib.collect.nestedset.NestedSet;
import com.google.devtools.build.lib.events.EventHandler;
import com.google.devtools.build.lib.packages.Provider;
import com.google.devtools.build.lib.packages.StarlarkExportable;
import com.google.devtools.build.lib.packages.StarlarkInfo;
import com.google.devtools.build.lib.packages.StarlarkInfoNoSchema;
import com.google.devtools.build.lib.packages.StarlarkInfoWithSchema;
import com.google.devtools.build.lib.util.Fingerprint;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReferenceArray;
import javax.annotation.Nullable;
import net.starlark.java.eval.Dict;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Printer;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkCallable;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.syntax.Location;

public final class StarlarkProvider
implements StarlarkCallable,
StarlarkExportable,
Provider {
    private final Location location;
    @Nullable
    private final String documentation;
    @Nullable
    private final ImmutableList<String> fields;
    @Nullable
    private final ImmutableMap<String, Optional<String>> schema;
    @Nullable
    private final StarlarkCallable init;
    @Nullable
    private Key key;
    @Nullable
    private transient AtomicReferenceArray<Class<?>> depsetTypePredictor;

    public static Builder builder(Location location) {
        return new Builder(location);
    }

    private StarlarkProvider(Location location, @Nullable String documentation, @Nullable ImmutableMap<String, Optional<String>> schema, @Nullable StarlarkCallable init, @Nullable Key key) {
        this.location = location;
        this.documentation = documentation;
        this.fields = schema != null ? ImmutableList.sortedCopyOf(schema.keySet()) : null;
        this.schema = schema;
        this.init = init;
        this.key = key;
        if (schema != null) {
            this.depsetTypePredictor = new AtomicReferenceArray(schema.size());
        }
    }

    private static Object[] toNamedArgs(Object value, String descriptionForError) throws EvalException {
        Dict<String, Object> kwargs = Dict.cast(value, String.class, Object.class, descriptionForError);
        Object[] named = new Object[2 * kwargs.size()];
        int i = 0;
        for (Map.Entry<String, Object> e : kwargs.entrySet()) {
            named[i++] = e.getKey();
            named[i++] = e.getValue();
        }
        return named;
    }

    @Override
    public Object fastcall(StarlarkThread thread, Object[] positional, Object[] named) throws InterruptedException, EvalException {
        if (this.init == null) {
            return this.fastcallRawConstructor(thread, positional, named);
        }
        Object initResult = Starlark.fastcall(thread, this.init, positional, named);
        return this.createFromNamedArgs(StarlarkProvider.toNamedArgs(initResult, "return value of provider init()"), thread.getCallerLocation());
    }

    private Object fastcallRawConstructor(StarlarkThread thread, Object[] positional, Object[] named) throws EvalException {
        if (positional.length > 0) {
            throw Starlark.errorf("%s: unexpected positional arguments", this.getName());
        }
        return this.createFromNamedArgs(named, thread.getCallerLocation());
    }

    private StarlarkInfo createFromNamedArgs(Object[] named, Location loc) throws EvalException {
        return this.schema != null ? StarlarkInfoWithSchema.createFromNamedArgs(this, named, loc) : StarlarkInfoNoSchema.createFromNamedArgs(this, named, loc);
    }

    public StarlarkCallable createRawConstructor() {
        return new RawConstructor(this);
    }

    @Nullable
    @VisibleForTesting
    public StarlarkCallable getInit() {
        return this.init;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public Optional<String> getDocumentation() {
        return Optional.ofNullable(this.documentation);
    }

    @Override
    public boolean isExported() {
        return this.key != null;
    }

    @Override
    public Key getKey() {
        Preconditions.checkState(this.isExported());
        return this.key;
    }

    @Override
    public String getName() {
        return this.key != null ? this.key.getExportedName() : "<no name>";
    }

    @Override
    public String getPrintableName() {
        return this.getName();
    }

    @Nullable
    public ImmutableList<String> getFields() {
        return this.fields;
    }

    @Nullable
    public ImmutableMap<String, Optional<String>> getSchema() {
        return this.schema;
    }

    @Override
    public String getErrorMessageForUnknownField(String name) {
        return String.format("'%s' value has no field or method '%s'", this.isExported() ? this.key.getExportedName() : "struct", name);
    }

    @Override
    public void export(EventHandler handler, Label extensionLabel, String exportedName) {
        Preconditions.checkState(!this.isExported());
        this.key = new Key(extensionLabel, exportedName);
    }

    public int hashCode() {
        if (this.isExported()) {
            return this.getKey().hashCode();
        }
        return System.identityHashCode(this);
    }

    public boolean equals(@Nullable Object otherObject) {
        if (!(otherObject instanceof StarlarkProvider)) {
            return false;
        }
        StarlarkProvider other = (StarlarkProvider)otherObject;
        if (this.isExported() && other.isExported()) {
            return this.getKey().equals(other.getKey());
        }
        return this == other;
    }

    @Override
    public boolean isImmutable() {
        return this.isExported();
    }

    @Override
    public void repr(Printer printer) {
        printer.append("<provider>");
    }

    public String toString() {
        return Starlark.repr(this);
    }

    Object optimizeField(int index, Object value) {
        if (value instanceof Depset) {
            Preconditions.checkArgument(this.depsetTypePredictor != null);
            Depset depset = (Depset)value;
            if (depset.isEmpty()) {
                return depset.getSet();
            }
            Class<?> elementClass = depset.getElementClass();
            if (this.depsetTypePredictor.compareAndExchange(index, null, elementClass) == elementClass) {
                return depset.getSet();
            }
        }
        return value;
    }

    Object retrieveOptimizedField(int index, Object value) {
        if (value instanceof NestedSet) {
            NestedSet nestedSet = (NestedSet)value;
            if (nestedSet.isEmpty()) {
                return Depset.of(Object.class, nestedSet);
            }
            Depset depset = Depset.of(this.depsetTypePredictor.get(index), nestedSet);
            return depset;
        }
        return value;
    }

    boolean isOptimised(int index, Object value) {
        return value instanceof NestedSet;
    }

    public static final class Key
    extends Provider.Key {
        private final Label extensionLabel;
        private final String exportedName;

        public Key(Label extensionLabel, String exportedName) {
            this.extensionLabel = Preconditions.checkNotNull(extensionLabel);
            this.exportedName = Preconditions.checkNotNull(exportedName);
        }

        public Label getExtensionLabel() {
            return this.extensionLabel;
        }

        public String getExportedName() {
            return this.exportedName;
        }

        public String toString() {
            return this.exportedName;
        }

        @Override
        void fingerprint(Fingerprint fp) {
            fp.addBoolean(false);
            fp.addString(this.extensionLabel.getCanonicalForm());
            fp.addString(this.exportedName);
        }

        public int hashCode() {
            return Objects.hash(this.extensionLabel, this.exportedName);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return Objects.equals(this.extensionLabel, other.extensionLabel) && Objects.equals(this.exportedName, other.exportedName);
        }
    }

    private static final class RawConstructor
    implements StarlarkCallable {
        private final StarlarkProvider provider;

        private RawConstructor(StarlarkProvider provider) {
            this.provider = provider;
        }

        @Override
        public Object fastcall(StarlarkThread thread, Object[] positional, Object[] named) throws EvalException {
            return this.provider.fastcallRawConstructor(thread, positional, named);
        }

        @Override
        public String getName() {
            StringBuilder name = new StringBuilder("<raw constructor");
            if (this.provider.isExported()) {
                name.append(" for ").append(this.provider.getName());
            }
            name.append(">");
            return name.toString();
        }

        @Override
        public Location getLocation() {
            return this.provider.location;
        }
    }

    public static final class Builder {
        private final Location location;
        @Nullable
        private String documentation;
        @Nullable
        private ImmutableMap<String, Optional<String>> schema;
        @Nullable
        private StarlarkCallable init;
        @Nullable
        private Key key;

        private Builder(Location location) {
            this.location = location;
        }

        @CanIgnoreReturnValue
        public Builder setSchema(Collection<String> fields) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (String field : fields) {
                builder.put(field, Optional.empty());
            }
            this.schema = builder.buildOrThrow();
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setSchema(Map<String, String> schemaWithDocumentation) {
            ImmutableMap.Builder<String, Optional<String>> builder = ImmutableMap.builder();
            for (Map.Entry<String, String> entry : schemaWithDocumentation.entrySet()) {
                builder.put(entry.getKey(), Optional.of(entry.getValue()));
            }
            this.schema = builder.buildOrThrow();
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setDocumentation(String documentation) {
            this.documentation = documentation;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setInit(StarlarkCallable init) {
            this.init = init;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setExported(Key key) {
            this.key = key;
            return this;
        }

        public StarlarkProvider build() {
            return new StarlarkProvider(this.location, this.documentation, this.schema, this.init, this.key);
        }
    }
}

