/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.flogger.GoogleLogger;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.cmdline.LabelSyntaxException;
import com.google.devtools.build.lib.cmdline.LabelValidator;
import com.google.devtools.build.lib.cmdline.PackageIdentifier;
import com.google.devtools.build.lib.events.Event;
import com.google.devtools.build.lib.io.FileSymlinkException;
import com.google.devtools.build.lib.packages.Attribute;
import com.google.devtools.build.lib.packages.BazelStarlarkContext;
import com.google.devtools.build.lib.packages.BuildType;
import com.google.devtools.build.lib.packages.Globber;
import com.google.devtools.build.lib.packages.InputFile;
import com.google.devtools.build.lib.packages.License;
import com.google.devtools.build.lib.packages.Package;
import com.google.devtools.build.lib.packages.PackageFactory;
import com.google.devtools.build.lib.packages.Rule;
import com.google.devtools.build.lib.packages.RuleClass;
import com.google.devtools.build.lib.packages.RuleVisibility;
import com.google.devtools.build.lib.packages.SelectorList;
import com.google.devtools.build.lib.packages.SelectorValue;
import com.google.devtools.build.lib.packages.Target;
import com.google.devtools.build.lib.packages.TriState;
import com.google.devtools.build.lib.packages.Type;
import com.google.devtools.build.lib.server.FailureDetails;
import com.google.devtools.build.lib.starlarkbuildapi.StarlarkNativeModuleApi;
import com.google.devtools.build.lib.util.DetailedExitCode;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;
import net.starlark.java.annot.Param;
import net.starlark.java.annot.StarlarkMethod;
import net.starlark.java.eval.Dict;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Mutability;
import net.starlark.java.eval.NoneType;
import net.starlark.java.eval.Printer;
import net.starlark.java.eval.Sequence;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkIndexable;
import net.starlark.java.eval.StarlarkInt;
import net.starlark.java.eval.StarlarkIterable;
import net.starlark.java.eval.StarlarkList;
import net.starlark.java.eval.StarlarkSemantics;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.eval.StarlarkValue;
import net.starlark.java.eval.Tuple;
import net.starlark.java.syntax.Location;

public class StarlarkNativeModule
implements StarlarkNativeModuleApi {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    public static final ImmutableMap<String, Object> BINDINGS_FOR_BUILD_FILES = StarlarkNativeModule.initializeBindings();

    private static ImmutableMap<String, Object> initializeBindings() {
        ImmutableMap.Builder<String, Object> bindings = ImmutableMap.builder();
        Starlark.addMethods(bindings, new StarlarkNativeModule());
        return bindings.buildOrThrow();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Sequence<?> glob(Sequence<?> include, Sequence<?> exclude, StarlarkInt excludeDirs, Object allowEmptyArgument, StarlarkThread thread) throws EvalException, InterruptedException {
        boolean allowEmpty;
        Globber.Operation op;
        BazelStarlarkContext.from(thread).checkLoadingPhase("native.glob");
        PackageFactory.PackageContext context = PackageFactory.getContext(thread);
        List includes = (List)Type.STRING_LIST.convert(include, "'glob' argument");
        List excludes = (List)Type.STRING_LIST.convert(exclude, "'glob' argument");
        Globber.Operation operation = op = excludeDirs.signum() != 0 ? Globber.Operation.FILES : Globber.Operation.FILES_AND_DIRS;
        if (allowEmptyArgument == Starlark.UNBOUND) {
            allowEmpty = !thread.getSemantics().getBool("-incompatible_disallow_empty_glob");
        } else if (allowEmptyArgument instanceof Boolean) {
            allowEmpty = (Boolean)allowEmptyArgument;
        } else {
            throw Starlark.errorf("expected boolean for argument `allow_empty`, got `%s`", allowEmptyArgument);
        }
        List<String> matches = this.runGlobOperation(context, thread, includes, excludes, op, allowEmpty);
        ArrayList result = new ArrayList(matches.size());
        for (String string : matches) {
            void var14_14;
            if (string.charAt(0) == '@') {
                String string2 = ":" + string;
            }
            result.add(var14_14);
        }
        result.sort(Comparator.naturalOrder());
        return StarlarkList.copyOf(thread.mutability(), result);
    }

    @Override
    public Object existingRule(String name, StarlarkThread thread) throws EvalException {
        if (thread.getThreadLocal(ExistingRulesShouldBeNoOp.class) != null) {
            return Starlark.NONE;
        }
        BazelStarlarkContext.from(thread).checkLoadingOrWorkspacePhase("native.existing_rule");
        PackageFactory.PackageContext context = PackageFactory.getContext(thread);
        Target target = context.pkgBuilder.getTarget(name);
        if (target instanceof Rule) {
            Rule rule = (Rule)target;
            if (thread.getSemantics().getBool("+incompatible_existing_rules_immutable_view")) {
                return new ExistingRuleView(rule);
            }
            return StarlarkNativeModule.getRuleDict(rule, thread.mutability());
        }
        return Starlark.NONE;
    }

    @Override
    public Object existingRules(StarlarkThread thread) throws EvalException {
        if (thread.getThreadLocal(ExistingRulesShouldBeNoOp.class) != null) {
            return Dict.empty();
        }
        BazelStarlarkContext.from(thread).checkLoadingOrWorkspacePhase("native.existing_rules");
        PackageFactory.PackageContext context = PackageFactory.getContext(thread);
        if (thread.getSemantics().getBool("+incompatible_existing_rules_immutable_view")) {
            return new ExistingRulesView(context.pkgBuilder.getRulesSnapshotView());
        }
        Set<Target> targets = context.pkgBuilder.getTargets();
        Mutability mu = thread.mutability();
        Dict.Builder<String, Dict<String, Object>> rules = Dict.builder();
        for (Target t2 : targets) {
            if (!(t2 instanceof Rule)) continue;
            rules.put(t2.getName(), StarlarkNativeModule.getRuleDict((Rule)t2, mu));
        }
        return rules.build(mu);
    }

    @Override
    public NoneType packageGroup(String name, Sequence<?> packagesO, Sequence<?> includesO, StarlarkThread thread) throws EvalException {
        BazelStarlarkContext.from(thread).checkLoadingPhase("native.package_group");
        PackageFactory.PackageContext context = PackageFactory.getContext(thread);
        List packages = (List)Type.STRING_LIST.convert(packagesO, "'package_group.packages argument'");
        Object includes = BuildType.LABEL_LIST.convert(includesO, "'package_group.includes argument'", context.pkgBuilder.getLabelConverter());
        Location loc = thread.getCallerLocation();
        try {
            context.pkgBuilder.addPackageGroup(name, packages, (Collection<Label>)includes, thread.getSemantics().getBool("+incompatible_package_group_has_public_syntax"), thread.getSemantics().getBool("+incompatible_fix_package_group_reporoot_syntax"), context.eventHandler, loc);
            return Starlark.NONE;
        }
        catch (LabelSyntaxException e) {
            throw Starlark.errorf("package group has invalid name: %s: %s", name, e.getMessage());
        }
        catch (Package.NameConflictException e) {
            throw new EvalException(e);
        }
    }

    @Override
    public NoneType exportsFiles(Sequence<?> srcs, Object visibilityO, Object licensesO, StarlarkThread thread) throws EvalException {
        BazelStarlarkContext.from(thread).checkLoadingPhase("native.exports_files");
        Package.Builder pkgBuilder = PackageFactory.getContext((StarlarkThread)thread).pkgBuilder;
        List files = (List)Type.STRING_LIST.convert(srcs, "'exports_files' operand");
        RuleVisibility visibility = Starlark.isNullOrNone(visibilityO) ? RuleVisibility.PUBLIC : RuleVisibility.parse((List<Label>)BuildType.LABEL_LIST.convert(visibilityO, "'exports_files' operand", pkgBuilder.getLabelConverter()));
        License license = BuildType.LICENSE.convertOptional(licensesO, "'exports_files' operand");
        Location loc = thread.getCallerLocation();
        for (String file : files) {
            String errorMessage = LabelValidator.validateTargetName(file);
            if (errorMessage != null) {
                throw Starlark.errorf("%s", errorMessage);
            }
            try {
                InputFile inputFile = pkgBuilder.createInputFile(file, loc);
                if (inputFile.isVisibilitySpecified() && inputFile.getVisibility() != visibility) {
                    throw Starlark.errorf("visibility for exported file '%s' declared twice", inputFile.getName());
                }
                if (license != null && inputFile.isLicenseSpecified()) {
                    throw Starlark.errorf("licenses for exported file '%s' declared twice", inputFile.getName());
                }
                pkgBuilder.setVisibilityAndLicense(inputFile, visibility, license);
            }
            catch (Package.Builder.GeneratedLabelConflict e) {
                throw Starlark.errorf("%s", e.getMessage());
            }
        }
        return Starlark.NONE;
    }

    @Override
    public String packageName(StarlarkThread thread) throws EvalException {
        BazelStarlarkContext.from(thread).checkLoadingPhase("native.package_name");
        PackageIdentifier packageId = PackageFactory.getContext(thread).getBuilder().getPackageIdentifier();
        return packageId.getPackageFragment().getPathString();
    }

    @Override
    public String repositoryName(StarlarkThread thread) throws EvalException {
        BazelStarlarkContext.from(thread).checkLoadingPhase("native.repository_name");
        PackageIdentifier packageId = PackageFactory.getContext(thread).getBuilder().getPackageIdentifier();
        return packageId.getRepository().getNameWithAt();
    }

    @Override
    public Label packageRelativeLabel(Object input, StarlarkThread thread) throws EvalException {
        BazelStarlarkContext.from(thread).checkLoadingPhase("native.package_relative_label");
        if (input instanceof Label) {
            return (Label)input;
        }
        try {
            String s2 = (String)input;
            return PackageFactory.getContext(thread).getBuilder().getLabelConverter().convert(s2);
        }
        catch (LabelSyntaxException e) {
            throw Starlark.errorf("invalid label in native.package_relative_label: %s", e.getMessage());
        }
    }

    @Override
    @Nullable
    public String moduleName(StarlarkThread thread) throws EvalException {
        BazelStarlarkContext.from(thread).checkLoadingPhase("native.module_name");
        return PackageFactory.getContext(thread).getBuilder().getAssociatedModuleName().orElse(null);
    }

    @Override
    @Nullable
    public String moduleVersion(StarlarkThread thread) throws EvalException {
        BazelStarlarkContext.from(thread).checkLoadingPhase("native.module_version");
        return PackageFactory.getContext(thread).getBuilder().getAssociatedModuleVersion().orElse(null);
    }

    private static Dict<String, Object> getRuleDict(Rule rule, Mutability mu) throws EvalException {
        Dict.Builder<String, Object> values = Dict.builder();
        for (Attribute attr : rule.getAttributes()) {
            Object val;
            if (!StarlarkNativeModule.isPotentiallyExportableAttribute(rule.getRuleClassObject(), attr.getName()) || (val = StarlarkNativeModule.starlarkifyValue(mu, rule.getAttr(attr.getName()), rule.getPackage())) == null) continue;
            values.put(attr.getName(), val);
        }
        values.put("name", rule.getName());
        values.put("kind", rule.getRuleClass());
        return values.build(mu);
    }

    private static boolean isPotentiallyExportableAttribute(RuleClass ruleClass, String attributeName) {
        Attribute attr;
        if (attributeName.length() == 0 || !Character.isAlphabetic(attributeName.charAt(0))) {
            return false;
        }
        return !attributeName.equals("distribs") || (attr = ruleClass.getAttributeByName(attributeName)) == null || attr.getType() != BuildType.DISTRIBUTIONS;
    }

    private static boolean isPotentiallyStarlarkifiableValue(@Nullable Object val) {
        if (val == null) {
            return false;
        }
        if (val.getClass().isAnonymousClass()) {
            return false;
        }
        return !(val instanceof License);
    }

    @Nullable
    private static Object starlarkifyValue(Mutability mu, Object val, Package pkg) {
        if (!StarlarkNativeModule.isPotentiallyStarlarkifiableValue(val)) {
            return null;
        }
        if (val instanceof Boolean || val instanceof String || val instanceof StarlarkInt) {
            return val;
        }
        if (val instanceof TriState) {
            switch ((TriState)((Object)val)) {
                case AUTO: {
                    return StarlarkInt.of(-1);
                }
                case YES: {
                    return StarlarkInt.of(1);
                }
                case NO: {
                    return StarlarkInt.of(0);
                }
            }
        }
        if (val instanceof Label) {
            Label l = (Label)val;
            if (l.getPackageName().equals(pkg.getName())) {
                return ":" + l.getName();
            }
            return l.getCanonicalForm();
        }
        if (val instanceof List) {
            ArrayList<Object> l = new ArrayList<Object>();
            for (Object e : (List)val) {
                Object elt = StarlarkNativeModule.starlarkifyValue(mu, e, pkg);
                if (elt == null) continue;
                l.add(elt);
            }
            return Tuple.copyOf(l);
        }
        if (val instanceof Map) {
            Dict.Builder<Object, Object> m4 = Dict.builder();
            for (Map.Entry entry : ((Map)val).entrySet()) {
                Object key = StarlarkNativeModule.starlarkifyValue(mu, entry.getKey(), pkg);
                Object mapVal = StarlarkNativeModule.starlarkifyValue(mu, entry.getValue(), pkg);
                if (key == null || mapVal == null) continue;
                m4.put(key, mapVal);
            }
            return m4.build(mu);
        }
        if (val instanceof BuildType.SelectorList) {
            ArrayList<SelectorValue> selectors = new ArrayList<SelectorValue>();
            for (BuildType.Selector<Object> selector : ((BuildType.SelectorList)val).getSelectors()) {
                Dict.Builder m5 = Dict.builder();
                selector.forEach((rawKey, rawValue) -> {
                    Object key = StarlarkNativeModule.starlarkifyValue(mu, rawKey, pkg);
                    Object mapVal = StarlarkNativeModule.starlarkifyValue(mu, rawValue, pkg);
                    if (key != null && mapVal != null) {
                        m5.put(key, mapVal);
                    }
                });
                selectors.add(new SelectorValue(m5.build(mu), selector.getNoMatchError()));
            }
            try {
                return SelectorList.of(selectors);
            }
            catch (EvalException e) {
                return null;
            }
        }
        if (val instanceof StarlarkValue) {
            return val;
        }
        return null;
    }

    @Override
    public Sequence<?> subpackages(Sequence<?> include, Sequence<?> exclude, boolean allowEmpty, StarlarkThread thread) throws EvalException, InterruptedException {
        BazelStarlarkContext.from(thread).checkLoadingPhase("native.subpackages");
        PackageFactory.PackageContext context = PackageFactory.getContext(thread);
        List includes = (List)Type.STRING_LIST.convert(include, "'subpackages' argument");
        List excludes = (List)Type.STRING_LIST.convert(exclude, "'subpackages' argument");
        List<String> matches = this.runGlobOperation(context, thread, includes, excludes, Globber.Operation.SUBPACKAGES, allowEmpty);
        if (!matches.isEmpty()) {
            try {
                matches.sort(Comparator.naturalOrder());
            }
            catch (UnsupportedOperationException e) {
                matches = ImmutableList.sortedCopyOf(Comparator.naturalOrder(), matches);
            }
        }
        return StarlarkList.copyOf(thread.mutability(), matches);
    }

    private List<String> runGlobOperation(PackageFactory.PackageContext context, StarlarkThread thread, List<String> includes, List<String> excludes, Globber.Operation operation, boolean allowEmpty) throws EvalException, InterruptedException {
        try {
            Globber.Token globToken = context.globber.runAsync(includes, excludes, operation, allowEmpty);
            return context.globber.fetchUnsorted(globToken);
        }
        catch (IOException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("Exception processing includes=%s, excludes=%s)", includes, excludes);
            String errorMessage = String.format("error globbing [%s]%s op=%s: %s", new Object[]{Joiner.on(", ").join(includes), excludes.isEmpty() ? "" : " - [" + Joiner.on(", ").join(excludes) + "]", operation, e.getMessage()});
            Location loc = thread.getCallerLocation();
            Event error = Package.error(loc, errorMessage, e instanceof FileSymlinkException ? FailureDetails.PackageLoading.Code.EVAL_GLOBS_SYMLINK_ERROR : FailureDetails.PackageLoading.Code.GLOB_IO_EXCEPTION);
            context.eventHandler.handle(error);
            context.pkgBuilder.setIOException(e, errorMessage, error.getProperty(DetailedExitCode.class));
            return ImmutableList.of();
        }
        catch (Globber.BadGlobException e) {
            throw new EvalException(e);
        }
    }

    private static final class ExistingRulesView
    implements DictLikeView {
        private final Map<String, Rule> rulesSnapshotView;

        ExistingRulesView(Map<String, Rule> rulesSnapshotView) {
            this.rulesSnapshotView = rulesSnapshotView;
        }

        @Override
        public void repr(Printer printer) {
            printer.append("<native.ExistingRulesView object>");
        }

        @Override
        @Nullable
        public Object getOrDefault(Object key, @Nullable Object defaultValue) {
            if (!(key instanceof String)) {
                return defaultValue;
            }
            Rule rule = this.rulesSnapshotView.get(key);
            if (rule != null) {
                return new ExistingRuleView(rule);
            }
            return defaultValue;
        }

        @Override
        public Iterator<String> iterator() {
            return this.rulesSnapshotView.keySet().iterator();
        }

        @Override
        public boolean containsKey(Object key) {
            if (!(key instanceof String)) {
                return false;
            }
            return this.rulesSnapshotView.containsKey(key);
        }

        @Override
        public int size() {
            return this.rulesSnapshotView.size();
        }
    }

    private static final class ExistingRuleView
    implements DictLikeView {
        private final Rule rule;

        ExistingRuleView(Rule rule) {
            this.rule = rule;
        }

        @Override
        public void repr(Printer printer) {
            printer.append("<native.ExistingRuleView for target '").append(this.rule.getName()).append("'>");
        }

        @Nullable
        private Object starlarkifyAttribute(String attributeName) {
            if (!StarlarkNativeModule.isPotentiallyExportableAttribute(this.rule.getRuleClassObject(), attributeName)) {
                return null;
            }
            return StarlarkNativeModule.starlarkifyValue(null, this.rule.getAttr(attributeName), this.rule.getPackage());
        }

        @Override
        @Nullable
        public Object getOrDefault(Object key, @Nullable Object defaultValue) {
            String attributeName;
            if (!(key instanceof String)) {
                return defaultValue;
            }
            switch (attributeName = (String)key) {
                case "name": {
                    return this.rule.getName();
                }
                case "kind": {
                    return this.rule.getRuleClass();
                }
            }
            Object value = this.starlarkifyAttribute(attributeName);
            if (value != null) {
                return value;
            }
            return defaultValue;
        }

        @Override
        public Iterator<String> iterator() {
            return Iterators.concat(ImmutableList.of("name", "kind").iterator(), new UnmodifiableIterator<String>(){
                private final Iterator<Attribute> attributes;
                @Nullable
                private String nextRelevantAttributeName;
                {
                    this.attributes = rule.getAttributes().iterator();
                }

                private boolean isRelevant(String attributeName) {
                    switch (attributeName) {
                        case "name": 
                        case "kind": {
                            return false;
                        }
                    }
                    return this.starlarkifyAttribute(attributeName) != null;
                }

                private void findNextRelevantName() {
                    if (this.nextRelevantAttributeName == null) {
                        while (this.attributes.hasNext()) {
                            String attributeName = this.attributes.next().getName();
                            if (!this.isRelevant(attributeName)) continue;
                            this.nextRelevantAttributeName = attributeName;
                            break;
                        }
                    }
                }

                @Override
                public boolean hasNext() {
                    this.findNextRelevantName();
                    return this.nextRelevantAttributeName != null;
                }

                @Override
                public String next() {
                    this.findNextRelevantName();
                    if (this.nextRelevantAttributeName != null) {
                        String attributeName = this.nextRelevantAttributeName;
                        this.nextRelevantAttributeName = null;
                        return attributeName;
                    }
                    throw new NoSuchElementException();
                }
            });
        }

        @Override
        public boolean containsKey(Object key) {
            return this.get(key) != null;
        }

        @Override
        public int size() {
            return Iterables.size(this);
        }
    }

    private static interface DictLikeView
    extends StarlarkIndexable,
    StarlarkIterable<String>,
    Map<String, Object> {
        @Override
        default public boolean isImmutable() {
            return true;
        }

        @Override
        @StarlarkMethod(name="get", doc="Behaves the same as <a href=\"dict.html#get\"><code>dict.get</code></a>.", parameters={@Param(name="key", doc="The key to look for."), @Param(name="default", defaultValue="None", named=true, doc="The default value to use (instead of None) if the key is not found.")}, allowReturnNones=true)
        @Nullable
        public Object getOrDefault(Object var1, @Nullable Object var2);

        @StarlarkMethod(name="keys", doc="Behaves like <a href=\"dict.html#keys\"><code>dict.keys</code></a>, but the returned value is an immutable sequence.")
        default public StarlarkIterable<String> keys() {
            return StarlarkList.immutableCopyOf(this);
        }

        @StarlarkMethod(name="values", doc="Behaves like <a href=\"dict.html#values\"><code>dict.values</code></a>, but the returned value is an immutable sequence.")
        default public StarlarkIterable<Object> starlarkValues() {
            ArrayList<Object> valueList = new ArrayList<Object>();
            for (String key : this) {
                valueList.add(Preconditions.checkNotNull(this.get(key)));
            }
            return StarlarkList.immutableCopyOf(valueList);
        }

        @StarlarkMethod(name="items", doc="Behaves like <a href=\"dict.html#items\"><code>dict.items</code></a>, but the returned value is an immutable sequence.")
        default public StarlarkIterable<Tuple> items() {
            ArrayList<Tuple> itemsList = new ArrayList<Tuple>();
            for (String key : this) {
                itemsList.add(Tuple.pair(key, Preconditions.checkNotNull(this.get(key))));
            }
            return StarlarkList.immutableCopyOf(itemsList);
        }

        @Override
        default public Object getIndex(StarlarkSemantics semantics, Object key) throws EvalException {
            Object val = this.get(key);
            if (val != null) {
                return val;
            }
            throw Starlark.errorf("key %s not found in view", Starlark.repr(key));
        }

        @Override
        default public boolean containsKey(StarlarkSemantics semantics, Object key) {
            return this.containsKey(key);
        }

        @Override
        @Nullable
        default public Object get(Object key) {
            return this.getOrDefault(key, (Object)null);
        }

        @Override
        default public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        default public Set<String> keySet() {
            return ImmutableSet.copyOf(this.keys());
        }

        @Override
        default public Collection<Object> values() {
            return StarlarkList.immutableCopyOf(this.starlarkValues());
        }

        @Override
        default public Set<Map.Entry<String, Object>> entrySet() {
            ImmutableSet.Builder entries = new ImmutableSet.Builder();
            for (Tuple keyValuePair : this.items()) {
                entries.add(new AbstractMap.SimpleEntry((String)keyValuePair.get(0), keyValuePair.get(1)));
            }
            return entries.build();
        }

        @Override
        default public boolean containsValue(@Nullable Object value) {
            for (String key : this) {
                if (!Preconditions.checkNotNull(this.get(key)).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        @Deprecated
        default public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        @Deprecated
        default public Object put(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        default public void putAll(Map<? extends String, ? extends Object> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        @Deprecated
        default public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }
    }

    public static class ExistingRulesShouldBeNoOp {
    }
}

