/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.collect.ImmutableMap;
import com.google.devtools.build.lib.collect.nestedset.Depset;
import com.google.devtools.build.lib.packages.BuildGlobals;
import com.google.devtools.build.lib.packages.Proto;
import com.google.devtools.build.lib.packages.SelectorList;
import net.starlark.java.eval.Starlark;
import net.starlark.java.lib.json.Json;

public final class StarlarkLibrary {
    public static final ImmutableMap<String, Object> COMMON = StarlarkLibrary.initCommon();
    public static final ImmutableMap<String, Object> BUILD = StarlarkLibrary.initBUILD();

    private StarlarkLibrary() {
    }

    private static ImmutableMap<String, Object> initCommon() {
        ImmutableMap.Builder<String, Object> env = ImmutableMap.builder();
        Starlark.addMethods(env, Depset.DepsetLibrary.INSTANCE);
        env.put("json", Json.INSTANCE);
        env.put("proto", Proto.INSTANCE);
        return env.buildOrThrow();
    }

    private static ImmutableMap<String, Object> initBUILD() {
        ImmutableMap.Builder<String, Object> env = ImmutableMap.builder();
        Starlark.addMethods(env, BuildGlobals.INSTANCE);
        Starlark.addMethods(env, SelectorList.SelectLibrary.INSTANCE);
        env.putAll(COMMON);
        return env.buildOrThrow();
    }
}

