/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.packages.Provider;
import com.google.devtools.build.lib.packages.StarlarkInfo;
import com.google.devtools.build.lib.packages.StarlarkProvider;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nullable;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkList;
import net.starlark.java.syntax.Location;
import net.starlark.java.syntax.TokenKind;

public class StarlarkInfoWithSchema
extends StarlarkInfo {
    private final StarlarkProvider provider;
    private final Object[] table;

    private StarlarkInfoWithSchema(StarlarkProvider provider, Object[] table, @Nullable Location loc) {
        super(loc);
        this.provider = provider;
        this.table = table;
    }

    @Override
    public Provider getProvider() {
        return this.provider;
    }

    static StarlarkInfoWithSchema createFromNamedArgs(StarlarkProvider provider, Object[] table, Location loc) throws EvalException {
        ImmutableList<String> fields = provider.getFields();
        Object[] valueTable = new Object[fields.size()];
        ArrayList<String> unexpected = null;
        for (int i = 0; i < table.length; i += 2) {
            int pos = Collections.binarySearch(fields, (String)table[i]);
            if (pos >= 0) {
                if (valueTable[pos] != null) {
                    throw Starlark.errorf("got multiple values for parameter %s in call to instantiate provider %s", table[i], provider.getPrintableName());
                }
                valueTable[pos] = provider.optimizeField(pos, table[i + 1]);
                continue;
            }
            if (unexpected == null) {
                unexpected = new ArrayList<String>();
            }
            unexpected.add((String)table[i]);
        }
        if (unexpected != null) {
            throw Starlark.errorf("got unexpected field%s '%s' in call to instantiate provider %s", unexpected.size() > 1 ? "s" : "", Joiner.on("', '").join(unexpected), provider.getPrintableName());
        }
        return new StarlarkInfoWithSchema(provider, valueTable, loc);
    }

    @Override
    public ImmutableCollection<String> getFieldNames() {
        ImmutableList.Builder fieldNames = new ImmutableList.Builder();
        ImmutableList<String> fields = this.provider.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            if (this.table[i] == null) continue;
            fieldNames.add((String)fields.get(i));
        }
        return fieldNames.build();
    }

    @Override
    public boolean isImmutable() {
        if (!this.provider.isExported()) {
            return false;
        }
        for (int i = 0; i < this.table.length; ++i) {
            if (this.table[i] == null || this.provider.isOptimised(i, this.table[i]) || Starlark.isImmutable(this.table[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public Object getValue(String name) {
        ImmutableList<String> fields = this.provider.getFields();
        int i = Collections.binarySearch(fields, name);
        return i >= 0 ? this.provider.retrieveOptimizedField(i, this.table[i]) : null;
    }

    @Override
    @Nullable
    public StarlarkInfoWithSchema binaryOp(TokenKind op, Object that, boolean thisLeft) throws EvalException {
        if (op == TokenKind.PLUS && that instanceof StarlarkInfo) {
            Provider thatProvider = ((StarlarkInfo)that).getProvider();
            if (!this.provider.equals(thatProvider)) {
                throw Starlark.errorf("Cannot use '+' operator on instances of different providers (%s and %s)", this.provider.getPrintableName(), thatProvider.getPrintableName());
            }
            Preconditions.checkArgument(that instanceof StarlarkInfoWithSchema);
            return thisLeft ? StarlarkInfoWithSchema.plus(this, (StarlarkInfoWithSchema)that) : StarlarkInfoWithSchema.plus((StarlarkInfoWithSchema)that, this);
        }
        return null;
    }

    private static StarlarkInfoWithSchema plus(StarlarkInfoWithSchema x, StarlarkInfoWithSchema y) throws EvalException {
        int n = x.table.length;
        Object[] ztable = new Object[n];
        for (int i = 0; i < n; ++i) {
            if (x.table[i] != null && y.table[i] != null) {
                ImmutableList<String> schema = x.provider.getFields();
                throw Starlark.errorf("cannot add struct instances with common field '%s'", schema.get(i));
            }
            ztable[i] = x.table[i] != null ? x.table[i] : y.table[i];
        }
        return new StarlarkInfoWithSchema(x.provider, ztable, Location.BUILTIN);
    }

    @Override
    public StarlarkInfoWithSchema unsafeOptimizeMemoryLayout() {
        int n = this.table.length;
        for (int i = 0; i < n; ++i) {
            if (this.table[i] instanceof StarlarkList) {
                this.table[i] = ((StarlarkList)this.table[i]).unsafeOptimizeMemoryLayout();
                continue;
            }
            if (!(this.table[i] instanceof StarlarkInfo)) continue;
            this.table[i] = ((StarlarkInfo)this.table[i]).unsafeOptimizeMemoryLayout();
        }
        return this;
    }
}

