/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.packages.Provider;
import com.google.devtools.build.lib.packages.StarlarkInfo;
import com.google.devtools.build.lib.packages.StarlarkProvider;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkList;
import net.starlark.java.syntax.Location;
import net.starlark.java.syntax.TokenKind;

public class StarlarkInfoNoSchema
extends StarlarkInfo {
    private final Provider provider;
    private final Object[] table;

    private StarlarkInfoNoSchema(Provider provider, Object[] table, @Nullable Location loc) {
        super(loc);
        this.provider = provider;
        this.table = table;
    }

    StarlarkInfoNoSchema(Provider provider, Map<String, Object> values, @Nullable Location loc) {
        super(loc);
        this.provider = provider;
        this.table = StarlarkInfoNoSchema.toTable(values);
    }

    @Override
    public Provider getProvider() {
        return this.provider;
    }

    static StarlarkInfo createSchemaless(Provider provider, Map<String, Object> values, @Nullable Location loc) {
        Preconditions.checkArgument(!(provider instanceof StarlarkProvider) || ((StarlarkProvider)provider).getFields() == null);
        return new StarlarkInfoNoSchema(provider, values, loc);
    }

    private static Object[] toTable(Map<String, Object> values) {
        int n = values.size();
        Object[] table = new Object[n + n];
        int i = 0;
        for (Map.Entry<String, Object> e : values.entrySet()) {
            table[i] = e.getKey();
            table[n + i] = Starlark.checkValid(e.getValue());
            ++i;
        }
        if (n > 1) {
            StarlarkInfoNoSchema.sortPairs(table, 0, n - 1);
        }
        return table;
    }

    static StarlarkInfo createFromNamedArgs(StarlarkProvider provider, Object[] table, Location loc) throws EvalException {
        StarlarkInfoNoSchema.permute(table);
        int n = table.length >> 1;
        if (n > 1) {
            StarlarkInfoNoSchema.sortPairs(table, 0, n - 1);
        }
        for (int i = 0; i < n - 1; ++i) {
            if (!table[i].equals(table[i + 1])) continue;
            throw Starlark.errorf("got multiple values for parameter %s in call to instantiate provider %s", table[i], provider.getPrintableName());
        }
        return new StarlarkInfoNoSchema((Provider)provider, table, loc);
    }

    static void permute(Object[] named) {
        int i;
        int n = named.length >> 1;
        for (i = 0; i < n - 1; i += 2) {
            int j = named.length - i;
            Object tmp = named[i + 1];
            named[i + 1] = named[j - 2];
            named[j - 2] = named[j - 1];
            named[j - 1] = tmp;
        }
        for (i = 0; i < n >> 1; ++i) {
            Object tmp = named[n - 1 - i];
            named[n - 1 - i] = named[i];
            named[i] = tmp;
        }
    }

    static void sortPairs(Object[] a, int lo, int hi) {
        String pivot = (String)a[lo + (hi - lo) / 2];
        int i = lo;
        int j = hi;
        while (i <= j) {
            while (((String)a[i]).compareTo(pivot) < 0) {
                ++i;
            }
            while (((String)a[j]).compareTo(pivot) > 0) {
                --j;
            }
            if (i > j) continue;
            int n = a.length >> 1;
            StarlarkInfoNoSchema.swap(a, i, j);
            StarlarkInfoNoSchema.swap(a, i + n, j + n);
            ++i;
            --j;
        }
        if (lo < j) {
            StarlarkInfoNoSchema.sortPairs(a, lo, j);
        }
        if (i < hi) {
            StarlarkInfoNoSchema.sortPairs(a, i, hi);
        }
    }

    private static void swap(Object[] a, int i, int j) {
        Object tmp = a[i];
        a[i] = a[j];
        a[j] = tmp;
    }

    @Override
    public ImmutableCollection<String> getFieldNames() {
        List<Object> keys = Arrays.asList(this.table).subList(0, this.table.length / 2);
        return ImmutableList.copyOf(keys);
    }

    @Override
    public boolean isImmutable() {
        if (!this.provider.isExported()) {
            return false;
        }
        for (int i = this.table.length / 2; i < this.table.length; ++i) {
            if (Starlark.isImmutable(this.table[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public Object getValue(String name) {
        int n = this.table.length / 2;
        int i = Arrays.binarySearch(this.table, 0, n, name);
        if (i < 0) {
            return null;
        }
        return this.table[n + i];
    }

    @Override
    @Nullable
    public StarlarkInfo binaryOp(TokenKind op, Object that, boolean thisLeft) throws EvalException {
        if (op == TokenKind.PLUS && that instanceof StarlarkInfo) {
            Provider thatProvider = ((StarlarkInfo)that).getProvider();
            if (!this.provider.equals(thatProvider)) {
                throw Starlark.errorf("Cannot use '+' operator on instances of different providers (%s and %s)", this.provider.getPrintableName(), thatProvider.getPrintableName());
            }
            Preconditions.checkArgument(that instanceof StarlarkInfoNoSchema);
            return thisLeft ? StarlarkInfoNoSchema.plus(this, (StarlarkInfoNoSchema)that) : StarlarkInfoNoSchema.plus((StarlarkInfoNoSchema)that, this);
        }
        return null;
    }

    private static StarlarkInfo plus(StarlarkInfoNoSchema x, StarlarkInfoNoSchema y) throws EvalException {
        int xsize = x.table.length / 2;
        int ysize = y.table.length / 2;
        int zsize = xsize + ysize;
        Object[] ztable = new Object[zsize + zsize];
        int xi = 0;
        int yi = 0;
        int zi = 0;
        while (xi < xsize && yi < ysize) {
            String xk = (String)x.table[xi];
            String yk = (String)y.table[yi];
            int cmp = xk.compareTo(yk);
            if (cmp < 0) {
                ztable[zi] = xk;
                ztable[zi + zsize] = x.table[xi + xsize];
                ++xi;
            } else if (cmp > 0) {
                ztable[zi] = yk;
                ztable[zi + zsize] = y.table[yi + ysize];
                ++yi;
            } else {
                throw Starlark.errorf("cannot add struct instances with common field '%s'", xk);
            }
            ++zi;
        }
        while (xi < xsize) {
            ztable[zi] = x.table[xi];
            ztable[zi + zsize] = x.table[xi + xsize];
            ++xi;
            ++zi;
        }
        while (yi < ysize) {
            ztable[zi] = y.table[yi];
            ztable[zi + zsize] = y.table[yi + ysize];
            ++yi;
            ++zi;
        }
        return new StarlarkInfoNoSchema(x.provider, ztable, Location.BUILTIN);
    }

    @Override
    public StarlarkInfoNoSchema unsafeOptimizeMemoryLayout() {
        for (int i = this.table.length / 2; i < this.table.length; ++i) {
            if (this.table[i] instanceof StarlarkList) {
                this.table[i] = ((StarlarkList)this.table[i]).unsafeOptimizeMemoryLayout();
                continue;
            }
            if (!(this.table[i] instanceof StarlarkInfo)) continue;
            this.table[i] = ((StarlarkInfo)this.table[i]).unsafeOptimizeMemoryLayout();
        }
        return this;
    }
}

