/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Ascii;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.build.lib.analysis.config.ToolchainTypeRequirement;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.events.EventHandler;
import com.google.devtools.build.lib.packages.AspectClass;
import com.google.devtools.build.lib.packages.AspectDefinition;
import com.google.devtools.build.lib.packages.AspectParameters;
import com.google.devtools.build.lib.packages.AspectsListBuilder;
import com.google.devtools.build.lib.packages.Attribute;
import com.google.devtools.build.lib.packages.ExecGroup;
import com.google.devtools.build.lib.packages.PredicateWithMessage;
import com.google.devtools.build.lib.packages.RawAttributeMapper;
import com.google.devtools.build.lib.packages.Rule;
import com.google.devtools.build.lib.packages.StarlarkAspect;
import com.google.devtools.build.lib.packages.StarlarkAspectClass;
import com.google.devtools.build.lib.packages.StarlarkExportable;
import com.google.devtools.build.lib.packages.StarlarkProviderIdentifier;
import com.google.devtools.build.lib.packages.Type;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Printer;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkCallable;
import net.starlark.java.eval.StarlarkInt;

public final class StarlarkDefinedAspect
implements StarlarkExportable,
StarlarkAspect {
    private final StarlarkCallable implementation;
    @Nullable
    private final String documentation;
    private final ImmutableList<String> attributeAspects;
    private final ImmutableList<Attribute> attributes;
    private final ImmutableList<ImmutableSet<StarlarkProviderIdentifier>> requiredProviders;
    private final ImmutableList<ImmutableSet<StarlarkProviderIdentifier>> requiredAspectProviders;
    private final ImmutableSet<StarlarkProviderIdentifier> provides;
    private final ImmutableSet<String> paramAttributes;
    private final ImmutableSet<StarlarkAspect> requiredAspects;
    private final ImmutableSet<String> fragments;
    private final ImmutableSet<ToolchainTypeRequirement> toolchainTypes;
    private final boolean applyToGeneratingRules;
    private final ImmutableSet<Label> execCompatibleWith;
    private final ImmutableMap<String, ExecGroup> execGroups;
    private StarlarkAspectClass aspectClass;
    private static final ImmutableSet<String> TRUE_REPS = ImmutableSet.of("true", "1", "yes", "t", "y");
    private static final ImmutableSet<String> FALSE_REPS = ImmutableSet.of("false", "0", "no", "f", "n");
    private static final ImmutableList<String> ALL_ATTR_ASPECTS = ImmutableList.of("*");
    private transient LoadingCache<AspectParameters, AspectDefinition> definitionCache = Caffeine.newBuilder().build(this::buildDefinition);

    public StarlarkDefinedAspect(StarlarkCallable implementation, Optional<String> documentation, ImmutableList<String> attributeAspects, ImmutableList<Attribute> attributes, ImmutableList<ImmutableSet<StarlarkProviderIdentifier>> requiredProviders, ImmutableList<ImmutableSet<StarlarkProviderIdentifier>> requiredAspectProviders, ImmutableSet<StarlarkProviderIdentifier> provides, ImmutableSet<String> paramAttributes, ImmutableSet<StarlarkAspect> requiredAspects, ImmutableSet<String> fragments, ImmutableSet<ToolchainTypeRequirement> toolchainTypes, boolean applyToGeneratingRules, ImmutableSet<Label> execCompatibleWith, ImmutableMap<String, ExecGroup> execGroups) {
        this.implementation = implementation;
        this.documentation = documentation.orElse(null);
        this.attributeAspects = attributeAspects;
        this.attributes = attributes;
        this.requiredProviders = requiredProviders;
        this.requiredAspectProviders = requiredAspectProviders;
        this.provides = provides;
        this.paramAttributes = paramAttributes;
        this.requiredAspects = requiredAspects;
        this.fragments = fragments;
        this.toolchainTypes = toolchainTypes;
        this.applyToGeneratingRules = applyToGeneratingRules;
        this.execCompatibleWith = execCompatibleWith;
        this.execGroups = execGroups;
    }

    public StarlarkCallable getImplementation() {
        return this.implementation;
    }

    public Optional<String> getDocumentation() {
        return Optional.ofNullable(this.documentation);
    }

    public ImmutableList<String> getAttributeAspects() {
        return this.attributeAspects;
    }

    public ImmutableList<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean isImmutable() {
        return this.implementation.isImmutable();
    }

    @Override
    public void repr(Printer printer) {
        printer.append("<aspect>");
    }

    @Override
    public String getName() {
        return this.getAspectClass().getName();
    }

    @Override
    public StarlarkAspectClass getAspectClass() {
        Preconditions.checkState(this.isExported());
        return this.aspectClass;
    }

    @Override
    public ImmutableSet<String> getParamAttributes() {
        return this.paramAttributes;
    }

    @Override
    public void export(EventHandler handler, Label extensionLabel, String name) {
        Preconditions.checkArgument(!this.isExported());
        this.aspectClass = new StarlarkAspectClass(extensionLabel, name);
    }

    public AspectDefinition getDefinition(AspectParameters aspectParams) {
        if (this.definitionCache == null) {
            this.definitionCache = Caffeine.newBuilder().build(this::buildDefinition);
        }
        return this.definitionCache.get(aspectParams);
    }

    private AspectDefinition buildDefinition(AspectParameters aspectParams) {
        AspectDefinition.Builder builder = new AspectDefinition.Builder(this.aspectClass);
        if (ALL_ATTR_ASPECTS.equals(this.attributeAspects)) {
            builder.propagateAlongAllAttributes();
        } else {
            for (String string : this.attributeAspects) {
                builder.propagateAlongAttribute(string);
            }
        }
        for (Attribute attribute : this.attributes) {
            Attribute attr = attribute;
            if (!aspectParams.getAttribute(attr.getName()).isEmpty()) {
                Type<?> attrType = attr.getType();
                String attrName = attr.getName();
                String attrValue = aspectParams.getOnlyValueOfAttribute(attrName);
                Preconditions.checkState(!Attribute.isImplicit(attrName));
                Preconditions.checkState(attrType == Type.STRING || attrType == Type.INTEGER || attrType == Type.BOOLEAN);
                Preconditions.checkArgument(aspectParams.getAttribute(attrName).size() == 1, "Aspect %s parameter %s has %s values (must have exactly 1).", (Object)this.getName(), (Object)attrName, (Object)aspectParams.getAttribute(attrName).size());
                attr = StarlarkDefinedAspect.addAttrValue(attr, attrValue);
            }
            builder.add(attr);
        }
        builder.requireStarlarkProviderSets(this.requiredProviders);
        builder.requireAspectsWithProviders(this.requiredAspectProviders);
        ImmutableList.Builder advertisedStarlarkProviders = ImmutableList.builder();
        for (StarlarkProviderIdentifier provider : this.provides) {
            advertisedStarlarkProviders.add(provider);
        }
        builder.advertiseProvider((ImmutableList<StarlarkProviderIdentifier>)advertisedStarlarkProviders.build());
        builder.requiresConfigurationFragmentsByStarlarkBuiltinName(this.fragments);
        builder.addToolchainTypes(this.toolchainTypes);
        builder.applyToGeneratingRules(this.applyToGeneratingRules);
        ImmutableSet.Builder builder2 = ImmutableSet.builder();
        for (StarlarkAspect requiredAspect : this.requiredAspects) {
            builder2.add(requiredAspect.getAspectClass());
        }
        builder.requiredAspectClasses((ImmutableSet<AspectClass>)builder2.build());
        builder.execCompatibleWith(this.execCompatibleWith);
        builder.execGroups(this.execGroups);
        return builder.build();
    }

    private static Attribute addAttrValue(Attribute attr, String attrValue) {
        Attribute.Builder<Object> attrBuilder;
        Type<?> attrType = attr.getType();
        Object castedValue = attrValue;
        if (attrType == Type.INTEGER) {
            castedValue = StarlarkInt.parse(attrValue, 0);
            attrBuilder = attr.cloneBuilder(Type.INTEGER).value((StarlarkInt)castedValue);
        } else if (attrType == Type.BOOLEAN) {
            castedValue = Boolean.parseBoolean(attrValue);
            attrBuilder = attr.cloneBuilder(Type.BOOLEAN).value((Boolean)castedValue);
        } else {
            attrBuilder = attr.cloneBuilder(Type.STRING).value((String)castedValue);
        }
        if (!attr.checkAllowedValues()) {
            return attrBuilder.allowedValues(new Attribute.AllowedValueSet(attrType.cast(castedValue))).build(attr.getName());
        }
        return attrBuilder.build(attr.getName());
    }

    @Override
    public boolean isExported() {
        return this.aspectClass != null;
    }

    @Override
    public Function<Rule, AspectParameters> getDefaultParametersExtractor() {
        return (Function & Serializable)rule -> {
            RawAttributeMapper ruleAttrs = RawAttributeMapper.of(rule);
            AspectParameters.Builder builder = new AspectParameters.Builder();
            for (Attribute aspectAttr : this.attributes) {
                String param = aspectAttr.getName();
                if (Attribute.isImplicit(param) || Attribute.isLateBound(param)) continue;
                Attribute ruleAttr = ruleAttrs.getAttributeDefinition(param);
                if (this.paramAttributes.contains(aspectAttr.getName())) {
                    Preconditions.checkArgument(ruleAttr != null, "Cannot apply aspect %s to %s that does not define attribute '%s'.", (Object)this.getName(), (Object)rule.getTargetKind(), (Object)param);
                    Preconditions.checkArgument(ruleAttr.getType() == Type.STRING || ruleAttr.getType() == Type.INTEGER || ruleAttr.getType() == Type.BOOLEAN, "Cannot apply aspect %s to %s since attribute '%s' is not boolean, integer, nor string.", (Object)this.getName(), (Object)rule.getTargetKind(), (Object)param);
                }
                if (ruleAttr == null || ruleAttr.getType() != aspectAttr.getType() || ruleAttrs.isConfigurable(param)) continue;
                builder.addAttribute(param, ruleAttrs.get(param, ruleAttr.getType()).toString());
            }
            return builder.build();
        };
    }

    public AspectParameters extractTopLevelParameters(ImmutableMap<String, String> parametersValues) throws EvalException {
        AspectParameters.Builder builder = new AspectParameters.Builder();
        for (Attribute aspectParameter : this.attributes) {
            PredicateWithMessage<Object> allowedValues;
            String parameterName = aspectParameter.getName();
            Type<?> parameterType = aspectParameter.getType();
            if (Attribute.isImplicit(parameterName) || Attribute.isLateBound(parameterName)) continue;
            Preconditions.checkArgument(parameterType == Type.STRING || parameterType == Type.INTEGER || parameterType == Type.BOOLEAN, "Aspect %s: Cannot pass value of attribute '%s' of type %s, only 'boolean', 'int' and 'string' attributes are allowed.", (Object)this.getName(), (Object)parameterName, parameterType);
            String parameterValue = parametersValues.getOrDefault(parameterName, parameterType.cast(aspectParameter.getDefaultValue()).toString());
            Object castedParameterValue = parameterValue;
            if (parameterType == Type.INTEGER) {
                castedParameterValue = this.parseIntParameter(parameterName, parameterValue);
            } else if (parameterType == Type.BOOLEAN) {
                castedParameterValue = this.parseBooleanParameter(parameterName, parameterValue);
            }
            if (aspectParameter.checkAllowedValues() && !(allowedValues = aspectParameter.getAllowedValues()).apply(castedParameterValue)) {
                throw Starlark.errorf("%s: invalid value in '%s' attribute: %s", this.getName(), parameterName, allowedValues.getErrorReason(castedParameterValue));
            }
            builder.addAttribute(parameterName, castedParameterValue.toString());
        }
        return builder.build();
    }

    private StarlarkInt parseIntParameter(String name, String value) throws EvalException {
        try {
            return StarlarkInt.parse(value, 0);
        }
        catch (NumberFormatException e) {
            throw new EvalException(String.format("%s: expected value of type 'int' for attribute '%s' but got '%s'", this.getName(), name, value), e);
        }
    }

    private Boolean parseBooleanParameter(String name, String value) throws EvalException {
        if (TRUE_REPS.contains(value = Ascii.toLowerCase(value))) {
            return true;
        }
        if (FALSE_REPS.contains(value)) {
            return false;
        }
        throw Starlark.errorf("%s: expected value of type 'bool' for attribute '%s' but got '%s'", this.getName(), name, value);
    }

    public ImmutableSet<ToolchainTypeRequirement> getToolchainTypes() {
        return this.toolchainTypes;
    }

    @Override
    public void attachToAspectsList(String baseAspectName, AspectsListBuilder aspectsList) throws EvalException {
        if (!this.isExported()) {
            throw Starlark.errorf("Aspects should be top-level values in extension files that define them.", new Object[0]);
        }
        for (StarlarkAspect requiredAspect : this.requiredAspects) {
            requiredAspect.attachToAspectsList(this.getName(), aspectsList);
        }
        aspectsList.addAspect(this, baseAspectName);
    }

    public ImmutableList<ImmutableSet<StarlarkProviderIdentifier>> getRequiredProviders() {
        return this.requiredProviders;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StarlarkDefinedAspect that = (StarlarkDefinedAspect)o;
        return Objects.equals(this.implementation, that.implementation) && Objects.equals(this.attributeAspects, that.attributeAspects) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.requiredProviders, that.requiredProviders) && Objects.equals(this.requiredAspectProviders, that.requiredAspectProviders) && Objects.equals(this.provides, that.provides) && Objects.equals(this.paramAttributes, that.paramAttributes) && Objects.equals(this.requiredAspects, that.requiredAspects) && Objects.equals(this.fragments, that.fragments) && Objects.equals(this.toolchainTypes, that.toolchainTypes) && Objects.equals(this.aspectClass, that.aspectClass);
    }

    public int hashCode() {
        return Objects.hash(this.implementation, this.attributeAspects, this.attributes, this.requiredProviders, this.requiredAspectProviders, this.provides, this.paramAttributes, this.requiredAspects, this.fragments, this.toolchainTypes, this.aspectClass);
    }
}

