/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.build.lib.events.Event;
import com.google.devtools.build.lib.events.EventHandler;
import com.google.devtools.build.lib.packages.BazelStarlarkContext;
import com.google.devtools.build.lib.packages.SymbolGenerator;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Mutability;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkFunction;
import net.starlark.java.eval.StarlarkSemantics;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.eval.Structure;

public final class StarlarkCallbackHelper {
    private final StarlarkFunction callback;
    private final StarlarkSemantics starlarkSemantics;
    private final BazelStarlarkContext contextTemplate;

    public StarlarkCallbackHelper(StarlarkFunction callback, StarlarkSemantics starlarkSemantics, BazelStarlarkContext contextTemplate) {
        this.callback = callback;
        this.starlarkSemantics = starlarkSemantics;
        this.contextTemplate = contextTemplate;
    }

    public ImmutableList<String> getParameterNames() {
        return this.callback.getParameterNames();
    }

    public Object call(EventHandler eventHandler, Structure struct, Object ... arguments) throws EvalException, InterruptedException {
        Mutability mu = Mutability.create("callback", this.callback);
        try {
            StarlarkThread thread = new StarlarkThread(mu, this.starlarkSemantics);
            thread.setPrintHandler(Event.makeDebugPrintHandler(eventHandler));
            BazelStarlarkContext context = new BazelStarlarkContext(this.contextTemplate.getPhase(), this.contextTemplate.getToolsRepository(), this.contextTemplate.getFragmentNameToClass(), new SymbolGenerator<Object>(new Object()), this.contextTemplate.getAnalysisRuleLabel(), this.contextTemplate.getNetworkAllowlistForTests().orElse(null));
            context.storeInThread(thread);
            Object object = Starlark.call(thread, this.callback, this.buildArgumentList(struct, arguments), ImmutableMap.of());
            if (mu != null) {
                mu.close();
            }
            return object;
        }
        catch (Throwable throwable) {
            try {
                if (mu != null) {
                    try {
                        mu.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ClassCastException | IllegalArgumentException e) {
                throw new EvalException(e);
            }
        }
    }

    private ImmutableList<Object> buildArgumentList(Structure struct, Object ... arguments) throws EvalException {
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableList<String> names = this.getParameterNames();
        int requiredParameters = names.size() - arguments.length;
        for (int pos = 0; pos < requiredParameters; ++pos) {
            String name = (String)names.get(pos);
            Object value = struct.getValue(name);
            if (value == null) {
                throw new IllegalArgumentException(struct.getErrorMessageForUnknownField(name));
            }
            builder.add(value);
        }
        return ((ImmutableList.Builder)builder.add(arguments)).build();
    }
}

