/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;

final class SnapshottableBiMap<K, V>
implements BiMap<K, V> {
    private final BiMap<K, V> contents = HashBiMap.create();
    private final Predicate<V> track;
    private ArrayList<K> trackedKeys;
    private Map<K, Integer> trackedKeyOrders;

    public SnapshottableBiMap(Predicate<V> track) {
        this.track = track;
    }

    BiMap<K, V> getUnderlyingBiMap() {
        return this.contents;
    }

    @Override
    public int size() {
        return this.contents.size();
    }

    private int sizeTracked() {
        this.ensureOrderTracking();
        return this.trackedKeyOrders.size();
    }

    @Override
    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.contents.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.contents.containsValue(value);
    }

    @Override
    @Nullable
    public V get(Object key) {
        return this.contents.get(key);
    }

    private int getTrackedKeyOrder(Object key) {
        this.ensureOrderTracking();
        Integer order = this.trackedKeyOrders.get(key);
        return order == null ? -1 : order;
    }

    private K getTrackedKey(int order) {
        this.ensureOrderTracking();
        return this.trackedKeys.get(order);
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        if (this.startedOrderTracking()) {
            boolean oldWasTracked = this.getTrackedKeyOrder(key) >= 0;
            boolean newIsTracked = this.track.test(value);
            if (oldWasTracked) {
                Preconditions.checkArgument(newIsTracked, "Cannot replace a key-value pair which is tracked with a key-value pair which is not tracked");
            } else if (newIsTracked) {
                this.recordKeyOrder(key);
            }
        }
        return this.contents.put(key, value);
    }

    @Override
    @Deprecated
    @Nullable
    public V forcePut(K key, V value) {
        throw new UnsupportedOperationException("Append-only data structure");
    }

    @Override
    @Deprecated
    @Nullable
    public V remove(Object key) {
        throw new UnsupportedOperationException("Append-only data structure");
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException("Append-only data structure");
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.contents.keySet());
    }

    @Override
    public Set<V> values() {
        return Collections.unmodifiableSet(this.contents.values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(this.contents.entrySet());
    }

    @Override
    public BiMap<V, K> inverse() {
        return Maps.unmodifiableBiMap(this.contents.inverse());
    }

    private boolean startedOrderTracking() {
        Preconditions.checkState(this.trackedKeys == null == (this.trackedKeyOrders == null));
        return this.trackedKeys != null;
    }

    private void ensureOrderTracking() {
        if (!this.startedOrderTracking()) {
            this.trackedKeys = new ArrayList();
            this.trackedKeyOrders = new HashMap<K, Integer>();
            this.contents.forEach((key, value) -> {
                if (this.track.test(value)) {
                    this.recordKeyOrder(key);
                }
            });
        }
    }

    private void recordKeyOrder(K key) {
        int order = this.trackedKeys.size();
        this.trackedKeys.add(key);
        this.trackedKeyOrders.put(key, order);
    }

    public Map<K, V> getTrackedSnapshot() {
        return new TrackedSnapshot(this);
    }

    static final class TrackedSnapshot<K, V>
    extends AbstractMap<K, V> {
        private final SnapshottableBiMap<K, V> underlying;
        private final int sizeTracked;

        private TrackedSnapshot(SnapshottableBiMap<K, V> underlying) {
            this.underlying = underlying;
            this.sizeTracked = underlying.sizeTracked();
        }

        @Override
        public boolean containsKey(Object key) {
            int order = this.underlying.getTrackedKeyOrder(key);
            return order >= 0 && order < this.sizeTracked;
        }

        @Override
        public boolean containsValue(Object value) {
            Object key = this.underlying.inverse().get(value);
            if (key != null) {
                int order = this.underlying.getTrackedKeyOrder(key);
                return order >= 0 && order < this.sizeTracked;
            }
            return false;
        }

        @Override
        @Nullable
        public V get(Object key) {
            if (this.containsKey(key)) {
                return this.underlying.get(key);
            }
            return null;
        }

        @Override
        @Deprecated
        @Nullable
        public V put(K key, V value) {
            throw new UnsupportedOperationException("Read-only snapshot");
        }

        @Override
        @Deprecated
        @Nullable
        public V remove(Object key) {
            throw new UnsupportedOperationException("Read-only snapshot");
        }

        @Override
        @Deprecated
        public void putAll(Map<? extends K, ? extends V> m4) {
            throw new UnsupportedOperationException("Read-only snapshot");
        }

        @Override
        @Deprecated
        public void clear() {
            throw new UnsupportedOperationException("Read-only snapshot");
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new UnmodifiableSet<Map.Entry<K, V>>(){

                @Override
                public int size() {
                    return sizeTracked;
                }

                @Override
                public boolean isEmpty() {
                    return sizeTracked == 0;
                }

                @Override
                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    return this.containsKey(entry.getKey()) && this.containsValue(entry.getValue());
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new UnmodifiableIterator<Map.Entry<K, V>>(){
                        private int nextOrder = 0;

                        @Override
                        public boolean hasNext() {
                            return this.nextOrder < sizeTracked;
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            Object key = underlying.getTrackedKey(this.nextOrder);
                            Object value = underlying.get(key);
                            ++this.nextOrder;
                            return new AbstractMap.SimpleEntry(key, value);
                        }
                    };
                }
            };
        }

        private static abstract class UnmodifiableSet<E>
        extends AbstractSet<E> {
            private UnmodifiableSet() {
            }

            @Override
            @Deprecated
            public boolean add(E entry) {
                throw new UnsupportedOperationException();
            }

            @Override
            @Deprecated
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            @Deprecated
            public boolean containsAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            @Deprecated
            public boolean addAll(Collection<? extends E> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            @Deprecated
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            @Deprecated
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            @Deprecated
            public void clear() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

