/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.devtools.build.lib.packages.SelectorList;
import java.util.Map;
import javax.annotation.Nullable;
import net.starlark.java.annot.StarlarkBuiltin;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.HasBinary;
import net.starlark.java.eval.Printer;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkValue;
import net.starlark.java.syntax.TokenKind;

@StarlarkBuiltin(name="selector", doc="A selector between configuration-dependent values.", documented=false)
public final class SelectorValue
implements StarlarkValue,
HasBinary {
    private final ImmutableMap<?, ?> dictionary;
    private final Class<?> type;
    private final String noMatchError;

    SelectorValue(Map<?, ?> dictionary, String noMatchError) {
        Preconditions.checkArgument(!dictionary.isEmpty());
        this.dictionary = ImmutableMap.copyOf(dictionary);
        this.type = Iterables.getFirst(dictionary.values(), null).getClass();
        this.noMatchError = noMatchError;
    }

    ImmutableMap<?, ?> getDictionary() {
        return this.dictionary;
    }

    Class<?> getType() {
        return this.type;
    }

    String getNoMatchError() {
        return this.noMatchError;
    }

    public String toString() {
        return Starlark.repr(this);
    }

    @Override
    @Nullable
    public SelectorList binaryOp(TokenKind op, Object that, boolean thisLeft) throws EvalException {
        return SelectorList.of(this).binaryOp(op, that, thisLeft);
    }

    @Override
    public void repr(Printer printer) {
        printer.append("select(").repr(this.dictionary).append(")");
    }
}

