/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.devtools.build.docgen.annot.GlobalMethods;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.collect.nestedset.Depset;
import com.google.devtools.build.lib.packages.SelectorValue;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.starlark.java.annot.Param;
import net.starlark.java.annot.StarlarkBuiltin;
import net.starlark.java.annot.StarlarkMethod;
import net.starlark.java.eval.Dict;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.HasBinary;
import net.starlark.java.eval.Printer;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkValue;
import net.starlark.java.syntax.TokenKind;

@StarlarkBuiltin(name="select", doc="A selector between configuration-dependent entities.", documented=false)
public final class SelectorList
implements StarlarkValue,
HasBinary {
    private final Class<?> type;
    private final List<Object> elements;
    private static final Class<?> NATIVE_LIST_TYPE = List.class;

    private SelectorList(Class<?> type, List<Object> elements) {
        this.type = type;
        this.elements = elements;
    }

    List<Object> getElements() {
        return this.elements;
    }

    Class<?> getType() {
        return this.type;
    }

    private static Object select(Dict<?, ?> dict, String noMatchError) throws EvalException {
        if (dict.isEmpty()) {
            throw Starlark.errorf("select({}) with an empty dictionary can never resolve because it includes no conditions to match", new Object[0]);
        }
        for (Object key : dict.keySet()) {
            if (key instanceof String || key instanceof Label) continue;
            throw Starlark.errorf("select: got %s for dict key, want a Label or label string", Starlark.type(key));
        }
        return SelectorList.of(new SelectorValue(dict, noMatchError));
    }

    static SelectorList of(SelectorValue selector) {
        return new SelectorList(selector.getType(), ImmutableList.of(selector));
    }

    static SelectorList of(Iterable<?> values) throws EvalException {
        Preconditions.checkArgument(!Iterables.isEmpty(values));
        ImmutableList.Builder elements = ImmutableList.builder();
        Object firstValue = null;
        for (Object value : values) {
            if (value instanceof SelectorList) {
                elements.addAll(((SelectorList)value).elements);
            } else {
                elements.add(value);
            }
            if (firstValue == null) {
                firstValue = value;
            }
            if (SelectorList.canConcatenate(SelectorList.getNativeType(firstValue), SelectorList.getNativeType(value))) continue;
            throw Starlark.errorf("Cannot combine incompatible types (%s, %s)", SelectorList.getTypeName(firstValue), SelectorList.getTypeName(value));
        }
        return new SelectorList(SelectorList.getNativeType(firstValue), (List<Object>)((Object)elements.build()));
    }

    static SelectorList concat(Object x, Object y) throws EvalException {
        return SelectorList.of(Arrays.asList(x, y));
    }

    @Override
    @Nullable
    public SelectorList binaryOp(TokenKind op, Object that, boolean thisLeft) throws EvalException {
        if (SelectorList.getNativeType(that).equals(Dict.class) ? op == TokenKind.PIPE : op == TokenKind.PLUS) {
            return thisLeft ? SelectorList.concat(this, that) : SelectorList.concat(that, this);
        }
        return null;
    }

    private static String getTypeName(Object x) {
        if (x instanceof SelectorList) {
            return "select of " + Depset.ElementType.of(((SelectorList)x).type);
        }
        if (x instanceof SelectorValue) {
            return "select of " + Depset.ElementType.of(((SelectorValue)x).getType());
        }
        return Starlark.type(x);
    }

    private static Class<?> getNativeType(Object value) {
        if (value instanceof SelectorList) {
            return ((SelectorList)value).type;
        }
        if (value instanceof SelectorValue) {
            return ((SelectorValue)value).getType();
        }
        return value.getClass();
    }

    private static boolean isListType(Class<?> type) {
        return NATIVE_LIST_TYPE.isAssignableFrom(type);
    }

    private static boolean canConcatenate(Class<?> type1, Class<?> type2) {
        if (type1 == type2) {
            return true;
        }
        return SelectorList.isListType(type1) && SelectorList.isListType(type2);
    }

    public String toString() {
        return Starlark.repr(this);
    }

    @Override
    public void repr(Printer printer) {
        printer.printList(this.elements, "", " + ", "");
    }

    public int hashCode() {
        return Objects.hash(this.type, this.elements);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SelectorList)) {
            return false;
        }
        SelectorList that = (SelectorList)other;
        return Objects.equals(this.type, that.type) && Objects.equals(this.elements, that.elements);
    }

    @GlobalMethods(environment={GlobalMethods.Environment.BUILD, GlobalMethods.Environment.BZL})
    public static final class SelectLibrary {
        public static final SelectLibrary INSTANCE = new SelectLibrary();

        private SelectLibrary() {
        }

        @StarlarkMethod(name="select", doc="<code>select()</code> is the helper function that makes a rule attribute <a href=\"${link common-definitions#configurable-attributes}\">configurable</a>. See <a href=\"${link functions#select}\">build encyclopedia</a> for details.", parameters={@Param(name="x", positional=true, doc="A dict that maps configuration conditions to values. Each key is a <a href=\"../builtins/Label.html\">Label</a> or a label string that identifies a config_setting or constraint_value instance. See the <a href=\"https://bazel.build/rules/macros#label-resolution\">documentation on macros</a> for when to use a Label instead of a string."), @Param(name="no_match_error", defaultValue="''", doc="Optional custom error to report if no condition matches.", named=true)})
        public Object select(Dict<?, ?> dict, String noMatchError) throws EvalException {
            return SelectorList.select(dict, noMatchError);
        }
    }
}

