/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.packages.PackageGroupsRuleVisibility;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.SerializationConstant;
import java.util.List;
import javax.annotation.Nullable;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Starlark;

public interface RuleVisibility {
    @SerializationConstant
    public static final Label PUBLIC_LABEL = Label.parseCanonicalUnchecked("//visibility:public");
    @SerializationConstant
    public static final Label PRIVATE_LABEL = Label.parseCanonicalUnchecked("//visibility:private");
    @SerializationConstant
    public static final RuleVisibility PUBLIC = new RuleVisibility(){

        public ImmutableList<Label> getDependencyLabels() {
            return ImmutableList.of();
        }

        public ImmutableList<Label> getDeclaredLabels() {
            return ImmutableList.of(PUBLIC_LABEL);
        }

        public String toString() {
            return PUBLIC_LABEL.toString();
        }
    };
    @SerializationConstant
    public static final RuleVisibility PRIVATE = new RuleVisibility(){

        public ImmutableList<Label> getDependencyLabels() {
            return ImmutableList.of();
        }

        public ImmutableList<Label> getDeclaredLabels() {
            return ImmutableList.of(PRIVATE_LABEL);
        }

        public String toString() {
            return PRIVATE_LABEL.toString();
        }
    };

    public List<Label> getDependencyLabels();

    public List<Label> getDeclaredLabels();

    public static RuleVisibility parse(List<Label> labels) throws EvalException {
        RuleVisibility.validate(labels);
        return RuleVisibility.parseUnchecked(labels);
    }

    public static RuleVisibility parseUnchecked(List<Label> labels) {
        RuleVisibility result = RuleVisibility.parseIfConstant(labels);
        if (result != null) {
            return result;
        }
        return PackageGroupsRuleVisibility.create(labels);
    }

    @Nullable
    public static RuleVisibility parseIfConstant(List<Label> labels) {
        if (labels.size() != 1) {
            return null;
        }
        Label label = labels.get(0);
        if (label.equals(PUBLIC_LABEL)) {
            return PUBLIC;
        }
        if (label.equals(PRIVATE_LABEL)) {
            return PRIVATE;
        }
        return null;
    }

    public static void validate(List<Label> labels) throws EvalException {
        if (labels.size() <= 1) {
            return;
        }
        for (Label label : labels) {
            if (!label.equals(PUBLIC_LABEL) && !label.equals(PRIVATE_LABEL)) continue;
            throw Starlark.errorf("Public or private visibility labels (e.g. //visibility:public or //visibility:private) cannot be used in combination with other labels", new Object[0]);
        }
    }
}

