/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import com.google.devtools.build.lib.packages.Attribute;
import com.google.devtools.build.lib.packages.AttributeFormatter;
import com.google.devtools.build.lib.packages.RawAttributeMapper;
import com.google.devtools.build.lib.packages.Rule;
import com.google.devtools.build.lib.query2.proto.proto2api.Build;
import javax.annotation.Nullable;

public class RuleFormatter {
    private static final ImmutableSet<String> STARLARK_RULE_CLASS_COMPUTED_DEFAULT_ATTRIBUTES = ImmutableSet.of("timeout", "deprecation", "testonly");

    public static Build.Rule.Builder serializeRule(Rule rule) {
        Build.Rule.Builder builder = Build.Rule.newBuilder();
        builder.setName(rule.getLabel().getName());
        builder.setRuleClass(rule.getRuleClass());
        RawAttributeMapper rawAttributeMapper = RawAttributeMapper.of(rule);
        boolean isStarlark = rule.getRuleClassObject().isStarlark();
        if (isStarlark) {
            builder.setSkylarkEnvironmentHashCode(BaseEncoding.base16().lowerCase().encode(Preconditions.checkNotNull(rule.getRuleClassObject().getRuleDefinitionEnvironmentDigest(), rule)));
        }
        for (Attribute attr : rule.getAttributes()) {
            Object valueToSerialize;
            Object rawAttributeValue = rawAttributeMapper.getRawAttributeValue(rule, attr);
            boolean isExplicit = rule.isAttributeValueExplicitlySpecified(attr);
            if (!isStarlark && !isExplicit) continue;
            if (isExplicit) {
                valueToSerialize = rawAttributeValue;
            } else if (rawAttributeValue instanceof Attribute.ComputedDefault) {
                valueToSerialize = RuleFormatter.evaluateStarlarkComputedDefault(rawAttributeMapper, attr);
                if (valueToSerialize == null) {
                    continue;
                }
            } else {
                valueToSerialize = rawAttributeValue;
            }
            builder.addAttribute(AttributeFormatter.getAttributeProto(attr, valueToSerialize, isExplicit, false));
        }
        return builder;
    }

    @Nullable
    private static Object evaluateStarlarkComputedDefault(RawAttributeMapper rawAttributeMapper, Attribute attr) {
        if (STARLARK_RULE_CLASS_COMPUTED_DEFAULT_ATTRIBUTES.contains(attr.getName())) {
            return rawAttributeMapper.get(attr.getName(), attr.getType());
        }
        return null;
    }
}

