/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.cmdline.LabelSyntaxException;
import com.google.devtools.build.lib.events.EventHandler;
import com.google.devtools.build.lib.packages.Attribute;
import com.google.devtools.build.lib.packages.BazelStarlarkContext;
import com.google.devtools.build.lib.packages.Package;
import com.google.devtools.build.lib.packages.PackageFactory;
import com.google.devtools.build.lib.packages.Rule;
import com.google.devtools.build.lib.packages.RuleClass;
import com.google.devtools.build.lib.packages.RuleFunction;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Map;
import java.util.Set;
import net.starlark.java.eval.Dict;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.NoneType;
import net.starlark.java.eval.Printer;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.eval.Tuple;

public class RuleFactory {
    private RuleFactory() {
    }

    public static Rule createRule(Package.Builder pkgBuilder, RuleClass ruleClass, BuildLangTypedAttributeValuesMap attributeValues, EventHandler eventHandler, ImmutableList<StarlarkThread.CallStackEntry> callstack) throws InvalidRuleException, InterruptedException {
        Label label;
        Preconditions.checkNotNull(ruleClass);
        String ruleClassName = ruleClass.getName();
        Object nameObject = attributeValues.getAttributeValue("name");
        if (nameObject == null) {
            throw new InvalidRuleException(ruleClassName + " rule has no 'name' attribute");
        }
        if (!(nameObject instanceof String)) {
            throw new InvalidRuleException(ruleClassName + " 'name' attribute must be a string");
        }
        String name = (String)nameObject;
        try {
            label = pkgBuilder.createLabel(name);
        }
        catch (LabelSyntaxException e) {
            throw new InvalidRuleException("illegal rule name: " + name + ": " + e.getMessage());
        }
        boolean inWorkspaceFile = pkgBuilder.isRepoRulePackage();
        if (ruleClass.getWorkspaceOnly() && !inWorkspaceFile) {
            throw new InvalidRuleException(ruleClass + " must be in the WORKSPACE file (used by " + label + ")");
        }
        if (!ruleClass.getWorkspaceOnly() && inWorkspaceFile) {
            throw new InvalidRuleException(ruleClass + " cannot be in the WORKSPACE file (used by " + label + ")");
        }
        BuildLangTypedAttributeValuesMap attributes = RuleFactory.generatorAttributesForMacros(pkgBuilder, attributeValues, callstack);
        callstack = callstack.subList(0, callstack.size() - 1);
        try {
            return ruleClass.createRule(pkgBuilder, label, attributes, eventHandler, callstack);
        }
        catch (LabelSyntaxException | Attribute.StarlarkComputedDefaultTemplate.CannotPrecomputeDefaultsException e) {
            throw new InvalidRuleException(ruleClass + " " + e.getMessage());
        }
    }

    @CanIgnoreReturnValue
    public static Rule createAndAddRule(Package.Builder pkgBuilder, RuleClass ruleClass, BuildLangTypedAttributeValuesMap attributeValues, EventHandler eventHandler, ImmutableList<StarlarkThread.CallStackEntry> callstack) throws InvalidRuleException, Package.NameConflictException, InterruptedException {
        Rule rule = RuleFactory.createRule(pkgBuilder, ruleClass, attributeValues, eventHandler, callstack);
        pkgBuilder.addRule(rule);
        return rule;
    }

    private static BuildLangTypedAttributeValuesMap generatorAttributesForMacros(Package.Builder pkgBuilder, BuildLangTypedAttributeValuesMap args, ImmutableList<StarlarkThread.CallStackEntry> stack) {
        if (stack.size() < 2 || !((StarlarkThread.CallStackEntry)stack.get((int)1)).location.file().endsWith(".bzl")) {
            return args;
        }
        if (args.containsAttributeNamed("generator_name")) {
            return args;
        }
        ImmutableMap.Builder<String, Object> builder = ImmutableMap.builderWithExpectedSize(args.attributeValues.size() + 1);
        builder.putAll(args.attributeValues);
        String generatorName = pkgBuilder.getGeneratorNameByLocation(((StarlarkThread.CallStackEntry)stack.get((int)0)).location);
        if (generatorName == null) {
            generatorName = (String)args.getAttributeValue("name");
        }
        builder.put("generator_name", generatorName);
        return new BuildLangTypedAttributeValuesMap(builder.buildOrThrow());
    }

    public static ImmutableMap<String, BuiltinRuleFunction> buildRuleFunctions(Map<String, RuleClass> ruleClassMap) {
        ImmutableMap.Builder<String, BuiltinRuleFunction> result = ImmutableMap.builder();
        for (String ruleClassName : ruleClassMap.keySet()) {
            RuleClass cl = ruleClassMap.get(ruleClassName);
            if (cl.getRuleClassType() != RuleClass.Builder.RuleClassType.NORMAL && cl.getRuleClassType() != RuleClass.Builder.RuleClassType.TEST) continue;
            result.put(ruleClassName, new BuiltinRuleFunction(cl));
        }
        return result.buildOrThrow();
    }

    private static class BuiltinRuleFunction
    implements RuleFunction {
        private final RuleClass ruleClass;

        BuiltinRuleFunction(RuleClass ruleClass) {
            this.ruleClass = Preconditions.checkNotNull(ruleClass);
        }

        @Override
        public NoneType call(StarlarkThread thread, Tuple args, Dict<String, Object> kwargs) throws EvalException, InterruptedException {
            if (!args.isEmpty()) {
                throw Starlark.errorf("unexpected positional arguments", new Object[0]);
            }
            BazelStarlarkContext.from(thread).checkLoadingOrWorkspacePhase(this.ruleClass.getName());
            try {
                PackageFactory.PackageContext context = PackageFactory.getContext(thread);
                RuleFactory.createAndAddRule(context.pkgBuilder, this.ruleClass, new BuildLangTypedAttributeValuesMap(kwargs), context.eventHandler, thread.getCallStack());
            }
            catch (Package.NameConflictException | InvalidRuleException e) {
                throw new EvalException(e);
            }
            return Starlark.NONE;
        }

        @Override
        public RuleClass getRuleClass() {
            return this.ruleClass;
        }

        @Override
        public String getName() {
            return this.ruleClass.getName();
        }

        @Override
        public void repr(Printer printer) {
            printer.append("<built-in rule " + this.getName() + ">");
        }

        public String toString() {
            return this.getName() + "(...)";
        }

        @Override
        public boolean isImmutable() {
            return true;
        }
    }

    public static final class BuildLangTypedAttributeValuesMap
    implements AttributeValues<Map.Entry<String, Object>> {
        private final Map<String, Object> attributeValues;

        public BuildLangTypedAttributeValuesMap(Map<String, Object> attributeValues) {
            this.attributeValues = attributeValues;
        }

        private boolean containsAttributeNamed(String attributeName) {
            return this.attributeValues.containsKey(attributeName);
        }

        private Object getAttributeValue(String attributeName) {
            return this.attributeValues.get(attributeName);
        }

        @Override
        public boolean valuesAreBuildLanguageTyped() {
            return true;
        }

        @Override
        public Set<Map.Entry<String, Object>> getAttributeAccessors() {
            return this.attributeValues.entrySet();
        }

        @Override
        public String getName(Map.Entry<String, Object> attributeAccessor) {
            return attributeAccessor.getKey();
        }

        @Override
        public Object getValue(Map.Entry<String, Object> attributeAccessor) {
            return attributeAccessor.getValue();
        }

        @Override
        public boolean isExplicitlySpecified(Map.Entry<String, Object> attributeAccessor) {
            return true;
        }
    }

    public static interface AttributeValues<T> {
        public boolean valuesAreBuildLanguageTyped();

        public Iterable<T> getAttributeAccessors();

        public String getName(T var1);

        public Object getValue(T var1);

        public boolean isExplicitlySpecified(T var1);
    }

    public static class InvalidRuleException
    extends Exception {
        public InvalidRuleException(String message) {
            super(message);
        }
    }
}

