/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Interner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Streams;
import com.google.devtools.build.lib.analysis.config.Fragment;
import com.google.devtools.build.lib.analysis.config.ToolchainTypeRequirement;
import com.google.devtools.build.lib.analysis.config.transitions.PatchTransition;
import com.google.devtools.build.lib.analysis.config.transitions.TransitionFactory;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.cmdline.LabelSyntaxException;
import com.google.devtools.build.lib.events.EventHandler;
import com.google.devtools.build.lib.events.NullEventHandler;
import com.google.devtools.build.lib.packages.AdvertisedProviderSet;
import com.google.devtools.build.lib.packages.AggregatingAttributeMapper;
import com.google.devtools.build.lib.packages.AllowlistChecker;
import com.google.devtools.build.lib.packages.Aspect;
import com.google.devtools.build.lib.packages.Attribute;
import com.google.devtools.build.lib.packages.BuildSetting;
import com.google.devtools.build.lib.packages.BuildType;
import com.google.devtools.build.lib.packages.CallStack;
import com.google.devtools.build.lib.packages.ConfigurationFragmentPolicy;
import com.google.devtools.build.lib.packages.ExecGroup;
import com.google.devtools.build.lib.packages.ImplicitOutputsFunction;
import com.google.devtools.build.lib.packages.LabelConverter;
import com.google.devtools.build.lib.packages.License;
import com.google.devtools.build.lib.packages.NonconfigurableAttributeMapper;
import com.google.devtools.build.lib.packages.OutputFile;
import com.google.devtools.build.lib.packages.Package;
import com.google.devtools.build.lib.packages.PredicateWithMessage;
import com.google.devtools.build.lib.packages.PredicatesWithMessage;
import com.google.devtools.build.lib.packages.RawAttributeMapper;
import com.google.devtools.build.lib.packages.Rule;
import com.google.devtools.build.lib.packages.RuleFactory;
import com.google.devtools.build.lib.packages.RuleTransitionData;
import com.google.devtools.build.lib.packages.RuleVisibility;
import com.google.devtools.build.lib.packages.StarlarkProviderIdentifier;
import com.google.devtools.build.lib.packages.TargetUtils;
import com.google.devtools.build.lib.packages.TestSize;
import com.google.devtools.build.lib.packages.TestTimeout;
import com.google.devtools.build.lib.packages.Type;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.AutoCodec;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.SerializationConstant;
import com.google.devtools.build.lib.util.HashCodes;
import com.google.devtools.build.lib.util.StringUtil;
import com.google.devtools.build.lib.vfs.PathFragment;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkCallable;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.spelling.SpellChecker;

@Immutable
public class RuleClass {
    static final Attribute NAME_ATTRIBUTE = Attribute.attr("name", Type.STRING).nonconfigurable("All rules have a non-customizable \"name\" attribute").build();
    private static final int MAX_ATTRIBUTES = 200;
    private static final int MAX_ATTRIBUTE_NAME_LENGTH = 128;
    @SerializationConstant
    static final Function<? super Rule, Map<String, Label>> NO_EXTERNAL_BINDINGS = Functions.constant(ImmutableMap.of());
    @SerializationConstant
    static final Function<? super Rule, List<String>> NO_TOOLCHAINS_TO_REGISTER = Functions.constant(ImmutableList.of());
    @SerializationConstant
    static final Function<? super Rule, Set<String>> NO_OPTION_REFERENCE = Functions.constant(ImmutableSet.of());
    public static final PathFragment THIRD_PARTY_PREFIX = PathFragment.create("third_party");
    public static final PathFragment EXPERIMENTAL_PREFIX = PathFragment.create("experimental");
    public static final String APPLICABLE_LICENSES_ATTR = "applicable_licenses";
    public static final String RESTRICTED_ENVIRONMENT_ATTR = "restricted_to";
    public static final String COMPATIBLE_ENVIRONMENT_ATTR = "compatible_with";
    public static final String TARGET_COMPATIBLE_WITH_ATTR = "target_compatible_with";
    public static final String EXEC_COMPATIBLE_WITH_ATTR = "exec_compatible_with";
    public static final String EXEC_PROPERTIES_ATTR = "exec_properties";
    public static final String DEFAULT_RESTRICTED_ENVIRONMENT_ATTR = "$restricted_to";
    public static final String DEFAULT_COMPATIBLE_ENVIRONMENT_ATTR = "$compatible_with";
    public static final String CONFIG_SETTING_DEPS_ATTRIBUTE = "$config_dependencies";
    private final String name;
    private final ImmutableList<StarlarkThread.CallStackEntry> callstack;
    private final String key;
    private final String targetKind;
    private final Builder.RuleClassType type;
    private final boolean isStarlark;
    private final boolean starlarkTestable;
    private final boolean documented;
    private final boolean outputsToBindir;
    private final boolean workspaceOnly;
    private final boolean isExecutableStarlark;
    private final boolean isAnalysisTest;
    private final boolean hasAnalysisTestTransition;
    private final ImmutableList<AllowlistChecker> allowlistCheckers;
    private final boolean ignoreLicenses;
    private final boolean hasAspects;
    private final Map<String, Integer> attributeIndex;
    private final ImmutableList<Attribute> attributes;
    private final ImmutableList<String> nonConfigurableAttributes;
    private final ImplicitOutputsFunction implicitOutputsFunction;
    private final TransitionFactory<RuleTransitionData> transitionFactory;
    private final ConfiguredTargetFactory<?, ?, ?> configuredTargetFactory;
    private final PredicateWithMessage<Rule> validityPredicate;
    private final AdvertisedProviderSet advertisedProviders;
    @Nullable
    private final StarlarkCallable configuredTargetFunction;
    @Nullable
    private final BuildSetting buildSetting;
    private final Function<? super Rule, Map<String, Label>> externalBindingsFunction;
    private final Function<? super Rule, ? extends List<String>> toolchainsToRegisterFunction;
    private final Function<? super Rule, ? extends Set<String>> optionReferenceFunction;
    @Nullable
    private final Label ruleDefinitionEnvironmentLabel;
    @Nullable
    private final byte[] ruleDefinitionEnvironmentDigest;
    private final OutputFile.Kind outputFileKind;
    private final ConfigurationFragmentPolicy configurationFragmentPolicy;
    private final boolean supportsConstraintChecking;
    private final ImmutableSet<ToolchainTypeRequirement> toolchainTypes;
    private final ToolchainResolutionMode useToolchainResolution;
    private final ImmutableSet<Label> executionPlatformConstraints;
    private final ImmutableMap<String, ExecGroup> execGroups;

    @VisibleForTesting
    RuleClass(String name, ImmutableList<StarlarkThread.CallStackEntry> callstack, String key, Builder.RuleClassType type, boolean isStarlark, boolean starlarkTestable, boolean documented, boolean outputsToBindir, boolean workspaceOnly, boolean isExecutableStarlark, boolean isAnalysisTest, boolean hasAnalysisTestTransition, ImmutableList<AllowlistChecker> allowlistCheckers, boolean ignoreLicenses, ImplicitOutputsFunction implicitOutputsFunction, TransitionFactory<RuleTransitionData> transitionFactory, ConfiguredTargetFactory<?, ?, ?> configuredTargetFactory, PredicateWithMessage<Rule> validityPredicate, AdvertisedProviderSet advertisedProviders, @Nullable StarlarkCallable configuredTargetFunction, Function<? super Rule, Map<String, Label>> externalBindingsFunction, Function<? super Rule, ? extends List<String>> toolchainsToRegisterFunction, Function<? super Rule, ? extends Set<String>> optionReferenceFunction, @Nullable Label ruleDefinitionEnvironmentLabel, @Nullable byte[] ruleDefinitionEnvironmentDigest, ConfigurationFragmentPolicy configurationFragmentPolicy, boolean supportsConstraintChecking, Set<ToolchainTypeRequirement> toolchainTypes, ToolchainResolutionMode useToolchainResolution, Set<Label> executionPlatformConstraints, Map<String, ExecGroup> execGroups, OutputFile.Kind outputFileKind, ImmutableList<Attribute> attributes, @Nullable BuildSetting buildSetting) {
        this.name = name;
        this.callstack = callstack;
        this.key = key;
        this.type = type;
        this.isStarlark = isStarlark;
        this.targetKind = name + Rule.targetKindSuffix();
        this.starlarkTestable = starlarkTestable;
        this.documented = documented;
        this.outputsToBindir = outputsToBindir;
        this.implicitOutputsFunction = implicitOutputsFunction;
        this.transitionFactory = transitionFactory;
        this.configuredTargetFactory = configuredTargetFactory;
        this.validityPredicate = validityPredicate;
        this.advertisedProviders = advertisedProviders;
        this.configuredTargetFunction = configuredTargetFunction;
        this.externalBindingsFunction = externalBindingsFunction;
        this.toolchainsToRegisterFunction = toolchainsToRegisterFunction;
        this.optionReferenceFunction = optionReferenceFunction;
        this.ruleDefinitionEnvironmentLabel = ruleDefinitionEnvironmentLabel;
        this.ruleDefinitionEnvironmentDigest = ruleDefinitionEnvironmentDigest;
        this.outputFileKind = outputFileKind;
        this.attributes = attributes;
        this.workspaceOnly = workspaceOnly;
        this.isExecutableStarlark = isExecutableStarlark;
        this.isAnalysisTest = isAnalysisTest;
        this.hasAnalysisTestTransition = hasAnalysisTestTransition;
        this.allowlistCheckers = allowlistCheckers;
        this.ignoreLicenses = ignoreLicenses;
        this.configurationFragmentPolicy = configurationFragmentPolicy;
        this.supportsConstraintChecking = supportsConstraintChecking;
        this.toolchainTypes = ImmutableSet.copyOf(toolchainTypes);
        this.useToolchainResolution = useToolchainResolution;
        this.executionPlatformConstraints = ImmutableSet.copyOf(executionPlatformConstraints);
        this.execGroups = ImmutableMap.copyOf(execGroups);
        this.buildSetting = buildSetting;
        Preconditions.checkState(!attributes.isEmpty() && ((Attribute)attributes.get(0)).equals(NAME_ATTRIBUTE), "Rule %s does not have name as its first attribute: %s", (Object)name, attributes);
        this.attributeIndex = Maps.newHashMapWithExpectedSize(attributes.size());
        HashMap<String, Attribute> publicToPrivateNames = Maps.newHashMapWithExpectedSize(attributes.size());
        boolean computedHasAspects = false;
        ImmutableList.Builder nonConfigurableAttributes = ImmutableList.builder();
        for (int i = 0; i < attributes.size(); ++i) {
            Attribute attribute = (Attribute)attributes.get(i);
            String publicName = attribute.getPublicName();
            Attribute conflicting = publicToPrivateNames.put(publicName, attribute);
            if (conflicting != null) {
                throw new IllegalStateException(String.format("Rule %s: Attributes %s and %s have an identical public name: %s", name, attribute.getName(), conflicting.getName(), publicName));
            }
            computedHasAspects |= attribute.hasAspects();
            this.attributeIndex.put(attribute.getName(), i);
            if (attribute.isConfigurable()) continue;
            nonConfigurableAttributes.add(attribute.getName());
        }
        this.hasAspects = computedHasAspects;
        this.nonConfigurableAttributes = nonConfigurableAttributes.build();
    }

    public ImplicitOutputsFunction getDefaultImplicitOutputsFunction() {
        return this.implicitOutputsFunction;
    }

    public TransitionFactory<RuleTransitionData> getTransitionFactory() {
        return this.transitionFactory;
    }

    public <T extends ConfiguredTargetFactory<?, ?, ?>> T getConfiguredTargetFactory(Class<T> clazz) {
        return (T)((ConfiguredTargetFactory)clazz.cast(this.configuredTargetFactory));
    }

    public String getName() {
        return this.name;
    }

    public ImmutableList<StarlarkThread.CallStackEntry> getCallStack() {
        return this.callstack;
    }

    public Builder.RuleClassType getRuleClassType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    String getTargetKind() {
        return this.targetKind;
    }

    public boolean getWorkspaceOnly() {
        return this.workspaceOnly;
    }

    public boolean hasAttr(String attrName, Type<?> type) {
        Integer index = this.getAttributeIndex(attrName);
        return index != null && this.getAttribute(index).getType() == type;
    }

    Integer getAttributeIndex(String attrName) {
        return this.attributeIndex.get(attrName);
    }

    Attribute getAttribute(int attrIndex) {
        return (Attribute)this.attributes.get(attrIndex);
    }

    public Attribute getAttributeByName(String attrName) {
        Integer attrIndex = Preconditions.checkNotNull(this.getAttributeIndex(attrName), "Attribute %s does not exist", (Object)attrName);
        return (Attribute)this.attributes.get(attrIndex);
    }

    @Nullable
    public Attribute getAttributeByNameMaybe(String attrName) {
        Integer i = this.getAttributeIndex(attrName);
        return i == null ? null : (Attribute)this.attributes.get(i);
    }

    int getAttributeCount() {
        return this.attributeIndex.size();
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    List<String> getNonConfigurableAttributes() {
        return this.nonConfigurableAttributes;
    }

    public PredicateWithMessage<Rule> getValidityPredicate() {
        return this.validityPredicate;
    }

    public AdvertisedProviderSet getAdvertisedProviders() {
        return this.advertisedProviders;
    }

    public ConfigurationFragmentPolicy getConfigurationFragmentPolicy() {
        return this.configurationFragmentPolicy;
    }

    public boolean supportsConstraintChecking() {
        return this.supportsConstraintChecking;
    }

    boolean hasAspects() {
        return this.hasAspects;
    }

    <T> Rule createRule(Package.Builder pkgBuilder, Label ruleLabel, RuleFactory.AttributeValues<T> attributeValues, EventHandler eventHandler, List<StarlarkThread.CallStackEntry> callstack) throws LabelSyntaxException, InterruptedException, Attribute.StarlarkComputedDefaultTemplate.CannotPrecomputeDefaultsException {
        Rule rule = pkgBuilder.createRule(ruleLabel, this, callstack);
        this.populateRuleAttributeValues(rule, pkgBuilder, attributeValues, eventHandler);
        RuleClass.checkAspectAllowedValues(rule, eventHandler);
        rule.populateOutputFiles(eventHandler, pkgBuilder);
        RuleClass.checkForDuplicateLabels(rule, eventHandler);
        RuleClass.checkForValidSizeAndTimeoutValues(rule, eventHandler);
        rule.checkValidityPredicate(eventHandler);
        return rule;
    }

    <T> Rule createRuleUnchecked(Package.Builder pkgBuilder, Label ruleLabel, RuleFactory.AttributeValues<T> attributeValues, CallStack.Node callstack, ImplicitOutputsFunction implicitOutputsFunction) throws InterruptedException, Attribute.StarlarkComputedDefaultTemplate.CannotPrecomputeDefaultsException {
        Rule rule = pkgBuilder.createRule(ruleLabel, this, callstack.toLocation(), callstack.next());
        this.populateRuleAttributeValues(rule, pkgBuilder, attributeValues, NullEventHandler.INSTANCE);
        rule.populateOutputFilesUnchecked(pkgBuilder, implicitOutputsFunction);
        return rule;
    }

    private <T> void populateRuleAttributeValues(Rule rule, Package.Builder pkgBuilder, RuleFactory.AttributeValues<T> attributeValues, EventHandler eventHandler) throws InterruptedException, Attribute.StarlarkComputedDefaultTemplate.CannotPrecomputeDefaultsException {
        BitSet definedAttrIndices = this.populateDefinedRuleAttributeValues(rule, pkgBuilder.getLabelConverter(), attributeValues, pkgBuilder.getListInterner(), eventHandler);
        this.populateDefaultRuleAttributeValues(rule, pkgBuilder, definedAttrIndices, eventHandler);
        RuleClass.populateConfigDependenciesAttribute(rule);
    }

    private <T> BitSet populateDefinedRuleAttributeValues(Rule rule, LabelConverter labelConverter, RuleFactory.AttributeValues<T> attributeValues, Interner<ImmutableList<?>> listInterner, EventHandler eventHandler) {
        BitSet definedAttrIndices = new BitSet();
        for (T attributeAccessor : attributeValues.getAttributeAccessors()) {
            Object nativeAttributeValue;
            Attribute attr;
            Integer attrIndex;
            block9: {
                String attributeName = attributeValues.getName(attributeAccessor);
                Object attributeValue = attributeValues.getValue(attributeAccessor);
                if (attributeValue == Starlark.NONE) continue;
                attrIndex = this.getAttributeIndex(attributeName);
                if (attrIndex == null) {
                    rule.reportError(String.format("%s: no such attribute '%s' in '%s' rule%s", rule.getLabel(), attributeName, this.name, SpellChecker.didYouMean(attributeName, rule.getAttributes().stream().filter(Attribute::isDocumented).map(Attribute::getName).collect(ImmutableList.toImmutableList()))), eventHandler);
                    continue;
                }
                attr = this.getAttribute(attrIndex);
                if (attributeName.equals("licenses") && this.ignoreLicenses) {
                    rule.setAttributeValue(attr, License.NO_LICENSE, false);
                    definedAttrIndices.set(attrIndex);
                    continue;
                }
                if (attributeValues.valuesAreBuildLanguageTyped()) {
                    try {
                        nativeAttributeValue = RuleClass.convertFromBuildLangType(rule, attr, attributeValue, labelConverter, listInterner);
                        break block9;
                    }
                    catch (Type.ConversionException e) {
                        rule.reportError(String.format("%s: %s", rule.getLabel(), e.getMessage()), eventHandler);
                        continue;
                    }
                }
                nativeAttributeValue = attributeValue;
            }
            if (attr.getName().equals("visibility")) {
                List vis = (List)nativeAttributeValue;
                try {
                    RuleVisibility.validate(vis);
                }
                catch (EvalException e) {
                    rule.reportError(rule.getLabel() + " " + e.getMessage(), eventHandler);
                }
            }
            boolean explicit = attributeValues.isExplicitlySpecified(attributeAccessor);
            rule.setAttributeValue(attr, nativeAttributeValue, explicit);
            RuleClass.checkAllowedValues(rule, attr, eventHandler);
            definedAttrIndices.set(attrIndex);
        }
        return definedAttrIndices;
    }

    private void populateDefaultRuleAttributeValues(Rule rule, Package.Builder pkgBuilder, BitSet definedAttrIndices, EventHandler eventHandler) throws InterruptedException, Attribute.StarlarkComputedDefaultTemplate.CannotPrecomputeDefaultsException {
        ArrayList<Attribute> attrsWithComputedDefaults = new ArrayList<Attribute>();
        int numAttributes = this.getAttributeCount();
        for (int attrIndex = 0; attrIndex < numAttributes; ++attrIndex) {
            if (definedAttrIndices.get(attrIndex)) continue;
            Attribute attr = this.getAttribute(attrIndex);
            if (attr.isMandatory()) {
                rule.reportError(String.format("%s: missing value for mandatory attribute '%s' in '%s' rule", rule.getLabel(), attr.getName(), this.name), eventHandler);
            }
            if (attr.hasComputedDefault()) {
                attrsWithComputedDefaults.add(attr);
                continue;
            }
            if (attr.isLateBound()) {
                rule.setAttributeValue(attr, attr.getLateBoundDefault(), false);
                continue;
            }
            if (attr.getName().equals(APPLICABLE_LICENSES_ATTR) && attr.getType() == BuildType.LABEL_LIST) {
                if (rule.getRuleClassObject().isPackageMetadataRule()) continue;
                rule.setAttributeValue(attr, pkgBuilder.getDefaultPackageMetadata(), false);
                continue;
            }
            if (attr.getName().equals("licenses") && attr.getType() == BuildType.LICENSE) {
                rule.setAttributeValue(attr, this.ignoreLicenses ? License.NO_LICENSE : pkgBuilder.getDefaultLicense(), false);
                continue;
            }
            if (!attr.getName().equals("distribs") || attr.getType() != BuildType.DISTRIBUTIONS) continue;
            rule.setAttributeValue(attr, pkgBuilder.getDefaultDistribs(), false);
        }
        if (this.name.equals("test_suite") && !this.isStarlark) {
            Attribute implicitTests = this.getAttributeByName("$implicit_tests");
            NonconfigurableAttributeMapper attributeMapper = NonconfigurableAttributeMapper.of(rule);
            if (implicitTests != null && ((List)((Object)attributeMapper.get("tests", BuildType.LABEL_LIST))).isEmpty()) {
                boolean explicit = true;
                rule.setAttributeValue(implicitTests, pkgBuilder.getTestSuiteImplicitTestsRef((List)((Object)attributeMapper.get("tags", Type.STRING_LIST))), explicit);
            }
        }
        for (Attribute attr : attrsWithComputedDefaults) {
            Object valueToSet;
            Object defaultValue = attr.getDefaultValue();
            if (defaultValue instanceof Attribute.StarlarkComputedDefaultTemplate) {
                Attribute.StarlarkComputedDefaultTemplate template = (Attribute.StarlarkComputedDefaultTemplate)defaultValue;
                valueToSet = template.computePossibleValues(attr, rule, eventHandler);
            } else if (defaultValue instanceof Attribute.ComputedDefault) {
                ((Attribute.ComputedDefault)defaultValue).getPossibleValues(attr.getType(), rule);
                valueToSet = defaultValue;
            } else {
                valueToSet = defaultValue;
            }
            rule.setAttributeValue(attr, valueToSet, false);
        }
    }

    private static void populateConfigDependenciesAttribute(Rule rule) {
        RawAttributeMapper attributes = RawAttributeMapper.of(rule);
        Attribute configDepsAttribute = attributes.getAttributeDefinition(CONFIG_SETTING_DEPS_ATTRIBUTE);
        if (configDepsAttribute == null) {
            return;
        }
        LinkedHashSet<Label> configLabels = new LinkedHashSet<Label>();
        for (Attribute attr : rule.getAttributes()) {
            BuildType.SelectorList<?> selectorList = attributes.getSelectorList(attr.getName(), attr.getType());
            if (selectorList == null) continue;
            configLabels.addAll(selectorList.getKeyLabels());
        }
        rule.setAttributeValue(configDepsAttribute, ImmutableList.copyOf(configLabels), false);
    }

    private static void checkForDuplicateLabels(Rule rule, EventHandler eventHandler) {
        AggregatingAttributeMapper mapper = AggregatingAttributeMapper.of(rule);
        for (Attribute attribute : rule.getAttributes()) {
            if (attribute.getType() != BuildType.LABEL_LIST) continue;
            Set<Label> duplicates = mapper.checkForDuplicateLabels(attribute);
            for (Label label : duplicates) {
                rule.reportError(String.format("Label '%s' is duplicated in the '%s' attribute of rule '%s'", label, attribute.getName(), rule.getName()), eventHandler);
            }
        }
    }

    private static void checkForValidSizeAndTimeoutValues(Rule rule, EventHandler eventHandler) {
        String timeout;
        String size;
        if (rule.getRuleClassObject().hasAttr("size", Type.STRING) && TestSize.getTestSize(size = NonconfigurableAttributeMapper.of(rule).get("size", Type.STRING)) == null) {
            rule.reportError(String.format("In rule '%s', size '%s' is not a valid size.", rule.getName(), size), eventHandler);
        }
        if (rule.getRuleClassObject().hasAttr("timeout", Type.STRING) && TestTimeout.getTestTimeout(timeout = NonconfigurableAttributeMapper.of(rule).get("timeout", Type.STRING)) == null) {
            rule.reportError(String.format("In rule '%s', timeout '%s' is not a valid timeout.", rule.getName(), timeout), eventHandler);
        }
    }

    private static Object convertFromBuildLangType(Rule rule, Attribute attr, Object buildLangValue, LabelConverter labelConverter, Interner<ImmutableList<?>> listInterner) throws Type.ConversionException {
        List converted = BuildType.selectableConvert(attr.getType(), buildLangValue, new AttributeConversionContext(attr.getName(), rule.getRuleClass()), labelConverter);
        if (converted instanceof BuildType.SelectorList && !attr.isConfigurable()) {
            throw new Type.ConversionException(String.format("attribute \"%s\" is not configurable", attr.getName()));
        }
        if (converted instanceof List) {
            if (attr.isOrderIndependent()) {
                List list = converted;
                converted = Ordering.natural().sortedCopy(list);
            }
            converted = listInterner.intern(ImmutableList.copyOf(converted));
        }
        return converted;
    }

    private static void checkAllowedValues(Rule rule, Attribute attribute, EventHandler eventHandler) {
        if (attribute.checkAllowedValues()) {
            PredicateWithMessage<Object> allowedValues = attribute.getAllowedValues();
            Iterable<?> values = AggregatingAttributeMapper.of(rule).visitAttribute(attribute.getName(), attribute.getType());
            for (Object value : values) {
                if (allowedValues.apply(value)) continue;
                rule.reportError(String.format("%s: invalid value in '%s' attribute: %s", rule.getLabel(), attribute.getName(), allowedValues.getErrorReason(value)), eventHandler);
            }
        }
    }

    private static void checkAspectAllowedValues(Rule rule, EventHandler eventHandler) {
        if (rule.hasAspects()) {
            for (Attribute attrOfRule : rule.getAttributes()) {
                for (Aspect aspect : attrOfRule.getAspects(rule)) {
                    for (Attribute attrOfAspect : aspect.getDefinition().getAttributes().values()) {
                        Object value;
                        PredicateWithMessage<Object> allowedValues;
                        if (!attrOfAspect.checkAllowedValues() || (allowedValues = attrOfAspect.getAllowedValues()).apply(value = attrOfAspect.getDefaultValue())) continue;
                        if (RawAttributeMapper.of(rule).isConfigurable(attrOfAspect.getName())) {
                            rule.reportError(String.format("%s: attribute '%s' has a select() and aspect %s also declares '%s'. Aspect attributes don't currently support select().", rule.getLabel(), attrOfAspect.getName(), aspect.getDefinition().getName(), rule.getLabel()), eventHandler);
                            continue;
                        }
                        rule.reportError(String.format("%s: invalid value in '%s' attribute: %s", rule.getLabel(), attrOfAspect.getName(), allowedValues.getErrorReason(value)), eventHandler);
                    }
                }
            }
        }
    }

    public String toString() {
        return this.name;
    }

    public boolean isDocumented() {
        return this.documented;
    }

    public boolean outputsToBindir() {
        return this.outputsToBindir;
    }

    @Nullable
    public StarlarkCallable getConfiguredTargetFunction() {
        return this.configuredTargetFunction;
    }

    @Nullable
    public BuildSetting getBuildSetting() {
        return this.buildSetting;
    }

    Function<? super Rule, Map<String, Label>> getExternalBindingsFunction() {
        return this.externalBindingsFunction;
    }

    Function<? super Rule, ? extends List<String>> getToolchainsToRegisterFunction() {
        return this.toolchainsToRegisterFunction;
    }

    public Function<? super Rule, ? extends Set<String>> getOptionReferenceFunction() {
        return this.optionReferenceFunction;
    }

    @Nullable
    public Label getRuleDefinitionEnvironmentLabel() {
        return this.ruleDefinitionEnvironmentLabel;
    }

    @Nullable
    public byte[] getRuleDefinitionEnvironmentDigest() {
        return this.ruleDefinitionEnvironmentDigest;
    }

    public boolean isStarlark() {
        return this.isStarlark;
    }

    public boolean isStarlarkTestable() {
        return this.starlarkTestable;
    }

    public boolean isExecutableStarlark() {
        return this.isExecutableStarlark;
    }

    boolean isAnalysisTest() {
        return this.isAnalysisTest;
    }

    boolean hasAnalysisTestTransition() {
        return this.hasAnalysisTestTransition;
    }

    public ImmutableList<AllowlistChecker> getAllowlistCheckers() {
        return this.allowlistCheckers;
    }

    boolean ignoreLicenses() {
        return this.ignoreLicenses;
    }

    public ImmutableSet<ToolchainTypeRequirement> getToolchainTypes() {
        return this.toolchainTypes;
    }

    ToolchainResolutionMode useToolchainResolution() {
        return this.useToolchainResolution;
    }

    public ImmutableSet<Label> getExecutionPlatformConstraints() {
        return this.executionPlatformConstraints;
    }

    public ImmutableMap<String, ExecGroup> getExecGroups() {
        return this.execGroups;
    }

    OutputFile.Kind getOutputFileKind() {
        return this.outputFileKind;
    }

    public boolean isPackageMetadataRule() {
        if (this.ruleDefinitionEnvironmentLabel == null) {
            return false;
        }
        if (this.ruleDefinitionEnvironmentLabel.getRepository().getName().equals("rules_license")) {
            return true;
        }
        String packageName = this.ruleDefinitionEnvironmentLabel.getPackageName();
        return packageName.startsWith("tools/build_defs/license") || packageName.startsWith("third_party/rules_license");
    }

    private static class AttributeConversionContext {
        private final String attrName;
        private final String ruleClass;

        AttributeConversionContext(String attrName, String ruleClass) {
            this.attrName = attrName;
            this.ruleClass = ruleClass;
        }

        public String toString() {
            return "attribute '" + this.attrName + "' in '" + this.ruleClass + "' rule";
        }
    }

    public static final class Builder {
        private static final Pattern RULE_NAME_PATTERN = Pattern.compile("[A-Za-z_][A-Za-z0-9_]*");
        public static final String STARLARK_BUILD_SETTING_DEFAULT_ATTR_NAME = "build_setting_default";
        static final String STARLARK_BUILD_SETTING_HELP_ATTR_NAME = "help";
        static final String BUILD_SETTING_DEFAULT_NONCONFIGURABLE = "Build setting defaults are referenced during analysis.";
        static final ImmutableList<Attribute> REQUIRED_ATTRIBUTES_FOR_NORMAL_RULES = ImmutableList.of(Attribute.attr("tags", Type.STRING_LIST).build());
        static final ImmutableList<Attribute> REQUIRED_ATTRIBUTES_FOR_TESTS = ImmutableList.of(Attribute.attr("tags", Type.STRING_LIST).build(), Attribute.attr("size", Type.STRING).build(), Attribute.attr("timeout", Type.STRING).build(), Attribute.attr("flaky", Type.BOOLEAN).build(), Attribute.attr("shard_count", Type.INTEGER).build(), Attribute.attr("local", Type.BOOLEAN).build());
        private final String name;
        private ImmutableList<StarlarkThread.CallStackEntry> callstack = ImmutableList.of();
        private final RuleClassType type;
        private final boolean starlark;
        private boolean starlarkTestable = false;
        private boolean documented;
        private boolean outputsToBindir = true;
        private boolean workspaceOnly = false;
        private boolean isExecutableStarlark = false;
        private boolean isAnalysisTest = false;
        private boolean hasAnalysisTestTransition = false;
        private final ImmutableList.Builder<AllowlistChecker> allowlistCheckers = ImmutableList.builder();
        private boolean hasStarlarkRuleTransition = false;
        private boolean ignoreLicenses = false;
        private ImplicitOutputsFunction implicitOutputsFunction = ImplicitOutputsFunction.NONE;
        private TransitionFactory<RuleTransitionData> transitionFactory;
        private ConfiguredTargetFactory<?, ?, ?> configuredTargetFactory = null;
        private PredicateWithMessage<Rule> validityPredicate = PredicatesWithMessage.alwaysTrue();
        private final AdvertisedProviderSet.Builder advertisedProviders = AdvertisedProviderSet.builder();
        private StarlarkCallable configuredTargetFunction = null;
        private BuildSetting buildSetting = null;
        private Function<? super Rule, Map<String, Label>> externalBindingsFunction = NO_EXTERNAL_BINDINGS;
        private Function<? super Rule, ? extends List<String>> toolchainsToRegisterFunction = NO_TOOLCHAINS_TO_REGISTER;
        private Function<? super Rule, ? extends Set<String>> optionReferenceFunction = NO_OPTION_REFERENCE;
        @Nullable
        private Label ruleDefinitionEnvironmentLabel;
        @Nullable
        private byte[] ruleDefinitionEnvironmentDigest = null;
        private final ConfigurationFragmentPolicy.Builder configurationFragmentPolicy = new ConfigurationFragmentPolicy.Builder();
        private boolean supportsConstraintChecking = true;
        private final Map<String, Attribute> attributes = new LinkedHashMap<String, Attribute>();
        private final Set<ToolchainTypeRequirement> toolchainTypes = new HashSet<ToolchainTypeRequirement>();
        private ToolchainResolutionMode useToolchainResolution = ToolchainResolutionMode.INHERIT;
        private final Set<Label> executionPlatformConstraints = new HashSet<Label>();
        private OutputFile.Kind outputFileKind = OutputFile.Kind.FILE;
        private final Map<String, ExecGroup> execGroups = new HashMap<String, ExecGroup>();

        public Builder(String name, RuleClassType type, boolean starlark, RuleClass ... parents) {
            this.name = name;
            this.starlark = starlark;
            this.type = type;
            Preconditions.checkState(starlark || type != RuleClassType.PLACEHOLDER, name);
            this.documented = type != RuleClassType.ABSTRACT;
            this.addAttribute(NAME_ATTRIBUTE);
            for (RuleClass parent : parents) {
                if (parent.getValidityPredicate() != PredicatesWithMessage.alwaysTrue()) {
                    this.setValidityPredicate(parent.getValidityPredicate());
                }
                this.configurationFragmentPolicy.includeConfigurationFragmentsFrom(parent.getConfigurationFragmentPolicy());
                this.supportsConstraintChecking = parent.supportsConstraintChecking;
                this.addToolchainTypes(parent.getToolchainTypes());
                this.useToolchainResolution = this.useToolchainResolution.apply(name, parent.useToolchainResolution);
                this.addExecutionPlatformConstraints(parent.getExecutionPlatformConstraints());
                try {
                    this.addExecGroups(parent.getExecGroups());
                }
                catch (DuplicateExecGroupError e) {
                    throw new IllegalArgumentException(String.format("An execution group named '%s' is inherited multiple times with different requirements in %s ruleclass", e.getDuplicateGroup(), name));
                }
                for (Attribute attribute : parent.getAttributes()) {
                    String attrName = attribute.getName();
                    Preconditions.checkArgument(!this.attributes.containsKey(attrName) || this.attributes.get(attrName).equals(attribute), "Attribute %s is inherited multiple times in %s ruleclass", (Object)attrName, (Object)name);
                    this.attributes.put(attrName, attribute);
                }
                this.allowlistCheckers.addAll(parent.getAllowlistCheckers());
                this.advertisedProviders.addParent(parent.getAdvertisedProviders());
            }
            if (this.type.equals((Object)RuleClassType.TEST)) {
                Attribute.Builder<Boolean> testOnlyAttr = Attribute.attr("testonly", Type.BOOLEAN).value(true).nonconfigurable("policy decision: this shouldn't depend on the configuration");
                if (this.attributes.containsKey("testonly")) {
                    this.override(testOnlyAttr);
                } else {
                    this.add(testOnlyAttr);
                }
            }
        }

        public RuleClass build() {
            return this.build(this.name, this.name);
        }

        public RuleClass build(String name, String key) {
            Preconditions.checkArgument(this.name.isEmpty() || this.name.equals(name));
            this.type.checkName(name);
            Builder.checkAttributes(name, this.type, this.attributes);
            Preconditions.checkState(this.type == RuleClassType.ABSTRACT == (this.configuredTargetFactory == null && this.configuredTargetFunction == null), "Bad combo for %s: %s %s %s", (Object)name, (Object)this.type, this.configuredTargetFactory, (Object)this.configuredTargetFunction);
            if (!this.workspaceOnly) {
                if (this.starlark) {
                    this.assertStarlarkRuleClassHasImplementationFunction();
                    this.assertStarlarkRuleClassHasEnvironmentLabel();
                }
                Preconditions.checkState(this.externalBindingsFunction == NO_EXTERNAL_BINDINGS);
                Preconditions.checkState(this.toolchainsToRegisterFunction == NO_TOOLCHAINS_TO_REGISTER);
            }
            if (this.type == RuleClassType.PLACEHOLDER) {
                Preconditions.checkNotNull(this.ruleDefinitionEnvironmentDigest, this.name);
            }
            if (this.buildSetting != null) {
                Type<?> type = this.buildSetting.getType();
                Attribute.Builder<?> defaultAttrBuilder = Attribute.attr(STARLARK_BUILD_SETTING_DEFAULT_ATTR_NAME, type).nonconfigurable(BUILD_SETTING_DEFAULT_NONCONFIGURABLE).mandatory();
                this.add(defaultAttrBuilder);
                this.add(Attribute.attr(STARLARK_BUILD_SETTING_HELP_ATTR_NAME, Type.STRING).nonconfigurable(BUILD_SETTING_DEFAULT_NONCONFIGURABLE));
                this.useToolchainResolution(ToolchainResolutionMode.DISABLED);
            }
            return new RuleClass(name, this.callstack, key, this.type, this.starlark, this.starlarkTestable, this.documented, this.outputsToBindir, this.workspaceOnly, this.isExecutableStarlark, this.isAnalysisTest, this.hasAnalysisTestTransition, (ImmutableList<AllowlistChecker>)this.allowlistCheckers.build(), this.ignoreLicenses, this.implicitOutputsFunction, this.transitionFactory, this.configuredTargetFactory, this.validityPredicate, this.advertisedProviders.build(), this.configuredTargetFunction, this.externalBindingsFunction, this.toolchainsToRegisterFunction, this.optionReferenceFunction, this.ruleDefinitionEnvironmentLabel, this.ruleDefinitionEnvironmentDigest, this.configurationFragmentPolicy.build(), this.supportsConstraintChecking, this.toolchainTypes, this.useToolchainResolution, this.executionPlatformConstraints, this.execGroups, this.outputFileKind, ImmutableList.copyOf(this.attributes.values()), this.buildSetting);
        }

        private static void checkAttributes(String ruleClassName, RuleClassType ruleClassType, Map<String, Attribute> attributes) {
            Preconditions.checkArgument(attributes.size() <= 200, "Rule class %s declared too many attributes (%s > %s)", (Object)ruleClassName, (Object)attributes.size(), (Object)200);
            for (String attributeName : attributes.keySet()) {
                Preconditions.checkArgument(attributeName.length() <= 128, "Attribute %s.%s's name is too long (%s > %s)", (Object)ruleClassName, (Object)attributeName, (Object)attributeName.length(), (Object)128);
            }
            ruleClassType.checkAttributes(attributes);
        }

        private void assertStarlarkRuleClassHasImplementationFunction() {
            Preconditions.checkState((this.type == RuleClassType.NORMAL || this.type == RuleClassType.TEST) == (this.configuredTargetFunction != null), "%s %s", (Object)this.type, (Object)this.configuredTargetFunction);
        }

        private void assertStarlarkRuleClassHasEnvironmentLabel() {
            Preconditions.checkState((this.type == RuleClassType.NORMAL || this.type == RuleClassType.TEST || this.type == RuleClassType.PLACEHOLDER) == (this.ruleDefinitionEnvironmentLabel != null), "Concrete Starlark rule classes can't have null labels: %s %s", (Object)this.ruleDefinitionEnvironmentLabel, (Object)this.type);
        }

        @CanIgnoreReturnValue
        public Builder requiresConfigurationFragments(Class<? extends Fragment> ... configurationFragments) {
            this.configurationFragmentPolicy.requiresConfigurationFragments(ImmutableSet.copyOf(configurationFragments));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder requiresConfigurationFragmentsByStarlarkModuleName(Collection<String> configurationFragmentNames) {
            this.configurationFragmentPolicy.requiresConfigurationFragmentsByStarlarkBuiltinName(configurationFragmentNames);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCallStack(ImmutableList<StarlarkThread.CallStackEntry> callstack) {
            this.callstack = callstack;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setStarlarkTestable() {
            Preconditions.checkState(this.starlark, "Cannot set starlarkTestable on a non-Starlark rule");
            this.starlarkTestable = true;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMissingFragmentPolicy(Class<?> fragmentClass, ConfigurationFragmentPolicy.MissingFragmentPolicy missingFragmentPolicy) {
            this.configurationFragmentPolicy.setMissingFragmentPolicy(fragmentClass, missingFragmentPolicy);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setUndocumented() {
            this.documented = false;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setWorkspaceOnly() {
            this.workspaceOnly = true;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setOutputToGenfiles() {
            Preconditions.checkState(this.type != RuleClassType.ABSTRACT, "Setting not inherited property (output to genrules) of abstract rule class '%s'", (Object)this.name);
            this.outputsToBindir = false;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setImplicitOutputsFunction(ImplicitOutputsFunction implicitOutputsFunction) {
            Preconditions.checkState(this.type != RuleClassType.ABSTRACT, "Setting not inherited property (implicit output function) of abstract rule class '%s'", (Object)this.name);
            this.implicitOutputsFunction = implicitOutputsFunction;
            return this;
        }

        public Builder cfg(PatchTransition transition) {
            return this.cfg((TransitionFactory<RuleTransitionData> & Serializable)unused -> transition);
        }

        @CanIgnoreReturnValue
        public Builder cfg(TransitionFactory<RuleTransitionData> transitionFactory) {
            Preconditions.checkState(this.type != RuleClassType.ABSTRACT, "Setting not inherited property (cfg) of abstract rule class '%s'", (Object)this.name);
            Preconditions.checkState(this.transitionFactory == null, "Property cfg has already been set");
            Preconditions.checkNotNull(transitionFactory);
            Preconditions.checkArgument(!transitionFactory.isSplit());
            this.transitionFactory = transitionFactory;
            return this;
        }

        public void setHasStarlarkRuleTransition() {
            this.hasStarlarkRuleTransition = true;
        }

        public boolean hasStarlarkRuleTransition() {
            return this.hasStarlarkRuleTransition;
        }

        @CanIgnoreReturnValue
        public Builder factory(ConfiguredTargetFactory<?, ?, ?> factory) {
            this.configuredTargetFactory = factory;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setValidityPredicate(PredicateWithMessage<Rule> predicate) {
            this.validityPredicate = predicate;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder advertiseProvider(Class<?> ... providers) {
            for (Class<?> provider : providers) {
                this.advertisedProviders.addBuiltin(provider);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder advertiseStarlarkProvider(StarlarkProviderIdentifier ... starlarkProviders) {
            for (StarlarkProviderIdentifier starlarkProviderIdentifier : starlarkProviders) {
                this.advertisedProviders.addStarlark(starlarkProviderIdentifier);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder canHaveAnyProvider() {
            this.advertisedProviders.canHaveAnyProvider();
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAttribute(Attribute attribute) {
            Attribute prevVal = this.attributes.putIfAbsent(attribute.getName(), attribute);
            if (prevVal != null) {
                throw new IllegalStateException(String.format("There is already a built-in attribute '%s' which cannot be overridden.", attribute.getName()));
            }
            return this;
        }

        private void overrideAttribute(Attribute attribute) {
            String attrName = attribute.getName();
            Preconditions.checkState(this.attributes.containsKey(attrName), "No such attribute '%s' to override in ruleclass '%s'.", (Object)attrName, (Object)this.name);
            Type<?> origType = this.attributes.get(attrName).getType();
            Type<?> newType = attribute.getType();
            Preconditions.checkState(origType.equals(newType), "The type of the new attribute '%s' is different from the original one '%s'.", newType, origType);
            this.attributes.put(attrName, attribute);
        }

        @CanIgnoreReturnValue
        public <TYPE> Builder add(Attribute.Builder<TYPE> attr) {
            this.addAttribute(attr.build());
            return this;
        }

        @CanIgnoreReturnValue
        public <TYPE> Builder override(Attribute.Builder<TYPE> attr) {
            this.overrideAttribute(attr.build());
            return this;
        }

        public boolean contains(String name) {
            return this.attributes.containsKey(name);
        }

        public ImmutableList<Attribute> getAttributes() {
            return ImmutableList.copyOf(this.attributes.values());
        }

        @CanIgnoreReturnValue
        public Builder setConfiguredTargetFunction(StarlarkCallable func) {
            this.configuredTargetFunction = func;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setBuildSetting(BuildSetting buildSetting) {
            this.buildSetting = buildSetting;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setExternalBindingsFunction(Function<? super Rule, Map<String, Label>> func) {
            this.externalBindingsFunction = func;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setToolchainsToRegisterFunction(Function<? super Rule, ? extends List<String>> func) {
            this.toolchainsToRegisterFunction = func;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setRuleDefinitionEnvironmentLabelAndDigest(Label label, byte[] digest) {
            this.ruleDefinitionEnvironmentLabel = Preconditions.checkNotNull(label, this.name);
            this.ruleDefinitionEnvironmentDigest = Preconditions.checkNotNull(digest, this.name);
            return this;
        }

        public Label getRuleDefinitionEnvironmentLabel() {
            return this.ruleDefinitionEnvironmentLabel;
        }

        @CanIgnoreReturnValue
        public Builder removeAttribute(String name) {
            Preconditions.checkState(this.attributes.containsKey(name), "No such attribute '%s' to remove.", (Object)name);
            this.attributes.remove(name);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setExecutableStarlark() {
            this.isExecutableStarlark = true;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setIsAnalysisTest() {
            this.isAnalysisTest = true;
            return this;
        }

        public boolean isAnalysisTest() {
            return this.isAnalysisTest;
        }

        @CanIgnoreReturnValue
        public Builder setHasAnalysisTestTransition() {
            this.hasAnalysisTestTransition = true;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllowlistChecker(AllowlistChecker allowlistChecker) {
            this.allowlistCheckers.add((Object)allowlistChecker);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setIgnoreLicenses() {
            this.ignoreLicenses = true;
            return this;
        }

        public RuleClassType getType() {
            return this.type;
        }

        @CanIgnoreReturnValue
        public Builder setOutputFileKind(OutputFile.Kind outputFileKind) {
            this.outputFileKind = Preconditions.checkNotNull(outputFileKind);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder compatibleWith(Label ... environments) {
            this.add(Attribute.attr(RuleClass.DEFAULT_COMPATIBLE_ENVIRONMENT_ATTR, BuildType.LABEL_LIST).value((Label)((Object)ImmutableList.copyOf(environments))));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder restrictedTo(Label firstEnvironment, Label ... otherEnvironments) {
            ImmutableCollection environments = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(firstEnvironment)).add(otherEnvironments)).build();
            this.add(Attribute.attr(RuleClass.DEFAULT_RESTRICTED_ENVIRONMENT_ATTR, BuildType.LABEL_LIST).value((Label)((Object)environments)));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder exemptFromConstraintChecking(String reason) {
            Preconditions.checkState(this.supportsConstraintChecking);
            this.supportsConstraintChecking = false;
            this.attributes.remove(RuleClass.COMPATIBLE_ENVIRONMENT_ATTR);
            this.attributes.remove(RuleClass.RESTRICTED_ENVIRONMENT_ATTR);
            this.attributes.remove(RuleClass.TARGET_COMPATIBLE_WITH_ATTR);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setOptionReferenceFunctionForConfigSettingOnly(Function<? super Rule, ? extends Set<String>> optionReferenceFunction) {
            this.optionReferenceFunction = Preconditions.checkNotNull(optionReferenceFunction);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addToolchainTypes(Iterable<ToolchainTypeRequirement> toolchainTypes) {
            Iterables.addAll(this.toolchainTypes, toolchainTypes);
            return this;
        }

        public Builder addToolchainTypes(ToolchainTypeRequirement ... toolchainTypes) {
            return this.addToolchainTypes(ImmutableList.copyOf(toolchainTypes));
        }

        @CanIgnoreReturnValue
        public Builder addExecGroups(Map<String, ExecGroup> execGroups) {
            for (Map.Entry<String, ExecGroup> group : execGroups.entrySet()) {
                String name = group.getKey();
                if (this.execGroups.containsKey(name)) {
                    ExecGroup newGroup;
                    ExecGroup existingGroup = this.execGroups.get(name);
                    if (existingGroup.equals(newGroup = group.getValue())) continue;
                    throw new DuplicateExecGroupError(name);
                }
                this.execGroups.put(name, group.getValue());
            }
            return this;
        }

        public Builder addExecGroup(String name) {
            return this.addExecGroups(ImmutableMap.of(name, ExecGroup.copyFromDefault()));
        }

        public boolean hasExecGroup(String name) {
            return this.execGroups.containsKey(name);
        }

        @CanIgnoreReturnValue
        public Builder useToolchainResolution(ToolchainResolutionMode mode) {
            this.useToolchainResolution = mode;
            return this;
        }

        public Builder addExecutionPlatformConstraints(Label ... constraints) {
            return this.addExecutionPlatformConstraints(Lists.newArrayList(constraints));
        }

        @CanIgnoreReturnValue
        public Builder addExecutionPlatformConstraints(Iterable<Label> constraints) {
            Iterables.addAll(this.executionPlatformConstraints, constraints);
            return this;
        }

        public Attribute.Builder<?> copy(String name) {
            Preconditions.checkArgument(this.attributes.containsKey(name), "Attribute %s does not exist in parent rule class.", (Object)name);
            return this.attributes.get(name).cloneBuilder();
        }

        static class DuplicateExecGroupError
        extends RuntimeException {
            private final String duplicateGroup;

            DuplicateExecGroupError(String duplicateGroup) {
                super(String.format("Multiple execution groups with the same name: '%s'.", duplicateGroup));
                this.duplicateGroup = duplicateGroup;
            }

            String getDuplicateGroup() {
                return this.duplicateGroup;
            }
        }

        @AutoCodec
        public static class RuleClassNamePredicate {
            private static final RuleClassNamePredicate UNSPECIFIED_INSTANCE = new RuleClassNamePredicate(ImmutableSet.of(), PredicateType.UNSPECIFIED, null);
            private final ImmutableSet<String> ruleClassNames;
            private final PredicateType predicateType;
            private final Predicate<String> ruleClassNamePredicate;
            private final Predicate<RuleClass> ruleClassPredicate;
            @Nullable
            private final Set<?> overlappable;

            @AutoCodec.VisibleForSerialization
            RuleClassNamePredicate(ImmutableSet<String> ruleClassNames, PredicateType predicateType, Set<?> overlappable) {
                this.ruleClassNames = ruleClassNames;
                this.predicateType = predicateType;
                this.overlappable = overlappable;
                switch (predicateType) {
                    case All_EXCEPT: {
                        Predicate<String> containing = RuleClassNamePredicate.only(ruleClassNames).asPredicateOfRuleClass();
                        this.ruleClassNamePredicate = new DescribedPredicate<String>(Predicates.not(containing), "all but " + containing);
                        this.ruleClassPredicate = new DescribedPredicate(Predicates.compose(this.ruleClassNamePredicate, RuleClass::getName), this.ruleClassNamePredicate.toString());
                        break;
                    }
                    case ONLY: {
                        this.ruleClassNamePredicate = new DescribedPredicate<String>(Predicates.in(ruleClassNames), StringUtil.joinEnglishList(ruleClassNames));
                        this.ruleClassPredicate = new DescribedPredicate(Predicates.compose(this.ruleClassNamePredicate, RuleClass::getName), this.ruleClassNamePredicate.toString());
                        break;
                    }
                    case UNSPECIFIED: {
                        this.ruleClassNamePredicate = Predicates.alwaysTrue();
                        this.ruleClassPredicate = Predicates.alwaysTrue();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Predicate type was not specified when constructing a RuleClassNamePredicate.");
                    }
                }
            }

            public static RuleClassNamePredicate only(Iterable<String> ruleClassNamesAsIterable) {
                ImmutableSet<String> ruleClassNames = ImmutableSet.copyOf(ruleClassNamesAsIterable);
                return new RuleClassNamePredicate(ruleClassNames, PredicateType.ONLY, ruleClassNames);
            }

            public static RuleClassNamePredicate only(String ... ruleClasses) {
                return RuleClassNamePredicate.only(Arrays.asList(ruleClasses));
            }

            public static RuleClassNamePredicate allExcept(String ... ruleClasses) {
                ImmutableSet<String> ruleClassNames = ImmutableSet.copyOf(ruleClasses);
                Preconditions.checkState(!ruleClassNames.isEmpty(), "Use unspecified() instead");
                return new RuleClassNamePredicate(ruleClassNames, PredicateType.All_EXCEPT, null);
            }

            public static RuleClassNamePredicate unspecified() {
                return UNSPECIFIED_INSTANCE;
            }

            final Predicate<String> asPredicateOfRuleClass() {
                return this.ruleClassNamePredicate;
            }

            final Predicate<RuleClass> asPredicateOfRuleClassObject() {
                return this.ruleClassPredicate;
            }

            boolean consideredOverlapping(RuleClassNamePredicate that) {
                return this.overlappable != null && that.overlappable != null && !Collections.disjoint(this.overlappable, that.overlappable);
            }

            public int hashCode() {
                return HashCodes.hashObjects(this.ruleClassNames, (Object)this.predicateType);
            }

            public boolean equals(Object obj) {
                return obj instanceof RuleClassNamePredicate && this.ruleClassNames.equals(((RuleClassNamePredicate)obj).ruleClassNames) && this.predicateType.equals((Object)((RuleClassNamePredicate)obj).predicateType);
            }

            public String toString() {
                return this.ruleClassNamePredicate.toString();
            }

            private static class DescribedPredicate<T>
            implements Predicate<T> {
                private final Predicate<T> delegate;
                private final String description;

                private DescribedPredicate(Predicate<T> delegate, String description) {
                    this.delegate = delegate;
                    this.description = description;
                }

                @Override
                public boolean apply(T input) {
                    return this.delegate.apply(input);
                }

                public int hashCode() {
                    return this.delegate.hashCode();
                }

                @Override
                public boolean equals(Object obj) {
                    return obj instanceof DescribedPredicate && this.delegate.equals(((DescribedPredicate)obj).delegate);
                }

                public String toString() {
                    return this.description;
                }
            }

            @AutoCodec.VisibleForSerialization
            static enum PredicateType {
                ONLY,
                All_EXCEPT,
                UNSPECIFIED;

            }
        }

        public static enum RuleClassType {
            ABSTRACT{

                @Override
                public void checkName(String name) {
                    Preconditions.checkArgument(name.contains("$") && !TargetUtils.isTestRuleName(name) || name.isEmpty());
                }

                @Override
                public void checkAttributes(Map<String, Attribute> attributes) {
                }
            }
            ,
            INVISIBLE{

                @Override
                public void checkName(String name) {
                    Preconditions.checkArgument(name.contains("$"));
                }

                @Override
                public void checkAttributes(Map<String, Attribute> attributes) {
                }
            }
            ,
            NORMAL{

                @Override
                public void checkName(String name) {
                    Preconditions.checkArgument(!TargetUtils.isTestRuleName(name) && RULE_NAME_PATTERN.matcher(name).matches(), "Invalid rule name: %s", (Object)name);
                }

                @Override
                public void checkAttributes(Map<String, Attribute> attributes) {
                    for (Attribute attribute : REQUIRED_ATTRIBUTES_FOR_NORMAL_RULES) {
                        Attribute presentAttribute = attributes.get(attribute.getName());
                        Preconditions.checkState(presentAttribute != null, "Missing mandatory '%s' attribute in normal rule class.", (Object)attribute.getName());
                        Preconditions.checkState(presentAttribute.getType().equals(attribute.getType()), "Mandatory attribute '%s' in normal rule class has incorrect type (expected %s).", (Object)attribute.getName(), attribute.getType());
                    }
                }
            }
            ,
            WORKSPACE{

                @Override
                public void checkName(String name) {
                    Preconditions.checkArgument(RULE_NAME_PATTERN.matcher(name).matches());
                }

                @Override
                public void checkAttributes(Map<String, Attribute> attributes) {
                }
            }
            ,
            TEST{

                @Override
                public void checkName(String name) {
                    Preconditions.checkArgument(TargetUtils.isTestRuleName(name) && RULE_NAME_PATTERN.matcher(name).matches());
                }

                @Override
                public void checkAttributes(Map<String, Attribute> attributes) {
                    for (Attribute attribute : REQUIRED_ATTRIBUTES_FOR_TESTS) {
                        Attribute presentAttribute = attributes.get(attribute.getName());
                        Preconditions.checkState(presentAttribute != null, "Missing mandatory '%s' attribute in test rule class.", (Object)attribute.getName());
                        Preconditions.checkState(presentAttribute.getType().equals(attribute.getType()), "Mandatory attribute '%s' in test rule class has incorrect type (expected %s).", (Object)attribute.getName(), attribute.getType());
                    }
                }
            }
            ,
            PLACEHOLDER{

                @Override
                public void checkName(String name) {
                    Preconditions.checkArgument(RULE_NAME_PATTERN.matcher(name).matches(), name);
                }

                @Override
                public void checkAttributes(Map<String, Attribute> attributes) {
                }
            };


            public abstract void checkName(String var1);

            protected abstract void checkAttributes(Map<String, Attribute> var1);
        }
    }

    public static interface ConfiguredTargetFactory<TConfiguredTarget, TContext, TActionConflictException extends Throwable> {
        @Nullable
        public TConfiguredTarget create(TContext var1) throws InterruptedException, RuleErrorException, TActionConflictException;

        public static final class RuleErrorException
        extends Exception {
            public RuleErrorException() {
            }

            public RuleErrorException(String message) {
                super(message);
            }

            public RuleErrorException(Throwable cause) {
                super(cause);
            }

            public RuleErrorException(String message, Throwable cause) {
                super(message, cause);
            }
        }
    }

    public static enum ToolchainResolutionMode {
        ENABLED,
        DISABLED,
        ENABLED_ONLY_FOR_COMMON_LOGIC,
        INHERIT;


        ToolchainResolutionMode apply(String name, ToolchainResolutionMode parent) {
            if (this == INHERIT) {
                return parent;
            }
            if (parent == INHERIT) {
                return this;
            }
            if (this != parent) {
                throw new IllegalArgumentException(String.format("Rule %s has useToolchainResolution set to %s, but the parent is trying to set it to %s", new Object[]{name, this, parent}));
            }
            return this;
        }

        boolean isActive() {
            switch (this) {
                case ENABLED: {
                    return true;
                }
                case DISABLED: 
                case ENABLED_ONLY_FOR_COMMON_LOGIC: {
                    return false;
                }
            }
            return true;
        }
    }

    public static class PackageNameConstraint
    implements PredicateWithMessage<Rule> {
        public static final int ANY_SEGMENT = 0;
        private final int pathSegment;
        private final Set<String> values;

        public PackageNameConstraint(int pathSegment, String ... values) {
            this.values = ImmutableSet.copyOf(values);
            this.pathSegment = pathSegment;
        }

        @Override
        public boolean apply(Rule input) {
            PathFragment path = input.getLabel().getPackageFragment();
            if (this.pathSegment == 0) {
                return Streams.stream(path.segments()).anyMatch(this.values::contains);
            }
            return path.segmentCount() >= this.pathSegment && this.values.contains(path.getSegment(this.pathSegment - 1));
        }

        @Override
        public String getErrorReason(Rule param) {
            if (this.pathSegment == 0) {
                return param.getRuleClass() + " rules have to be under a " + StringUtil.joinEnglishList(this.values, "or", "'") + " directory";
            }
            if (this.pathSegment == 1) {
                return param.getRuleClass() + " rules are only allowed in " + StringUtil.joinEnglishList(Iterables.transform(this.values, s2 -> "//" + s2), "or");
            }
            return param.getRuleClass() + " rules are only allowed in packages which " + StringUtil.ordinal(this.pathSegment) + " is " + StringUtil.joinEnglishList(this.values, "or");
        }

        @VisibleForTesting
        public int getPathSegment() {
            return this.pathSegment;
        }

        @VisibleForTesting
        public Collection<String> getValues() {
            return this.values;
        }
    }
}

