/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.cmdline.LabelSyntaxException;
import com.google.devtools.build.lib.cmdline.PackageIdentifier;
import com.google.devtools.build.lib.cmdline.RepositoryName;
import com.google.devtools.build.lib.events.Event;
import com.google.devtools.build.lib.events.EventHandler;
import com.google.devtools.build.lib.events.NullEventHandler;
import com.google.devtools.build.lib.packages.AbstractAttributeMapper;
import com.google.devtools.build.lib.packages.AggregatingAttributeMapper;
import com.google.devtools.build.lib.packages.Aspect;
import com.google.devtools.build.lib.packages.AspectDefinition;
import com.google.devtools.build.lib.packages.Attribute;
import com.google.devtools.build.lib.packages.AttributeMap;
import com.google.devtools.build.lib.packages.BuildType;
import com.google.devtools.build.lib.packages.CallStack;
import com.google.devtools.build.lib.packages.DependencyFilter;
import com.google.devtools.build.lib.packages.ImplicitOutputsFunction;
import com.google.devtools.build.lib.packages.License;
import com.google.devtools.build.lib.packages.NonconfigurableAttributeMapper;
import com.google.devtools.build.lib.packages.OutputFile;
import com.google.devtools.build.lib.packages.Package;
import com.google.devtools.build.lib.packages.PackageSpecification;
import com.google.devtools.build.lib.packages.PredicateWithMessage;
import com.google.devtools.build.lib.packages.RawAttributeMapper;
import com.google.devtools.build.lib.packages.RuleClass;
import com.google.devtools.build.lib.packages.RuleVisibility;
import com.google.devtools.build.lib.packages.Target;
import com.google.devtools.build.lib.packages.Type;
import com.google.devtools.build.lib.server.FailureDetails;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.syntax.Location;

public class Rule
implements Target,
DependencyFilter.AttributeInfoProvider {
    public static final Predicate<Label> ALL_LABELS = Predicates.alwaysTrue();
    private static final String NAME = RuleClass.NAME_ATTRIBUTE.getName();
    private static final String GENERATOR_FUNCTION = "generator_function";
    private static final String GENERATOR_LOCATION = "generator_location";
    private static final String GENERATOR_NAME = "generator_name";
    private static final int ATTR_SIZE_THRESHOLD = 126;
    private static final OutputFile[] NO_OUTPUTS = new OutputFile[0];
    private final Package pkg;
    private final Label label;
    private final RuleClass ruleClass;
    private final Location location;
    @Nullable
    private final CallStack.Node interiorCallStack;
    private int generatorNamePrefixLength = 0;
    private Object[] attrValues;
    private byte[] attrBytes;
    private Object outputFiles;

    Rule(Package pkg, Label label, RuleClass ruleClass, Location location, @Nullable CallStack.Node interiorCallStack) {
        this.pkg = Preconditions.checkNotNull(pkg);
        this.label = Preconditions.checkNotNull(label);
        this.ruleClass = Preconditions.checkNotNull(ruleClass);
        this.location = Preconditions.checkNotNull(location);
        this.interiorCallStack = interiorCallStack;
        this.attrValues = new Object[ruleClass.getAttributeCount()];
        this.attrBytes = new byte[this.bitSetSize()];
    }

    void setContainsErrors() {
        this.pkg.setContainsErrors();
    }

    @Override
    public Label getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.label.getName();
    }

    @Override
    public Package getPackage() {
        return this.pkg;
    }

    public RuleClass getRuleClassObject() {
        return this.ruleClass;
    }

    @Override
    public String getTargetKind() {
        return this.ruleClass.getTargetKind();
    }

    @Override
    public String getRuleClass() {
        return this.ruleClass.getName();
    }

    public boolean outputsToBindir() {
        return this.ruleClass.getName().equals("genrule") ? NonconfigurableAttributeMapper.of(this).get("output_to_bindir", Type.BOOLEAN).booleanValue() : this.ruleClass.outputsToBindir();
    }

    public boolean isAnalysisTest() {
        return this.ruleClass.isAnalysisTest();
    }

    public boolean hasAnalysisTestTransition() {
        return this.ruleClass.hasAnalysisTestTransition();
    }

    public boolean isBuildSetting() {
        return this.ruleClass.getBuildSetting() != null;
    }

    public boolean containsErrors() {
        return this.pkg.containsErrors();
    }

    public boolean hasAspects() {
        return this.ruleClass.hasAspects();
    }

    public Collection<Attribute> getAttributes() {
        return this.ruleClass.getAttributes();
    }

    public boolean isConfigurableAttribute(String attributeName) {
        Attribute attribute = this.ruleClass.getAttributeByNameMaybe(attributeName);
        return attribute != null && AbstractAttributeMapper.isConfigurable(this, attributeName, attribute.getType());
    }

    @Deprecated
    public Attribute getAttributeDefinition(String attrName) {
        return this.ruleClass.getAttributeByNameMaybe(attrName);
    }

    public ImmutableList<OutputFile> getOutputFiles() {
        return ImmutableList.copyOf(this.outputFilesArray());
    }

    ImmutableList<OutputFile> getImplicitOutputFiles() {
        ImmutableList.Builder result = ImmutableList.builder();
        for (OutputFile output : this.outputFilesArray()) {
            if (!output.isImplicit()) break;
            result.add(output);
        }
        return result.build();
    }

    public ImmutableListMultimap<String, OutputFile> getExplicitOutputFileMap() {
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        for (OutputFile output : this.outputFilesArray()) {
            if (output.isImplicit()) continue;
            result.put(output.getOutputKey(), output);
        }
        return result.build();
    }

    public ImmutableMap<String, OutputFile> getStarlarkImplicitOutputFileMap() {
        if (!(this.ruleClass.getDefaultImplicitOutputsFunction() instanceof ImplicitOutputsFunction.StarlarkImplicitOutputsFunction)) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder<String, OutputFile> result = ImmutableMap.builder();
        for (OutputFile output : this.outputFilesArray()) {
            if (!output.isImplicit()) break;
            result.put(output.getOutputKey(), output);
        }
        return result.buildOrThrow();
    }

    private OutputFile[] outputFilesArray() {
        OutputFile[] outputFileArray;
        if (this.outputFiles instanceof OutputFile) {
            OutputFile[] outputFileArray2 = new OutputFile[1];
            outputFileArray = outputFileArray2;
            outputFileArray2[0] = (OutputFile)this.outputFiles;
        } else {
            outputFileArray = (OutputFile[])this.outputFiles;
        }
        return outputFileArray;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public ImmutableList<StarlarkThread.CallStackEntry> reconstructCallStack() {
        ImmutableList.Builder stack = ImmutableList.builder();
        stack.add(StarlarkThread.callStackEntry("<toplevel>", this.location));
        for (CallStack.Node node = this.interiorCallStack; node != null; node = node.next()) {
            stack.add(node.toCallStackEntry());
        }
        return stack.build();
    }

    @Nullable
    CallStack.Node getInteriorCallStack() {
        return this.interiorCallStack;
    }

    @Override
    public Rule getAssociatedRule() {
        return this;
    }

    public Object getAttrDefaultValue(String attrName) {
        Object defaultValue = this.ruleClass.getAttributeByName(attrName).getDefaultValue();
        Preconditions.checkState(!(defaultValue instanceof Attribute.ComputedDefault));
        return defaultValue;
    }

    public boolean isAttrDefined(String attrName, Type<?> type) {
        return this.ruleClass.hasAttr(attrName, type);
    }

    @Nullable
    private String getRelativeLocation() {
        String absolutePath = this.location.toString();
        int pos = absolutePath.indexOf(this.label.getPackageName());
        return pos < 0 ? null : absolutePath.substring(pos);
    }

    void copyAttributesFrom(Rule rule) {
        Preconditions.checkArgument(this.ruleClass.equals(rule.ruleClass), "Rule class mismatch: (this=%s, given=%s)", (Object)this.ruleClass, (Object)rule.ruleClass);
        Preconditions.checkArgument(rule.isFrozen(), "Not frozen: %s", (Object)rule);
        Preconditions.checkState(!this.isFrozen(), "Already frozen: %s", (Object)this);
        this.attrValues = rule.attrValues;
        this.attrBytes = rule.attrBytes;
    }

    void setAttributeValue(Attribute attribute, Object value, boolean explicit) {
        Integer attrIndex;
        Preconditions.checkState(!this.isFrozen(), "Already frozen: %s", (Object)this);
        String attrName = attribute.getName();
        if (attrName.equals(NAME)) {
            return;
        }
        if (attrName.equals(GENERATOR_NAME)) {
            String generatorName = (String)value;
            if (this.getName().startsWith(generatorName)) {
                this.generatorNamePrefixLength = generatorName.length();
                return;
            }
        }
        Preconditions.checkArgument((attrIndex = this.ruleClass.getAttributeIndex(attrName)) != null, "Attribute %s is not valid for this rule", (Object)attrName);
        if (explicit) {
            Preconditions.checkState(!this.getExplicitBit(attrIndex), "Attribute %s already explicitly set", (Object)attrName);
            this.setExplicitBit(attrIndex);
        }
        this.attrValues[attrIndex.intValue()] = value;
    }

    @Nullable
    public Object getAttr(String attrName) {
        if (attrName.equals(NAME)) {
            return this.getName();
        }
        Integer attrIndex = this.ruleClass.getAttributeIndex(attrName);
        return attrIndex == null ? null : this.getAttrWithIndex(attrIndex);
    }

    @Nullable
    public <T> Object getAttr(String attrName, Type<T> type) {
        if (attrName.equals(NAME)) {
            this.checkAttrType(attrName, type, RuleClass.NAME_ATTRIBUTE);
            return this.getName();
        }
        Integer index = this.ruleClass.getAttributeIndex(attrName);
        if (index == null) {
            throw new IllegalArgumentException("No such attribute " + attrName + " in " + this.ruleClass + " rule " + this.label);
        }
        this.checkAttrType(attrName, type, this.ruleClass.getAttribute(index));
        return this.getAttrWithIndex(index);
    }

    @Nullable
    private Object getAttrWithIndex(int attrIndex) {
        Object value = this.getAttrIfStored(attrIndex);
        if (value != null) {
            return value;
        }
        Attribute attr = this.ruleClass.getAttribute(attrIndex);
        if (attr.hasComputedDefault()) {
            return this.isFrozen() ? attr.getDefaultValue() : null;
        }
        if (attr.isLateBound()) {
            Preconditions.checkState(this.isFrozen(), "Mutable rule missing LateBoundDefault");
            return attr.getLateBoundDefault();
        }
        switch (attr.getName()) {
            case "generator_function": {
                return this.interiorCallStack != null ? this.interiorCallStack.functionName() : "";
            }
            case "generator_location": {
                return this.interiorCallStack != null ? this.getRelativeLocation() : "";
            }
            case "generator_name": {
                return this.generatorNamePrefixLength > 0 ? this.getName().substring(0, this.generatorNamePrefixLength) : "";
            }
        }
        return attr.getDefaultValue();
    }

    @Nullable
    Object getAttrIfStored(int attrIndex) {
        Preconditions.checkPositionIndex(attrIndex, this.attrCount() - 1);
        switch (this.getAttrState()) {
            case MUTABLE: {
                return this.attrValues[attrIndex];
            }
            case FROZEN_SMALL: {
                int index = this.binarySearchAttrBytes(0, attrIndex, 127);
                return index < 0 ? null : this.attrValues[index];
            }
            case FROZEN_LARGE: {
                if (this.attrBytes.length == 0) {
                    return null;
                }
                int bitSetSize = this.bitSetSize();
                int index = this.binarySearchAttrBytes(bitSetSize, attrIndex, 255);
                return index < 0 ? null : this.attrValues[index - bitSetSize];
            }
        }
        throw new AssertionError();
    }

    Iterable<Object> getRawAttrValues() {
        return () -> Iterators.forArray(this.attrValues);
    }

    @Override
    public boolean isAttributeValueExplicitlySpecified(Attribute attribute) {
        return this.isAttributeValueExplicitlySpecified(attribute.getName());
    }

    public boolean isAttributeValueExplicitlySpecified(String attrName) {
        if (attrName.equals(NAME)) {
            return true;
        }
        if (attrName.equals(GENERATOR_FUNCTION) || attrName.equals(GENERATOR_LOCATION) || attrName.equals(GENERATOR_NAME)) {
            return this.wasCreatedByMacro();
        }
        Integer attrIndex = this.ruleClass.getAttributeIndex(attrName);
        if (attrIndex == null) {
            return false;
        }
        switch (this.getAttrState()) {
            case MUTABLE: 
            case FROZEN_LARGE: {
                return this.getExplicitBit(attrIndex);
            }
            case FROZEN_SMALL: {
                int index = this.binarySearchAttrBytes(0, attrIndex, 127);
                return index >= 0 && (this.attrBytes[index] & 0x80) != 0;
            }
        }
        throw new AssertionError();
    }

    private int binarySearchAttrBytes(int start, int attrIndex, int mask) {
        int lo = start;
        int hi = this.attrBytes.length - 1;
        while (hi >= lo) {
            int mid = (lo + hi) / 2;
            int midAttrIndex = this.attrBytes[mid] & mask;
            if (midAttrIndex == attrIndex) {
                return mid;
            }
            if (midAttrIndex < attrIndex) {
                lo = mid + 1;
                continue;
            }
            hi = mid - 1;
        }
        return -1;
    }

    private void checkAttrType(String attrName, Type<?> requestedType, Attribute attr) {
        if (requestedType != attr.getType()) {
            throw new IllegalArgumentException("Attribute " + attrName + " is of type " + attr.getType() + " and not of type " + requestedType + " in " + this.ruleClass + " rule " + this.label);
        }
    }

    boolean isFrozen() {
        return this.getAttrState() != AttrState.MUTABLE;
    }

    void freeze() {
        if (this.isFrozen()) {
            return;
        }
        BitSet indicesToStore = new BitSet();
        for (int i = 0; i < this.attrValues.length; ++i) {
            Attribute attr;
            Object value = this.attrValues[i];
            if (value == null || !this.getExplicitBit(i) && value.equals((attr = this.ruleClass.getAttribute(i)).getDefaultValueUnchecked())) continue;
            indicesToStore.set(i);
        }
        if (this.attrCount() < 126) {
            this.freezeSmall(indicesToStore);
        } else {
            this.freezeLarge(indicesToStore);
        }
        Preconditions.checkState(this.isFrozen(), "Freeze unsuccessful");
    }

    private void freezeSmall(BitSet indicesToStore) {
        int numToStore = indicesToStore.cardinality();
        Object[] compactValues = new Object[numToStore];
        byte[] compactBytes = new byte[numToStore];
        int attrIndex = 0;
        for (int i = 0; i < numToStore; ++i) {
            attrIndex = indicesToStore.nextSetBit(attrIndex);
            byte byteValue = (byte)(0x7F & attrIndex);
            if (this.getExplicitBit(attrIndex)) {
                byteValue = (byte)(byteValue | 0x80);
            }
            compactBytes[i] = byteValue;
            compactValues[i] = this.attrValues[attrIndex];
            ++attrIndex;
        }
        this.attrValues = compactValues;
        this.attrBytes = compactBytes;
    }

    private void freezeLarge(BitSet indicesToStore) {
        int numToStore = indicesToStore.cardinality();
        int bitSetSize = this.attrBytes.length;
        Object[] compactValues = new Object[numToStore];
        byte[] compactBytes = Arrays.copyOf(this.attrBytes, bitSetSize + numToStore);
        int attrIndex = 0;
        for (int i = 0; i < numToStore; ++i) {
            attrIndex = indicesToStore.nextSetBit(attrIndex);
            compactBytes[i + bitSetSize] = (byte)attrIndex;
            compactValues[i] = this.attrValues[attrIndex];
            ++attrIndex;
        }
        this.attrValues = compactValues;
        this.attrBytes = compactBytes;
    }

    private int attrCount() {
        return this.ruleClass.getAttributeCount();
    }

    private AttrState getAttrState() {
        int attrCount = this.attrCount();
        if (this.attrValues.length == attrCount) {
            return AttrState.MUTABLE;
        }
        return attrCount < 126 ? AttrState.FROZEN_SMALL : AttrState.FROZEN_LARGE;
    }

    private int bitSetSize() {
        return (this.attrCount() + 7) / 8;
    }

    private boolean getExplicitBit(int attrIndex) {
        int byteIndex = attrIndex / 8;
        byte byteValue = this.attrBytes[byteIndex];
        int bitIndex = attrIndex % 8;
        return (byteValue & 1 << bitIndex) != 0;
    }

    private void setExplicitBit(int attrIndex) {
        int byteIndex = attrIndex / 8;
        int bitIndex = attrIndex % 8;
        byte byteValue = this.attrBytes[byteIndex];
        this.attrBytes[byteIndex] = (byte)(byteValue | 1 << bitIndex);
    }

    @Nullable
    public <T> BuildType.SelectorList<T> getSelectorList(String attributeName, Type<T> type) {
        Integer index = this.ruleClass.getAttributeIndex(attributeName);
        if (index == null) {
            return null;
        }
        Object attrValue = this.getAttrIfStored(index);
        if (!(attrValue instanceof BuildType.SelectorList)) {
            return null;
        }
        if (((BuildType.SelectorList)attrValue).getOriginalType() != type) {
            throw new IllegalArgumentException("Attribute " + attributeName + " is not of type " + type + " in " + this.ruleClass + " rule " + this.label);
        }
        return (BuildType.SelectorList)attrValue;
    }

    public boolean wasCreatedByMacro() {
        return this.interiorCallStack != null || this.hasStringAttribute(GENERATOR_NAME);
    }

    public String getGeneratorFunction() {
        Object value = this.getAttr(GENERATOR_FUNCTION);
        if (value instanceof String) {
            return (String)value;
        }
        return "";
    }

    private boolean hasStringAttribute(String attrName) {
        Object value = this.getAttr(attrName);
        if (value instanceof String) {
            return !((String)value).isEmpty();
        }
        return false;
    }

    public List<Label> getLabels() {
        ArrayList<Label> labels = new ArrayList<Label>();
        AggregatingAttributeMapper.of(this).visitAllLabels((attribute, label) -> labels.add((Label)label));
        return labels;
    }

    public ImmutableSortedSet<Label> getSortedLabels(DependencyFilter filter) {
        ImmutableSortedSet.Builder labels = ImmutableSortedSet.naturalOrder();
        AggregatingAttributeMapper.of(this).visitLabels(filter, (attribute, label) -> labels.add(label));
        return labels.build();
    }

    public SetMultimap<Attribute, Label> getTransitions(DependencyFilter filter) {
        HashMultimap<Attribute, Label> transitions = HashMultimap.create();
        AggregatingAttributeMapper.of(this).visitLabels(filter, transitions::put);
        return transitions;
    }

    void checkValidityPredicate(EventHandler eventHandler) {
        PredicateWithMessage<Rule> predicate = this.ruleClass.getValidityPredicate();
        if (!predicate.apply(this)) {
            this.reportError(predicate.getErrorReason(this), eventHandler);
        }
    }

    void populateOutputFiles(EventHandler eventHandler, Package.Builder pkgBuilder) throws LabelSyntaxException, InterruptedException {
        this.populateOutputFilesInternal(eventHandler, pkgBuilder.getPackageIdentifier(), this.ruleClass.getDefaultImplicitOutputsFunction(), true);
    }

    void populateOutputFilesUnchecked(Package.Builder pkgBuilder, ImplicitOutputsFunction implicitOutputsFunction) throws InterruptedException {
        try {
            this.populateOutputFilesInternal(NullEventHandler.INSTANCE, pkgBuilder.getPackageIdentifier(), implicitOutputsFunction, false);
        }
        catch (LabelSyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    private void populateOutputFilesInternal(EventHandler eventHandler, PackageIdentifier pkgId, ImplicitOutputsFunction implicitOutputsFunction, boolean checkLabels) throws LabelSyntaxException, InterruptedException {
        Preconditions.checkState(this.outputFiles == null);
        ArrayList outputs = new ArrayList();
        HashSet implicitOutputKeys = new HashSet();
        ImplicitOutputHandler implicitOutputHandler = (outputKey, outputName) -> {
            Label label;
            if (checkLabels) {
                try {
                    label = Label.create(pkgId, outputName);
                }
                catch (LabelSyntaxException e) {
                    this.reportError(String.format("illegal output file name '%s' in rule %s due to: %s", outputName, this.label, e.getMessage()), eventHandler);
                    return;
                }
            } else {
                label = Label.createUnvalidated(pkgId, outputName);
            }
            this.validateOutputLabel(label, eventHandler);
            outputs.add(OutputFile.createImplicit(label, this, outputKey));
            implicitOutputKeys.add(outputKey);
        };
        try {
            RawAttributeMapper attributeMap = RawAttributeMapper.of(this);
            if (implicitOutputsFunction instanceof ImplicitOutputsFunction.StarlarkImplicitOutputsFunction) {
                for (Map.Entry e : ((ImplicitOutputsFunction.StarlarkImplicitOutputsFunction)implicitOutputsFunction).calculateOutputs(eventHandler, attributeMap).entrySet()) {
                    implicitOutputHandler.accept((String)e.getKey(), (String)e.getValue());
                }
            } else {
                for (String out : implicitOutputsFunction.getImplicitOutputs(eventHandler, attributeMap)) {
                    implicitOutputHandler.accept("", out);
                }
            }
        }
        catch (EvalException e) {
            this.reportError(String.format("In rule %s: %s", this.label, e.getMessageWithStack()), eventHandler);
        }
        ExplicitOutputHandler explicitOutputHandler = (attribute, outputLabel) -> {
            String attrName = attribute.getName();
            if (implicitOutputKeys.contains(attrName)) {
                this.reportError(String.format("Implicit output key '%s' collides with output attribute name", attrName), eventHandler);
            }
            if (checkLabels) {
                if (!outputLabel.getPackageIdentifier().equals(this.pkg.getPackageIdentifier())) {
                    throw new IllegalStateException(String.format("Label for attribute %s should refer to '%s' but instead refers to '%s' (label '%s')", attribute, this.pkg.getName(), outputLabel.getPackageFragment(), outputLabel.getName()));
                }
                if (outputLabel.getName().equals(".")) {
                    throw new LabelSyntaxException("output file name can't be equal '.'");
                }
            }
            this.validateOutputLabel(outputLabel, eventHandler);
            outputs.add(OutputFile.createExplicit(outputLabel, this, attrName));
        };
        NonconfigurableAttributeMapper nonConfigurableAttributes = NonconfigurableAttributeMapper.of(this);
        for (Attribute attribute2 : this.ruleClass.getAttributes()) {
            String name = attribute2.getName();
            Type<?> type = attribute2.getType();
            if (type == BuildType.OUTPUT) {
                Label label = nonConfigurableAttributes.get(name, BuildType.OUTPUT);
                if (label == null) continue;
                explicitOutputHandler.accept(attribute2, label);
                continue;
            }
            if (type != BuildType.OUTPUT_LIST) continue;
            for (Label label : (List)((Object)nonConfigurableAttributes.get(name, BuildType.OUTPUT_LIST))) {
                explicitOutputHandler.accept(attribute2, label);
            }
        }
        this.outputFiles = outputs.isEmpty() ? NO_OUTPUTS : (outputs.size() == 1 ? outputs.get(0) : outputs.toArray(OutputFile[]::new));
    }

    private void validateOutputLabel(Label label, EventHandler eventHandler) {
        if (label.getName().equals(this.getName())) {
            this.reportWarning("target '" + this.getName() + "' is both a rule and a file; please choose another name for the rule", eventHandler);
        }
    }

    void reportError(String message, EventHandler eventHandler) {
        eventHandler.handle(Package.error(this.location, message, FailureDetails.PackageLoading.Code.STARLARK_EVAL_ERROR));
        this.setContainsErrors();
    }

    private void reportWarning(String message, EventHandler eventHandler) {
        eventHandler.handle(Event.warn(this.location, message));
    }

    public String toString() {
        return this.getRuleClass() + " rule " + this.label;
    }

    @Override
    public RuleVisibility getVisibility() {
        List<Label> rawLabels = this.getRawVisibilityLabels();
        return rawLabels == null ? this.getDefaultVisibility() : RuleVisibility.parseUnchecked(rawLabels);
    }

    @Override
    public Iterable<Label> getVisibilityDependencyLabels() {
        List<Label> rawLabels = this.getRawVisibilityLabels();
        if (rawLabels == null) {
            return this.getDefaultVisibility().getDependencyLabels();
        }
        RuleVisibility constantVisibility = RuleVisibility.parseIfConstant(rawLabels);
        if (constantVisibility != null) {
            return constantVisibility.getDependencyLabels();
        }
        return Iterables.filter(rawLabels, label -> PackageSpecification.fromLabel(label) == null);
    }

    @Override
    public List<Label> getVisibilityDeclaredLabels() {
        List<Label> rawLabels = this.getRawVisibilityLabels();
        return rawLabels == null ? this.getDefaultVisibility().getDeclaredLabels() : rawLabels;
    }

    public boolean isVisibilitySpecified() {
        return this.ruleClass.getName().equals("bind") || this.isAttributeValueExplicitlySpecified("visibility");
    }

    @Nullable
    private List<Label> getRawVisibilityLabels() {
        Integer visibilityIndex = this.ruleClass.getAttributeIndex("visibility");
        if (visibilityIndex == null) {
            return null;
        }
        return (List)this.getAttrIfStored(visibilityIndex);
    }

    private RuleVisibility getDefaultVisibility() {
        if (this.ruleClass.getName().equals("bind")) {
            return RuleVisibility.PUBLIC;
        }
        if (this.ruleClass.getName().equals("config_setting") && this.pkg.getConfigSettingVisibilityPolicy() == Package.ConfigSettingVisibilityPolicy.DEFAULT_PUBLIC) {
            return RuleVisibility.PUBLIC;
        }
        return this.pkg.getDefaultVisibility();
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public Set<License.DistributionType> getDistributions() {
        if (this.isAttrDefined("distribs", BuildType.DISTRIBUTIONS) && this.isAttributeValueExplicitlySpecified("distribs")) {
            return NonconfigurableAttributeMapper.of(this).get("distribs", BuildType.DISTRIBUTIONS);
        }
        return this.pkg.getDefaultDistribs();
    }

    @Override
    public License getLicense() {
        if (this.ruleClass.isPackageMetadataRule()) {
            return License.NO_LICENSE;
        }
        if (this.isAttrDefined("licenses", BuildType.LICENSE) && this.isAttributeValueExplicitlySpecified("licenses")) {
            return NonconfigurableAttributeMapper.of(this).get("licenses", BuildType.LICENSE);
        }
        if (this.ruleClass.ignoreLicenses()) {
            return License.NO_LICENSE;
        }
        return this.pkg.getDefaultLicense();
    }

    @Nullable
    public License getToolOutputLicense(AttributeMap attributes) {
        if (this.isAttrDefined("output_licenses", BuildType.LICENSE) && attributes.isAttributeValueExplicitlySpecified("output_licenses")) {
            return attributes.get("output_licenses", BuildType.LICENSE);
        }
        return null;
    }

    @Override
    public Set<String> getRuleTags() {
        LinkedHashSet<String> ruleTags = new LinkedHashSet<String>();
        for (Attribute attribute : this.ruleClass.getAttributes()) {
            if (!attribute.isTaggable()) continue;
            Type<?> attrType = attribute.getType();
            String name = attribute.getName();
            Object value = NonconfigurableAttributeMapper.of(this).get(name, attrType);
            Set<String> tags = attrType.toTagSet(value, name);
            ruleTags.addAll(tags);
        }
        return ruleTags;
    }

    public Collection<Label> getAspectLabelsSuperset(DependencyFilter predicate) {
        if (!this.hasAspects()) {
            return ImmutableList.of();
        }
        LinkedHashMultimap<Attribute, Label> labels = LinkedHashMultimap.create();
        for (Attribute attribute : this.getAttributes()) {
            for (Aspect candidateClass : attribute.getAspects(this)) {
                AspectDefinition.addAllAttributesOfAspect(labels, candidateClass, predicate);
            }
        }
        return labels.values();
    }

    public boolean useToolchainResolution() {
        RuleClass.ToolchainResolutionMode mode = this.ruleClass.useToolchainResolution();
        if (mode.isActive()) {
            return true;
        }
        if (mode == RuleClass.ToolchainResolutionMode.ENABLED_ONLY_FOR_COMMON_LOGIC) {
            RawAttributeMapper attr = RawAttributeMapper.of(this);
            return attr.has("$config_dependencies") && !((List)((Object)attr.get("$config_dependencies", BuildType.LABEL_LIST))).isEmpty() || attr.has("target_compatible_with") && !((List)((Object)attr.get("target_compatible_with", BuildType.LABEL_LIST))).isEmpty();
        }
        return false;
    }

    public RepositoryName getRepository() {
        return this.label.getPackageIdentifier().getRepository();
    }

    public static String targetKindSuffix() {
        return " rule";
    }

    @FunctionalInterface
    private static interface ImplicitOutputHandler {
        public void accept(String var1, String var2);
    }

    @FunctionalInterface
    private static interface ExplicitOutputHandler {
        public void accept(Attribute var1, Label var2) throws LabelSyntaxException;
    }

    private static enum AttrState {
        MUTABLE,
        FROZEN_SMALL,
        FROZEN_LARGE;

    }
}

