/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.build.lib.analysis.TransitiveInfoProvider;
import com.google.devtools.build.lib.packages.AdvertisedProviderSet;
import com.google.devtools.build.lib.packages.AspectDefinition;
import com.google.devtools.build.lib.packages.StarlarkProviderIdentifier;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.AutoCodec;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class RequiredProviders {
    private final Constraint constraint;
    private final ImmutableList<ImmutableSet<Class<? extends TransitiveInfoProvider>>> builtinProviders;
    private final ImmutableList<ImmutableSet<StarlarkProviderIdentifier>> starlarkProviders;

    public String getDescription() {
        return this.constraint.getDescription(this);
    }

    public String toString() {
        return this.getDescription();
    }

    public ImmutableList<ImmutableSet<StarlarkProviderIdentifier>> getStarlarkProviders() {
        return this.starlarkProviders;
    }

    public boolean isSatisfiedBy(AdvertisedProviderSet advertisedProviderSet) {
        return this.constraint.satisfies(advertisedProviderSet, this, null);
    }

    public boolean isSatisfiedBy(Predicate<Class<? extends TransitiveInfoProvider>> hasBuiltinProvider, Predicate<StarlarkProviderIdentifier> hasStarlarkProvider) {
        return this.constraint.satisfies(hasBuiltinProvider, hasStarlarkProvider, this, null);
    }

    public RequiredProviders getMissing(Predicate<Class<? extends TransitiveInfoProvider>> hasBuiltinProvider, Predicate<StarlarkProviderIdentifier> hasStarlarkProvider) {
        Builder builder = RequiredProviders.acceptAnyBuilder();
        if (this.constraint.satisfies(hasBuiltinProvider, hasStarlarkProvider, this, builder)) {
            return RequiredProviders.acceptAnyBuilder().build();
        }
        return builder.build();
    }

    public RequiredProviders getMissing(AdvertisedProviderSet set) {
        Builder builder = RequiredProviders.acceptAnyBuilder();
        if (this.constraint.satisfies(set, this, builder)) {
            return RequiredProviders.acceptAnyBuilder().build();
        }
        return builder.build();
    }

    public boolean acceptsAny() {
        return this.constraint.equals((Object)Constraint.ANY);
    }

    @AutoCodec.VisibleForSerialization
    RequiredProviders(Constraint constraint, ImmutableList<ImmutableSet<Class<? extends TransitiveInfoProvider>>> builtinProviders, ImmutableList<ImmutableSet<StarlarkProviderIdentifier>> starlarkProviders) {
        this.constraint = constraint;
        Preconditions.checkState(constraint.equals((Object)Constraint.RESTRICTED) || builtinProviders.isEmpty() && starlarkProviders.isEmpty());
        this.builtinProviders = builtinProviders;
        this.starlarkProviders = starlarkProviders;
    }

    private static <T> void describe(StringBuilder result, ImmutableList<ImmutableSet<T>> listOfSets, Function<T, String> describeOne) {
        Joiner joiner = Joiner.on(", ");
        for (ImmutableSet immutableSet : listOfSets) {
            if (result.length() > 0) {
                result.append(" or ");
            }
            result.append(immutableSet.size() > 1 ? "[" : "");
            joiner.appendTo(result, immutableSet.stream().map(describeOne).iterator());
            result.append(immutableSet.size() > 1 ? "]" : "");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequiredProviders that = (RequiredProviders)o;
        return this.constraint == that.constraint && Objects.equals(this.builtinProviders, that.builtinProviders) && Objects.equals(this.starlarkProviders, that.starlarkProviders);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.constraint, this.builtinProviders, this.starlarkProviders});
    }

    public static Builder acceptAnyBuilder() {
        return new Builder(false);
    }

    void addToAspectDefinitionBuilder(AspectDefinition.Builder aspectDefinitionBuilder) {
        aspectDefinitionBuilder.requireProviderSets(this.builtinProviders);
        aspectDefinitionBuilder.requireStarlarkProviderSets(this.starlarkProviders);
    }

    public static Builder acceptNoneBuilder() {
        return new Builder(true);
    }

    public Builder copyAsBuilder() {
        return this.constraint.copyAsBuilder(this);
    }

    public static class Builder {
        private final ImmutableList.Builder<ImmutableSet<Class<? extends TransitiveInfoProvider>>> builtinProviders;
        private final ImmutableList.Builder<ImmutableSet<StarlarkProviderIdentifier>> starlarkProviders;
        private Constraint constraint;

        private Builder(boolean acceptNone) {
            this.constraint = acceptNone ? Constraint.NONE : Constraint.ANY;
            this.builtinProviders = ImmutableList.builder();
            this.starlarkProviders = ImmutableList.builder();
        }

        @CanIgnoreReturnValue
        public Builder addStarlarkSet(ImmutableSet<StarlarkProviderIdentifier> starlarkProviderSet) {
            this.constraint = Constraint.RESTRICTED;
            Preconditions.checkState(!starlarkProviderSet.isEmpty());
            this.starlarkProviders.add((Object)starlarkProviderSet);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addBuiltinSet(ImmutableSet<Class<? extends TransitiveInfoProvider>> builtinProviderSet) {
            this.constraint = Constraint.RESTRICTED;
            Preconditions.checkState(!builtinProviderSet.isEmpty());
            this.builtinProviders.add((Object)builtinProviderSet);
            return this;
        }

        public RequiredProviders build() {
            return new RequiredProviders(this.constraint, (ImmutableList<ImmutableSet<Class<? extends TransitiveInfoProvider>>>)this.builtinProviders.build(), (ImmutableList<ImmutableSet<StarlarkProviderIdentifier>>)this.starlarkProviders.build());
        }
    }

    @AutoCodec.VisibleForSerialization
    static enum Constraint {
        ANY{

            @Override
            public boolean satisfies(AdvertisedProviderSet advertisedProviderSet, RequiredProviders requiredProviders, Builder missing) {
                return true;
            }

            @Override
            public boolean satisfies(Predicate<Class<? extends TransitiveInfoProvider>> hasBuiltinProvider, Predicate<StarlarkProviderIdentifier> hasStarlarkProvider, RequiredProviders requiredProviders, Builder missingProviders) {
                return true;
            }

            @Override
            Builder copyAsBuilder(RequiredProviders providers) {
                return RequiredProviders.acceptAnyBuilder();
            }

            @Override
            public String getDescription(RequiredProviders providers) {
                return "no providers required";
            }
        }
        ,
        NONE{

            @Override
            public boolean satisfies(AdvertisedProviderSet advertisedProviderSet, RequiredProviders requiredProviders, Builder missing) {
                return false;
            }

            @Override
            public boolean satisfies(Predicate<Class<? extends TransitiveInfoProvider>> hasBuiltinProvider, Predicate<StarlarkProviderIdentifier> hasStarlarkProvider, RequiredProviders requiredProviders, Builder missingProviders) {
                return false;
            }

            @Override
            Builder copyAsBuilder(RequiredProviders providers) {
                return RequiredProviders.acceptNoneBuilder();
            }

            @Override
            public String getDescription(RequiredProviders providers) {
                return "no providers accepted";
            }
        }
        ,
        RESTRICTED{

            @Override
            public boolean satisfies(AdvertisedProviderSet advertisedProviderSet, RequiredProviders requiredProviders, Builder missing) {
                if (advertisedProviderSet.canHaveAnyProvider()) {
                    return true;
                }
                return this.satisfies(advertisedProviderSet.getBuiltinProviders()::contains, advertisedProviderSet.getStarlarkProviders()::contains, requiredProviders, missing);
            }

            @Override
            boolean satisfies(Predicate<Class<? extends TransitiveInfoProvider>> hasBuiltinProvider, Predicate<StarlarkProviderIdentifier> hasStarlarkProvider, RequiredProviders requiredProviders, Builder missingProviders) {
                for (ImmutableSet immutableSet : requiredProviders.builtinProviders) {
                    if (immutableSet.stream().allMatch(hasBuiltinProvider)) {
                        return true;
                    }
                    if (missingProviders == null) continue;
                    missingProviders.addBuiltinSet(immutableSet.stream().filter(hasBuiltinProvider.negate()).collect(ImmutableSet.toImmutableSet()));
                }
                for (ImmutableSet immutableSet : requiredProviders.starlarkProviders) {
                    if (immutableSet.stream().allMatch(hasStarlarkProvider)) {
                        return true;
                    }
                    if (missingProviders == null) continue;
                    missingProviders.addStarlarkSet(immutableSet.stream().filter(hasStarlarkProvider.negate()).collect(ImmutableSet.toImmutableSet()));
                }
                return false;
            }

            @Override
            Builder copyAsBuilder(RequiredProviders providers) {
                Builder result = RequiredProviders.acceptAnyBuilder();
                for (ImmutableSet immutableSet : providers.builtinProviders) {
                    result.addBuiltinSet(immutableSet);
                }
                for (ImmutableSet immutableSet : providers.starlarkProviders) {
                    result.addStarlarkSet(immutableSet);
                }
                return result;
            }

            @Override
            public String getDescription(RequiredProviders providers) {
                StringBuilder result = new StringBuilder();
                RequiredProviders.describe(result, providers.builtinProviders, Class::getSimpleName);
                RequiredProviders.describe(result, providers.starlarkProviders, id -> "'" + id.toString() + "'");
                return result.toString();
            }
        };


        protected abstract boolean satisfies(AdvertisedProviderSet var1, RequiredProviders var2, Builder var3);

        abstract boolean satisfies(Predicate<Class<? extends TransitiveInfoProvider>> var1, Predicate<StarlarkProviderIdentifier> var2, RequiredProviders var3, @Nullable Builder var4);

        abstract Builder copyAsBuilder(RequiredProviders var1);

        abstract String getDescription(RequiredProviders var1);
    }
}

