/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.cmdline.PackageIdentifier;
import com.google.devtools.build.lib.packages.InvalidPackageNameException;
import com.google.devtools.build.lib.vfs.PathFragment;

public class RelativePackageNameResolver {
    private final PathFragment offset;
    private final boolean discardBuild;

    public RelativePackageNameResolver(PathFragment offset, boolean discardBuild) {
        Preconditions.checkArgument(!offset.containsUplevelReferences(), "offset should not contain uplevel references");
        this.offset = offset;
        this.discardBuild = discardBuild;
    }

    public String resolve(String pkg) throws InvalidPackageNameException {
        PathFragment result;
        String relativePkg;
        boolean isAbsolute;
        if (pkg.startsWith("//")) {
            isAbsolute = true;
            relativePkg = pkg.substring(2);
        } else {
            if (pkg.startsWith("/")) {
                throw new InvalidPackageNameException(PackageIdentifier.createInMainRepo(pkg), "package name cannot start with a single slash");
            }
            isAbsolute = false;
            relativePkg = pkg;
        }
        PathFragment relative = PathFragment.create(relativePkg);
        if (this.discardBuild && relative.getBaseName().equals("BUILD")) {
            relative = relative.getParentDirectory();
        }
        PathFragment pathFragment = result = isAbsolute ? relative : this.offset.getRelative(relative);
        if (result.containsUplevelReferences()) {
            throw new InvalidPackageNameException(PackageIdentifier.createInMainRepo(pkg), "package name contains too many '..' segments");
        }
        return result.getPathString();
    }
}

