/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.packages.AbstractAttributeMapper;
import com.google.devtools.build.lib.packages.Attribute;
import com.google.devtools.build.lib.packages.BuildType;
import com.google.devtools.build.lib.packages.Rule;
import com.google.devtools.build.lib.packages.Type;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public class RawAttributeMapper
extends AbstractAttributeMapper {
    private RawAttributeMapper(Rule rule) {
        super(rule);
    }

    public static RawAttributeMapper of(Rule rule) {
        return new RawAttributeMapper(rule);
    }

    @Nullable
    public <T> Collection<T> getMergedValues(String attributeName, Type<List<T>> type) {
        Preconditions.checkState(type instanceof Type.ListType);
        if (!this.isConfigurable(attributeName)) {
            return this.get(attributeName, type);
        }
        ImmutableSet.Builder mergedValues = ImmutableSet.builder();
        for (BuildType.Selector<List<List>> selector : this.getSelectorList(attributeName, type).getSelectors()) {
            selector.forEach((label, value) -> {
                if (value != null) {
                    mergedValues.addAll((Iterable)value);
                }
            });
        }
        return mergedValues.build();
    }

    public <T> Iterable<Label> getConfigurabilityKeys(String attributeName, Type<T> type) {
        BuildType.SelectorList<T> selectorList = this.getSelectorList(attributeName, type);
        if (selectorList == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (BuildType.Selector<Object> selector : selectorList.getSelectors()) {
            selector.forEach((label, value) -> builder.add(label));
        }
        return builder.build();
    }

    @Nullable
    public Object getRawAttributeValue(Rule rule, String attrName) {
        Attribute attr = Preconditions.checkNotNull(this.getAttributeDefinition(attrName), "%s %s", (Object)rule, (Object)attrName);
        return this.getRawAttributeValue(rule, attr);
    }

    @Nullable
    public Object getRawAttributeValue(Rule rule, Attribute attr) {
        if (attr.getName().equals("visibility")) {
            return rule.getVisibilityDeclaredLabels();
        }
        BuildType.SelectorList<?> selectorList = this.getSelectorList(attr.getName(), attr.getType());
        if (selectorList != null) {
            return selectorList;
        }
        Attribute.ComputedDefault computedDefault = this.getComputedDefault(attr.getName(), attr.getType());
        if (computedDefault != null) {
            return computedDefault;
        }
        return this.get(attr.getName(), attr.getType());
    }
}

