/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import java.util.Arrays;
import java.util.Map;
import net.starlark.java.annot.Param;
import net.starlark.java.annot.StarlarkBuiltin;
import net.starlark.java.annot.StarlarkMethod;
import net.starlark.java.eval.Dict;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Sequence;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkFloat;
import net.starlark.java.eval.StarlarkInt;
import net.starlark.java.eval.StarlarkValue;
import net.starlark.java.eval.Structure;

@StarlarkBuiltin(name="proto", category="TOP_LEVEL_MODULE", doc="A module for protocol message processing.")
public class Proto
implements StarlarkValue {
    public static final Proto INSTANCE = new Proto();

    private Proto() {
    }

    @StarlarkMethod(name="encode_text", doc="Returns the struct argument's encoding as a text-format protocol message.\nThe data structure must be recursively composed of strings, ints, floats, or bools, or structs, sequences, and dicts of these types.\n<p>A struct is converted to a message. Fields are emitted in name order.\nEach struct field whose value is None is ignored.\n<p>A sequence (such as a list or tuple) is converted to a repeated field.\nIts elements must not be sequences or dicts.\n<p>A dict is converted to a repeated field of messages with fields named 'key' and 'value'.\nEntries are emitted in iteration (insertion) order.\nThe dict's keys must be strings or ints, and its values must not be sequences or dicts.\nExamples:<br><pre class=language-python>proto.encode_text(struct(field=123))\n# field: 123\n\nproto.encode_text(struct(field=True))\n# field: true\n\nproto.encode_text(struct(field=[1, 2, 3]))\n# field: 1\n# field: 2\n# field: 3\n\nproto.encode_text(struct(field='text', ignored_field=None))\n# field: \"text\"\n\nproto.encode_text(struct(field=struct(inner_field='text', ignored_field=None)))\n# field {\n#   inner_field: \"text\"\n# }\n\nproto.encode_text(struct(field=[struct(inner_field=1), struct(inner_field=2)]))\n# field {\n#   inner_field: 1\n# }\n# field {\n#   inner_field: 2\n# }\n\nproto.encode_text(struct(field=struct(inner_field=struct(inner_inner_field='text'))))\n# field {\n#    inner_field {\n#     inner_inner_field: \"text\"\n#   }\n# }\n\nproto.encode_text(struct(foo={4: 3, 2: 1}))\n# foo: {\n#   key: 4\n#   value: 3\n# }\n# foo: {\n#   key: 2\n#   value: 1\n# }\n</pre>", parameters={@Param(name="x")})
    public String encodeText(Structure x) throws EvalException {
        TextEncoder enc = new TextEncoder();
        enc.message(x);
        return enc.out.toString();
    }

    private static final class TextEncoder {
        private final StringBuilder out = new StringBuilder();
        private int indent = 0;

        private TextEncoder() {
        }

        private void message(Structure x) throws EvalException {
            Object[] fields = x.getFieldNames().toArray(new String[0]);
            Arrays.sort(fields);
            for (Object field : fields) {
                try {
                    this.field((String)field, x.getValue((String)field));
                }
                catch (EvalException ex) {
                    throw Starlark.errorf("in %s field .%s: %s", Starlark.type(x), field, ex.getMessage());
                }
            }
        }

        private void field(String name, Object v) throws EvalException {
            if (v instanceof Dict) {
                Dict dict = (Dict)v;
                for (Map.Entry entry : dict.entrySet()) {
                    Object key = entry.getKey();
                    if (!(key instanceof String) && !(key instanceof StarlarkInt)) {
                        throw Starlark.errorf("invalid dict key: got %s, want int or string", Starlark.type(key));
                    }
                    this.emitLine(name, " {");
                    ++this.indent;
                    this.fieldElement("key", key);
                    try {
                        this.fieldElement("value", entry.getValue());
                    }
                    catch (EvalException ex) {
                        throw Starlark.errorf("in value for dict key %s: %s", Starlark.repr(key), ex.getMessage());
                    }
                    --this.indent;
                    this.emitLine("}");
                }
                return;
            }
            if (v instanceof Sequence) {
                int i = 0;
                for (Object item : (Sequence)v) {
                    try {
                        this.fieldElement(name, item);
                    }
                    catch (EvalException ex) {
                        throw Starlark.errorf("at %s index %d: %s", Starlark.type(v), i, ex.getMessage());
                    }
                    ++i;
                }
                return;
            }
            if (v == Starlark.NONE) {
                return;
            }
            this.fieldElement(name, v);
        }

        private void fieldElement(String name, Object v) throws EvalException {
            if (v instanceof Structure) {
                this.emitLine(name, " {");
                ++this.indent;
                this.message((Structure)v);
                --this.indent;
                this.emitLine("}");
            } else if (v instanceof String) {
                String s2 = (String)v;
                this.emitLine(name, ": \"", s2.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n"), "\"");
            } else if (v instanceof StarlarkInt || v instanceof Boolean) {
                this.emitLine(name, ": ", v.toString());
            } else if (v instanceof StarlarkFloat) {
                String s3 = v.toString();
                if (s3.equals("+inf")) {
                    s3 = "inf";
                }
                this.emitLine(name, ": ", s3);
            } else {
                throw Starlark.errorf("got %s, want string, int, float, bool, or struct", Starlark.type(v));
            }
        }

        private void emitLine(String ... items) {
            for (int i = 0; i < this.indent; ++i) {
                this.out.append("  ");
            }
            for (String item : items) {
                this.out.append(item);
            }
            this.out.append('\n');
        }
    }
}

