/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.cmdline.LabelSyntaxException;
import com.google.devtools.build.lib.cmdline.PackageIdentifier;
import com.google.devtools.build.lib.cmdline.RepositoryName;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.AutoCodec;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.SerializationConstant;
import com.google.devtools.build.lib.vfs.PathFragment;
import javax.annotation.Nullable;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Starlark;

public abstract class PackageSpecification {
    private static final String PUBLIC_VISIBILITY = "public";
    private static final String PRIVATE_VISIBILITY = "private";
    private static final String ALL_BENEATH_SUFFIX = "/...";
    private static final String NEGATIVE_PREFIX = "-";
    private static final String PACKAGE_LABEL = "__pkg__";
    private static final String SUBTREE_LABEL = "__subpackages__";

    protected abstract boolean containsPackage(PackageIdentifier var1);

    protected abstract String asString(boolean var1);

    protected abstract String asStringWithoutRepository();

    public String toString() {
        return this.asString(false);
    }

    public static PackageSpecification fromString(RepositoryName repositoryName, String spec, boolean allowPublicPrivate, boolean repoRootMeansCurrentRepo) throws InvalidPackageSpecificationException {
        if (repoRootMeansCurrentRepo && !allowPublicPrivate) {
            throw new InvalidPackageSpecificationException("Cannot use new \"//...\" meaning without allowing new \"public\" syntax. Try enabling --incompatible_package_group_has_public_syntax or disabling --incompatible_fix_package_group_reporoot_syntax.");
        }
        if (!allowPublicPrivate && (spec.equals(PUBLIC_VISIBILITY) || spec.equals(PRIVATE_VISIBILITY))) {
            throw new InvalidPackageSpecificationException(String.format("Use of \"%s\" package specification requires enabling --incompatible_package_group_has_public_syntax", spec));
        }
        boolean negative = false;
        if (spec.startsWith(NEGATIVE_PREFIX)) {
            negative = true;
            if ((spec = spec.substring(NEGATIVE_PREFIX.length())).equals(PUBLIC_VISIBILITY) || spec.equals(PRIVATE_VISIBILITY)) {
                throw new InvalidPackageSpecificationException(String.format("Cannot negate \"%s\" package specification", spec));
            }
        }
        PackageSpecification packageSpecification = PackageSpecification.fromStringPositive(repositoryName, spec, repoRootMeansCurrentRepo);
        return negative ? new NegativePackageSpecification(packageSpecification) : packageSpecification;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static PackageSpecification fromStringPositive(RepositoryName repositoryName, String spec, boolean repoRootMeansCurrentRepo) throws InvalidPackageSpecificationException {
        PackageIdentifier unqualifiedPkgId;
        String pkgPath;
        if (spec.equals(PUBLIC_VISIBILITY)) {
            return AllPackages.INSTANCE;
        }
        if (spec.equals(PRIVATE_VISIBILITY)) {
            return NoPackages.INSTANCE;
        }
        if (!spec.startsWith("//")) {
            throw new InvalidPackageSpecificationException(String.format("invalid package name '%s': must start with '//' or be 'public' or 'private'", spec));
        }
        boolean allBeneath = false;
        if (spec.endsWith(ALL_BENEATH_SUFFIX)) {
            allBeneath = true;
            pkgPath = spec.substring(0, spec.length() - ALL_BENEATH_SUFFIX.length());
            if (pkgPath.equals("/")) {
                if (!repoRootMeansCurrentRepo) return AllPackages.INSTANCE;
                pkgPath = "//";
            }
        } else {
            pkgPath = spec;
        }
        try {
            unqualifiedPkgId = PackageIdentifier.parse(pkgPath);
        }
        catch (LabelSyntaxException e) {
            throw new InvalidPackageSpecificationException(String.format("invalid package name '%s': %s", spec, e.getMessage()));
        }
        Verify.verify(unqualifiedPkgId.getRepository().isMain());
        PackageIdentifier pkgId = PackageIdentifier.create(repositoryName, unqualifiedPkgId.getPackageFragment());
        return allBeneath ? new AllPackagesBeneath(pkgId) : new SinglePackage(pkgId);
    }

    public static PackageSpecification fromStringForBzlVisibility(RepositoryName repositoryName, String spec) throws EvalException {
        PackageSpecification result;
        try {
            result = PackageSpecification.fromString(repositoryName, spec, true, true);
        }
        catch (InvalidPackageSpecificationException e) {
            throw new EvalException(e.getMessage());
        }
        if (result instanceof NegativePackageSpecification) {
            throw Starlark.errorf("Cannot use negative package patterns here", new Object[0]);
        }
        return result;
    }

    @Nullable
    static PackageSpecification fromLabel(Label label) {
        if (label.getName().equals(PACKAGE_LABEL)) {
            return new SinglePackage(label.getPackageIdentifier());
        }
        if (label.getName().equals(SUBTREE_LABEL)) {
            return new AllPackagesBeneath(label.getPackageIdentifier());
        }
        return null;
    }

    public static PackageSpecification everything() {
        return AllPackages.INSTANCE;
    }

    public static PackageSpecification nothing() {
        return NoPackages.INSTANCE;
    }

    public static final class PackageGroupContents {
        private final ImmutableSet<PackageIdentifier> singlePackagePositives;
        private final ImmutableList<PackageIdentifier> allPackagesBeneathPositives;
        private final boolean hasPositiveAllPackages;
        private final ImmutableSet<PackageIdentifier> singlePackageNegatives;
        private final ImmutableList<PackageIdentifier> allPackagesBeneathNegatives;
        private final boolean hasPrivate;
        private final boolean hasNegativeAllPackages;

        private PackageGroupContents(ImmutableList<PackageSpecification> packageSpecifications) {
            ImmutableSet.Builder singlePackagePositivesBuilder = ImmutableSet.builder();
            ImmutableList.Builder allPackagesBeneathPositivesBuilder = ImmutableList.builder();
            boolean hasPositiveAllPackages = false;
            ImmutableSet.Builder singlePackageNegativesBuilder = ImmutableSet.builder();
            ImmutableList.Builder allPackagesBeneathNegativesBuilder = ImmutableList.builder();
            boolean hasPrivate = false;
            boolean hasNegativeAllPackages = false;
            for (PackageSpecification spec : packageSpecifications) {
                if (spec instanceof SinglePackage) {
                    singlePackagePositivesBuilder.add(((SinglePackage)spec).singlePackageName);
                    continue;
                }
                if (spec instanceof AllPackagesBeneath) {
                    allPackagesBeneathPositivesBuilder.add(((AllPackagesBeneath)spec).prefix);
                    continue;
                }
                if (spec instanceof AllPackages) {
                    hasPositiveAllPackages = true;
                    continue;
                }
                if (spec instanceof NoPackages) {
                    hasPrivate = true;
                    continue;
                }
                PackageSpecification delegate = ((NegativePackageSpecification)spec).delegate;
                if (delegate instanceof SinglePackage) {
                    singlePackageNegativesBuilder.add(((SinglePackage)delegate).singlePackageName);
                    continue;
                }
                if (delegate instanceof AllPackagesBeneath) {
                    allPackagesBeneathNegativesBuilder.add(((AllPackagesBeneath)delegate).prefix);
                    continue;
                }
                if (delegate instanceof AllPackages) {
                    hasNegativeAllPackages = true;
                    continue;
                }
                throw new IllegalStateException(spec.toString());
            }
            this.singlePackagePositives = singlePackagePositivesBuilder.build();
            this.allPackagesBeneathPositives = allPackagesBeneathPositivesBuilder.build();
            this.hasPositiveAllPackages = hasPositiveAllPackages;
            this.singlePackageNegatives = singlePackageNegativesBuilder.build();
            this.allPackagesBeneathNegatives = allPackagesBeneathNegativesBuilder.build();
            this.hasPrivate = hasPrivate;
            this.hasNegativeAllPackages = hasNegativeAllPackages;
        }

        public static PackageGroupContents create(ImmutableList<PackageSpecification> packageSpecifications) {
            return new PackageGroupContents(packageSpecifications);
        }

        public boolean containsPackage(PackageIdentifier packageIdentifier) {
            int i;
            if (this.hasNegativeAllPackages) {
                return false;
            }
            if (this.singlePackageNegatives.contains(packageIdentifier)) {
                return false;
            }
            for (i = 0; i < this.allPackagesBeneathNegatives.size(); ++i) {
                if (!PackageGroupContents.matchesAllPackagesBeneath(packageIdentifier, (PackageIdentifier)this.allPackagesBeneathNegatives.get(i))) continue;
                return false;
            }
            if (this.hasPositiveAllPackages) {
                return true;
            }
            if (this.singlePackagePositives.contains(packageIdentifier)) {
                return true;
            }
            for (i = 0; i < this.allPackagesBeneathPositives.size(); ++i) {
                if (!PackageGroupContents.matchesAllPackagesBeneath(packageIdentifier, (PackageIdentifier)this.allPackagesBeneathPositives.get(i))) continue;
                return true;
            }
            return false;
        }

        private static boolean matchesAllPackagesBeneath(PackageIdentifier pkgId, PackageIdentifier prefix) {
            return pkgId.getRepository().equals(prefix.getRepository()) && pkgId.getPackageFragment().startsWith(prefix.getPackageFragment());
        }

        public ImmutableList<String> packageStrings(boolean includeDoubleSlash) {
            ImmutableList.Builder resultBuilder = ImmutableList.builder();
            for (PackageIdentifier pkgId : this.singlePackagePositives) {
                resultBuilder.add(PackageGroupContents.stringForSinglePackage(pkgId, includeDoubleSlash));
            }
            for (PackageIdentifier pkgId : this.allPackagesBeneathPositives) {
                resultBuilder.add(PackageGroupContents.stringForAllPackagesBeneath(pkgId, includeDoubleSlash));
            }
            for (PackageIdentifier pkgId : this.singlePackageNegatives) {
                resultBuilder.add(PackageSpecification.NEGATIVE_PREFIX + PackageGroupContents.stringForSinglePackage(pkgId, includeDoubleSlash));
            }
            for (PackageIdentifier pkgId : this.allPackagesBeneathNegatives) {
                resultBuilder.add(PackageSpecification.NEGATIVE_PREFIX + PackageGroupContents.stringForAllPackagesBeneath(pkgId, includeDoubleSlash));
            }
            if (this.hasPositiveAllPackages) {
                resultBuilder.add(PackageGroupContents.stringForAllPackages(includeDoubleSlash));
            }
            if (this.hasPrivate) {
                resultBuilder.add(PackageSpecification.PRIVATE_VISIBILITY);
            }
            if (this.hasNegativeAllPackages) {
                resultBuilder.add(PackageSpecification.NEGATIVE_PREFIX + PackageGroupContents.stringForAllPackages(includeDoubleSlash));
            }
            return resultBuilder.build();
        }

        private static String stringForAllPackages(boolean includeDoubleSlash) {
            return includeDoubleSlash ? PackageSpecification.PUBLIC_VISIBILITY : "//...";
        }

        private static String stringForSinglePackage(PackageIdentifier pkgId, boolean includeDoubleSlash) {
            if (includeDoubleSlash) {
                return pkgId.getCanonicalForm();
            }
            return pkgId.toString();
        }

        private static String stringForAllPackagesBeneath(PackageIdentifier pkgId, boolean includeDoubleSlash) {
            if (pkgId.getPackageFragment().equals(PathFragment.EMPTY_FRAGMENT)) {
                return pkgId.getCanonicalForm() + "...";
            }
            if (includeDoubleSlash) {
                return pkgId.getCanonicalForm() + PackageSpecification.ALL_BENEATH_SUFFIX;
            }
            return pkgId.toString() + PackageSpecification.ALL_BENEATH_SUFFIX;
        }

        public ImmutableList<String> packageStringsWithDoubleSlashAndWithoutRepository() {
            ImmutableList.Builder resultBuilder = ImmutableList.builder();
            for (PackageIdentifier pkgId : this.singlePackagePositives) {
                resultBuilder.add(PackageGroupContents.stringForSinglePackageWithDoubleSlashAndWithoutRepository(pkgId));
            }
            for (PackageIdentifier pkgId : this.allPackagesBeneathPositives) {
                resultBuilder.add(PackageGroupContents.stringForAllPackagesBeneathWithDoubleSlashAndWithoutRepository(pkgId));
            }
            for (PackageIdentifier pkgId : this.singlePackageNegatives) {
                resultBuilder.add(PackageSpecification.NEGATIVE_PREFIX + PackageGroupContents.stringForSinglePackageWithDoubleSlashAndWithoutRepository(pkgId));
            }
            for (PackageIdentifier pkgId : this.allPackagesBeneathNegatives) {
                resultBuilder.add(PackageSpecification.NEGATIVE_PREFIX + PackageGroupContents.stringForAllPackagesBeneathWithDoubleSlashAndWithoutRepository(pkgId));
            }
            if (this.hasPositiveAllPackages) {
                resultBuilder.add(PackageSpecification.PUBLIC_VISIBILITY);
            }
            if (this.hasPrivate) {
                resultBuilder.add(PackageSpecification.PRIVATE_VISIBILITY);
            }
            return resultBuilder.build();
        }

        private static String stringForSinglePackageWithDoubleSlashAndWithoutRepository(PackageIdentifier pkgId) {
            return "//" + pkgId.getPackageFragment().getPathString();
        }

        private static String stringForAllPackagesBeneathWithDoubleSlashAndWithoutRepository(PackageIdentifier pkgId) {
            PathFragment pathFragment = pkgId.getPackageFragment();
            return pathFragment.equals(PathFragment.EMPTY_FRAGMENT) ? "//..." : "//" + pathFragment.getPathString() + PackageSpecification.ALL_BENEATH_SUFFIX;
        }
    }

    static class InvalidPackageSpecificationException
    extends Exception {
        private InvalidPackageSpecificationException(String message) {
            super(message);
        }
    }

    @AutoCodec.VisibleForSerialization
    static final class NoPackages
    extends PackageSpecification {
        @SerializationConstant
        @AutoCodec.VisibleForSerialization
        static final PackageSpecification INSTANCE = new NoPackages();

        NoPackages() {
        }

        @Override
        protected boolean containsPackage(PackageIdentifier packageName) {
            return false;
        }

        @Override
        protected String asString(boolean includeDoubleSlash) {
            return PackageSpecification.PRIVATE_VISIBILITY;
        }

        @Override
        protected String asStringWithoutRepository() {
            return PackageSpecification.PRIVATE_VISIBILITY;
        }

        public boolean equals(Object o) {
            return o instanceof NoPackages;
        }

        public int hashCode() {
            return NoPackages.class.hashCode();
        }
    }

    @AutoCodec.VisibleForSerialization
    static final class AllPackages
    extends PackageSpecification {
        @SerializationConstant
        @AutoCodec.VisibleForSerialization
        static final PackageSpecification INSTANCE = new AllPackages();

        AllPackages() {
        }

        @Override
        protected boolean containsPackage(PackageIdentifier packageName) {
            return true;
        }

        @Override
        protected String asString(boolean includeDoubleSlash) {
            return PackageGroupContents.stringForAllPackages(includeDoubleSlash);
        }

        @Override
        protected String asStringWithoutRepository() {
            return PackageSpecification.PUBLIC_VISIBILITY;
        }

        public boolean equals(Object o) {
            return o instanceof AllPackages;
        }

        public int hashCode() {
            return AllPackages.class.hashCode();
        }
    }

    private static final class NegativePackageSpecification
    extends PackageSpecification {
        private final PackageSpecification delegate;

        NegativePackageSpecification(PackageSpecification delegate) {
            this.delegate = delegate;
        }

        @Override
        protected boolean containsPackage(PackageIdentifier packageName) {
            return this.delegate.containsPackage(packageName);
        }

        @Override
        protected String asString(boolean includeDoubleSlash) {
            return PackageSpecification.NEGATIVE_PREFIX + this.delegate.asString(includeDoubleSlash);
        }

        @Override
        protected String asStringWithoutRepository() {
            return PackageSpecification.NEGATIVE_PREFIX + this.delegate.asStringWithoutRepository();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof NegativePackageSpecification && this.delegate.equals(((NegativePackageSpecification)obj).delegate);
        }

        public int hashCode() {
            return NegativePackageSpecification.class.hashCode() ^ this.delegate.hashCode();
        }
    }

    private static final class AllPackagesBeneath
    extends PackageSpecification {
        private final PackageIdentifier prefix;

        AllPackagesBeneath(PackageIdentifier prefix) {
            this.prefix = prefix;
        }

        @Override
        protected boolean containsPackage(PackageIdentifier packageName) {
            return packageName.getRepository().equals(this.prefix.getRepository()) && packageName.getPackageFragment().startsWith(this.prefix.getPackageFragment());
        }

        @Override
        protected String asString(boolean includeDoubleSlash) {
            return PackageGroupContents.stringForAllPackagesBeneath(this.prefix, includeDoubleSlash);
        }

        @Override
        protected String asStringWithoutRepository() {
            return PackageGroupContents.stringForAllPackagesBeneathWithDoubleSlashAndWithoutRepository(this.prefix);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AllPackagesBeneath)) {
                return false;
            }
            AllPackagesBeneath that = (AllPackagesBeneath)o;
            return this.prefix.equals(that.prefix);
        }

        public int hashCode() {
            return this.prefix.hashCode();
        }
    }

    private static final class SinglePackage
    extends PackageSpecification {
        private final PackageIdentifier singlePackageName;

        SinglePackage(PackageIdentifier singlePackageName) {
            this.singlePackageName = singlePackageName;
        }

        @Override
        protected boolean containsPackage(PackageIdentifier packageName) {
            return this.singlePackageName.equals(packageName);
        }

        @Override
        protected String asString(boolean includeDoubleSlash) {
            return PackageGroupContents.stringForSinglePackage(this.singlePackageName, includeDoubleSlash);
        }

        @Override
        protected String asStringWithoutRepository() {
            return PackageGroupContents.stringForSinglePackageWithDoubleSlashAndWithoutRepository(this.singlePackageName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SinglePackage)) {
                return false;
            }
            SinglePackage that = (SinglePackage)o;
            return this.singlePackageName.equals(that.singlePackageName);
        }

        public int hashCode() {
            return this.singlePackageName.hashCode();
        }
    }
}

