/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.devtools.build.lib.packages.Package;
import java.util.List;
import java.util.OptionalLong;
import net.starlark.java.eval.StarlarkSemantics;

public interface PackageLoadingListener {
    public static final PackageLoadingListener NOOP_LISTENER = (pkg, semantics, loadTimeNanos, packageOverhead) -> {};

    public static PackageLoadingListener create(List<PackageLoadingListener> listeners) {
        switch (listeners.size()) {
            case 0: {
                return NOOP_LISTENER;
            }
            case 1: {
                return listeners.get(0);
            }
        }
        return (pkg, semantics, loadTimeNanos, packageOverhead) -> {
            for (PackageLoadingListener listener : listeners) {
                listener.onLoadingCompleteAndSuccessful(pkg, semantics, loadTimeNanos, packageOverhead);
            }
        };
    }

    public void onLoadingCompleteAndSuccessful(Package var1, StarlarkSemantics var2, long var3, OptionalLong var5);
}

