/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.packages.PackageSpecification;
import com.google.devtools.build.lib.packages.RuleVisibility;
import java.util.Collection;
import java.util.List;

public class PackageGroupsRuleVisibility
implements RuleVisibility {
    private final List<Label> packageGroups;
    private final PackageSpecification.PackageGroupContents directPackages;
    private final List<Label> declaredLabels;

    private PackageGroupsRuleVisibility(List<Label> labels) {
        this.declaredLabels = ImmutableList.copyOf(labels);
        ImmutableList.Builder directPackageBuilder = ImmutableList.builder();
        ImmutableList.Builder packageGroupBuilder = ImmutableList.builder();
        for (Label label : labels) {
            PackageSpecification specification = PackageSpecification.fromLabel(label);
            if (specification != null) {
                directPackageBuilder.add(specification);
                continue;
            }
            packageGroupBuilder.add(label);
        }
        this.packageGroups = packageGroupBuilder.build();
        this.directPackages = PackageSpecification.PackageGroupContents.create((ImmutableList<PackageSpecification>)directPackageBuilder.build());
    }

    public Collection<Label> getPackageGroups() {
        return this.packageGroups;
    }

    public PackageSpecification.PackageGroupContents getDirectPackages() {
        return this.directPackages;
    }

    @Override
    public List<Label> getDependencyLabels() {
        return this.packageGroups;
    }

    @Override
    public List<Label> getDeclaredLabels() {
        return this.declaredLabels;
    }

    public static PackageGroupsRuleVisibility create(List<Label> labels) {
        return new PackageGroupsRuleVisibility(labels);
    }
}

