/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.cmdline.PackageIdentifier;
import com.google.devtools.build.lib.events.EventHandler;
import com.google.devtools.build.lib.packages.License;
import com.google.devtools.build.lib.packages.Package;
import com.google.devtools.build.lib.packages.PackageSpecification;
import com.google.devtools.build.lib.packages.Rule;
import com.google.devtools.build.lib.packages.RuleVisibility;
import com.google.devtools.build.lib.packages.Target;
import com.google.devtools.build.lib.server.FailureDetails;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.starlark.java.syntax.Location;

public class PackageGroup
implements Target {
    private final boolean containsErrors;
    private final Label label;
    private final Location location;
    private final Package containingPackage;
    private final PackageSpecification.PackageGroupContents packageSpecifications;
    private final List<Label> includes;

    public PackageGroup(Label label, Package pkg, Collection<String> packageSpecifications, Collection<Label> includes, boolean allowPublicPrivate, boolean repoRootMeansCurrentRepo, EventHandler eventHandler, Location location) {
        this.label = label;
        this.location = location;
        this.containingPackage = pkg;
        this.includes = ImmutableList.copyOf(includes);
        ImmutableList.Builder packagesBuilder = ImmutableList.builder();
        boolean errorsFound = false;
        for (String packageSpecification : packageSpecifications) {
            PackageSpecification specification = null;
            try {
                specification = PackageSpecification.fromString(label.getRepository(), packageSpecification, allowPublicPrivate, repoRootMeansCurrentRepo);
            }
            catch (PackageSpecification.InvalidPackageSpecificationException e) {
                errorsFound = true;
                eventHandler.handle(Package.error(location, e.getMessage(), FailureDetails.PackageLoading.Code.INVALID_PACKAGE_SPECIFICATION));
            }
            if (specification == null) continue;
            packagesBuilder.add(specification);
        }
        this.containsErrors = errorsFound;
        this.packageSpecifications = PackageSpecification.PackageGroupContents.create((ImmutableList<PackageSpecification>)packagesBuilder.build());
    }

    public boolean containsErrors() {
        return this.containsErrors;
    }

    public PackageSpecification.PackageGroupContents getPackageSpecifications() {
        return this.packageSpecifications;
    }

    public boolean contains(PackageIdentifier pkgId) {
        return this.packageSpecifications.containsPackage(pkgId);
    }

    public List<Label> getIncludes() {
        return this.includes;
    }

    public List<String> getContainedPackages(boolean includeDoubleSlash) {
        return this.packageSpecifications.packageStrings(includeDoubleSlash);
    }

    @Override
    public Rule getAssociatedRule() {
        return null;
    }

    @Override
    public Set<License.DistributionType> getDistributions() {
        return Collections.emptySet();
    }

    @Override
    public Label getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.label.getName();
    }

    @Override
    public License getLicense() {
        return License.NO_LICENSE;
    }

    @Override
    public Package getPackage() {
        return this.containingPackage;
    }

    @Override
    public String getTargetKind() {
        return PackageGroup.targetKind();
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public String toString() {
        return PackageGroup.targetKind() + " " + this.getLabel();
    }

    @Override
    public RuleVisibility getVisibility() {
        return RuleVisibility.PUBLIC;
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    public static String targetKind() {
        return "package group";
    }
}

