/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.flogger.GoogleLogger;
import com.google.devtools.build.lib.actions.ThreadStateReceiver;
import com.google.devtools.build.lib.cmdline.BazelModuleContext;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.cmdline.PackageIdentifier;
import com.google.devtools.build.lib.cmdline.RepositoryMapping;
import com.google.devtools.build.lib.concurrent.NamedForkJoinPool;
import com.google.devtools.build.lib.events.Event;
import com.google.devtools.build.lib.events.ExtendedEventHandler;
import com.google.devtools.build.lib.events.StoredEventHandler;
import com.google.devtools.build.lib.packages.BazelStarlarkContext;
import com.google.devtools.build.lib.packages.BazelStarlarkEnvironment;
import com.google.devtools.build.lib.packages.CachingPackageLocator;
import com.google.devtools.build.lib.packages.DefaultPackageArguments;
import com.google.devtools.build.lib.packages.GlobCache;
import com.google.devtools.build.lib.packages.Globber;
import com.google.devtools.build.lib.packages.NonSkyframeGlobber;
import com.google.devtools.build.lib.packages.Package;
import com.google.devtools.build.lib.packages.PackageArgument;
import com.google.devtools.build.lib.packages.PackageLoadingListener;
import com.google.devtools.build.lib.packages.PackageOverheadEstimator;
import com.google.devtools.build.lib.packages.PackageValidator;
import com.google.devtools.build.lib.packages.RuleClassProvider;
import com.google.devtools.build.lib.packages.SymbolGenerator;
import com.google.devtools.build.lib.packages.semantics.BuildLanguageOptions;
import com.google.devtools.build.lib.profiler.Profiler;
import com.google.devtools.build.lib.profiler.ProfilerTask;
import com.google.devtools.build.lib.profiler.SilentCloseable;
import com.google.devtools.build.lib.server.FailureDetails;
import com.google.devtools.build.lib.util.DetailedExitCode;
import com.google.devtools.build.lib.vfs.FileSystem;
import com.google.devtools.build.lib.vfs.Path;
import com.google.devtools.build.lib.vfs.PathFragment;
import com.google.devtools.build.lib.vfs.RootedPath;
import com.google.devtools.build.lib.vfs.SyscallCache;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import net.starlark.java.eval.Dict;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Module;
import net.starlark.java.eval.Mutability;
import net.starlark.java.eval.Printer;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkCallable;
import net.starlark.java.eval.StarlarkFunction;
import net.starlark.java.eval.StarlarkSemantics;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.eval.Tuple;
import net.starlark.java.syntax.Argument;
import net.starlark.java.syntax.CallExpression;
import net.starlark.java.syntax.DefStatement;
import net.starlark.java.syntax.Expression;
import net.starlark.java.syntax.ForStatement;
import net.starlark.java.syntax.Identifier;
import net.starlark.java.syntax.IfStatement;
import net.starlark.java.syntax.IntLiteral;
import net.starlark.java.syntax.LambdaExpression;
import net.starlark.java.syntax.ListExpression;
import net.starlark.java.syntax.Location;
import net.starlark.java.syntax.NodeVisitor;
import net.starlark.java.syntax.Program;
import net.starlark.java.syntax.StarlarkFile;
import net.starlark.java.syntax.StringLiteral;
import net.starlark.java.syntax.SyntaxError;

public final class PackageFactory {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final RuleClassProvider ruleClassProvider;
    private SyscallCache syscallCache;
    private ForkJoinPool executor;
    private int maxDirectoriesToEagerlyVisitInGlobbing;
    private final Package.Builder.PackageSettings packageSettings;
    private final PackageValidator packageValidator;
    private final PackageOverheadEstimator packageOverheadEstimator;
    private final PackageLoadingListener packageLoadingListener;
    private final BazelStarlarkEnvironment bazelStarlarkEnvironment;

    @VisibleForTesting
    public Package.Builder.PackageSettings getPackageSettingsForTesting() {
        return this.packageSettings;
    }

    public PackageFactory(RuleClassProvider ruleClassProvider, ForkJoinPool executorForGlobbing, Package.Builder.PackageSettings packageSettings, PackageValidator packageValidator, PackageOverheadEstimator packageOverheadEstimator, PackageLoadingListener packageLoadingListener) {
        this.ruleClassProvider = ruleClassProvider;
        this.executor = executorForGlobbing;
        this.packageSettings = packageSettings;
        this.packageValidator = packageValidator;
        this.packageOverheadEstimator = packageOverheadEstimator;
        this.packageLoadingListener = packageLoadingListener;
        this.bazelStarlarkEnvironment = new BazelStarlarkEnvironment(ruleClassProvider, PackageFactory.newPackageFunction(PackageFactory.createPackageArguments(ruleClassProvider.getEnvironmentExtensions())));
    }

    public void setSyscallCache(SyscallCache syscallCache) {
        this.syscallCache = Preconditions.checkNotNull(syscallCache);
    }

    public void setGlobbingThreads(int globbingThreads) {
        if (this.executor == null) {
            this.executor = PackageFactory.makeForkJoinPool(globbingThreads);
            return;
        }
        if (this.executor.getParallelism() == globbingThreads) {
            return;
        }
        this.executor.shutdown();
        this.executor = PackageFactory.makeForkJoinPool(globbingThreads);
    }

    public static ForkJoinPool makeDefaultSizedForkJoinPoolForGlobbing() {
        return PackageFactory.makeForkJoinPool(100);
    }

    private static ForkJoinPool makeForkJoinPool(int globbingThreads) {
        return NamedForkJoinPool.newNamedPool("globbing pool", globbingThreads);
    }

    public void setMaxDirectoriesToEagerlyVisitInGlobbing(int maxDirectoriesToEagerlyVisitInGlobbing) {
        this.maxDirectoriesToEagerlyVisitInGlobbing = maxDirectoriesToEagerlyVisitInGlobbing;
    }

    public RuleClassProvider getRuleClassProvider() {
        return this.ruleClassProvider;
    }

    public BazelStarlarkEnvironment getBazelStarlarkEnvironment() {
        return this.bazelStarlarkEnvironment;
    }

    private static ImmutableMap<String, PackageArgument<?>> createPackageArguments(List<EnvironmentExtension> environmentExtensions) {
        ImmutableCollection.Builder arguments = ImmutableList.builder().addAll(DefaultPackageArguments.get());
        for (EnvironmentExtension extension : environmentExtensions) {
            ((ImmutableList.Builder)arguments).addAll(extension.getPackageArguments());
        }
        ImmutableMap.Builder<String, PackageArgument> packageArguments = ImmutableMap.builder();
        for (PackageArgument argument : ((ImmutableList.Builder)arguments).build()) {
            packageArguments.put(argument.getName(), argument);
        }
        return packageArguments.buildOrThrow();
    }

    private static StarlarkCallable newPackageFunction(final Map<String, PackageArgument<?>> packageArguments) {
        return new StarlarkCallable(){

            @Override
            public String getName() {
                return "package";
            }

            public String toString() {
                return "package(...)";
            }

            @Override
            public boolean isImmutable() {
                return true;
            }

            @Override
            public void repr(Printer printer) {
                printer.append("<built-in function package>");
            }

            @Override
            public Object call(StarlarkThread thread, Tuple args, Dict<String, Object> kwargs) throws EvalException {
                if (!args.isEmpty()) {
                    throw new EvalException("unexpected positional arguments");
                }
                Package.Builder pkgBuilder = PackageFactory.getContext((StarlarkThread)thread).pkgBuilder;
                if (pkgBuilder.isPackageFunctionUsed()) {
                    throw new EvalException("'package' can only be used once per BUILD file");
                }
                pkgBuilder.setPackageFunctionUsed();
                if (kwargs.isEmpty()) {
                    throw new EvalException("at least one argument must be given to the 'package' function");
                }
                Location loc = thread.getCallerLocation();
                for (Map.Entry<String, Object> kwarg : kwargs.entrySet()) {
                    String name = kwarg.getKey();
                    PackageArgument pkgarg = (PackageArgument)packageArguments.get(name);
                    if (pkgarg == null) {
                        throw Starlark.errorf("unexpected keyword argument: %s", name);
                    }
                    pkgarg.convertAndProcess(pkgBuilder, loc, kwarg.getValue());
                }
                return Starlark.NONE;
            }
        };
    }

    public static PackageContext getContext(StarlarkThread thread) throws EvalException {
        PackageContext value = thread.getThreadLocal(PackageContext.class);
        if (value == null) {
            throw Starlark.errorf("The native module can be accessed only from a BUILD thread. Wrap the function in a macro and call it from a BUILD file", new Object[0]);
        }
        return value;
    }

    public Package.Builder newExternalPackageBuilder(RootedPath workspacePath, String workspaceName, RepositoryMapping mainRepoMapping, StarlarkSemantics starlarkSemantics) {
        return Package.newExternalPackageBuilder(this.packageSettings, workspacePath, workspaceName, mainRepoMapping, starlarkSemantics);
    }

    public Package.Builder newPackageBuilder(PackageIdentifier packageId, String workspaceName, Optional<String> associatedModuleName, Optional<String> associatedModuleVersion, StarlarkSemantics starlarkSemantics, RepositoryMapping repositoryMapping, RepositoryMapping mainRepositoryMapping) {
        return new Package.Builder(this.packageSettings, packageId, workspaceName, associatedModuleName, associatedModuleVersion, starlarkSemantics.getBool("-incompatible_no_implicit_file_export"), repositoryMapping, mainRepositoryMapping);
    }

    public NonSkyframeGlobber createNonSkyframeGlobber(Path packageDirectory, PackageIdentifier packageId, ImmutableSet<PathFragment> ignoredGlobPrefixes, CachingPackageLocator locator, ThreadStateReceiver threadStateReceiverForMetrics) {
        return new NonSkyframeGlobber(new GlobCache(packageDirectory, packageId, ignoredGlobPrefixes, locator, this.syscallCache, this.executor, this.maxDirectoriesToEagerlyVisitInGlobbing, threadStateReceiverForMetrics));
    }

    public void afterDoneLoadingPackage(Package pkg, StarlarkSemantics starlarkSemantics, long loadTimeNanos, ExtendedEventHandler eventHandler) throws PackageValidator.InvalidPackageException {
        OptionalLong packageOverhead = this.packageOverheadEstimator.estimatePackageOverhead(pkg);
        this.packageValidator.validate(pkg, packageOverhead, eventHandler);
        long maxSteps = starlarkSemantics.get(BuildLanguageOptions.MAX_COMPUTATION_STEPS);
        long steps = pkg.getComputationSteps();
        if (maxSteps > 0L && steps > maxSteps) {
            String message = String.format("BUILD file computation took %d steps, but --max_computation_steps=%d", steps, maxSteps);
            throw new PackageValidator.InvalidPackageException(pkg.getPackageIdentifier(), message, DetailedExitCode.of(FailureDetails.FailureDetail.newBuilder().setMessage(message).setPackageLoading(FailureDetails.PackageLoading.newBuilder().setCode(FailureDetails.PackageLoading.Code.MAX_COMPUTATION_STEPS_EXCEEDED).build()).build()));
        }
        this.packageLoadingListener.onLoadingCompleteAndSuccessful(pkg, starlarkSemantics, loadTimeNanos, packageOverhead);
    }

    public void executeBuildFile(Package.Builder pkgBuilder, Program buildFileProgram, ImmutableList<String> globs, ImmutableList<String> globsWithDirs, ImmutableList<String> subpackages, ImmutableMap<String, Object> predeclared, ImmutableMap<String, Module> loadedModules, StarlarkSemantics starlarkSemantics, Globber globber) throws InterruptedException {
        if (this.maxDirectoriesToEagerlyVisitInGlobbing == -2) {
            try {
                boolean allowEmpty = true;
                globber.runAsync(globs, ImmutableList.of(), Globber.Operation.FILES, allowEmpty);
                globber.runAsync(globsWithDirs, ImmutableList.of(), Globber.Operation.FILES_AND_DIRS, allowEmpty);
                globber.runAsync(subpackages, ImmutableList.of(), Globber.Operation.SUBPACKAGES, allowEmpty);
            }
            catch (Globber.BadGlobException ex) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).log("Suppressing exception for globs=%s, globsWithDirs=%s", globs, globsWithDirs);
            }
        }
        try {
            this.executeBuildFileImpl(pkgBuilder, buildFileProgram, predeclared, loadedModules, starlarkSemantics, globber);
        }
        catch (InterruptedException e) {
            globber.onInterrupt();
            throw e;
        }
        finally {
            globber.onCompletion();
        }
    }

    private void executeBuildFileImpl(Package.Builder pkgBuilder, Program buildFileProgram, ImmutableMap<String, Object> predeclared, ImmutableMap<String, Module> loadedModules, StarlarkSemantics semantics, Globber globber) throws InterruptedException {
        pkgBuilder.setStarlarkFileDependencies(PackageFactory.transitiveClosureOfLabels(loadedModules));
        if (this.packageSettings.recordLoadedModules()) {
            pkgBuilder.setLoads(loadedModules);
        }
        StoredEventHandler eventHandler = new StoredEventHandler();
        PackageContext pkgContext = new PackageContext(pkgBuilder, globber, eventHandler);
        try (Mutability mu = Mutability.create("package", pkgBuilder.getFilename());){
            Module module = Module.withPredeclared(semantics, predeclared);
            StarlarkThread thread = new StarlarkThread(mu, semantics);
            thread.setLoader(loadedModules::get);
            thread.setPrintHandler(Event.makeDebugPrintHandler(pkgContext.eventHandler));
            new BazelStarlarkContext(BazelStarlarkContext.Phase.LOADING, this.ruleClassProvider.getToolsRepository(), null, new SymbolGenerator<PackageIdentifier>(pkgBuilder.getPackageIdentifier()), null, this.ruleClassProvider.getNetworkAllowlistForTests().orElse(null)).storeInThread(thread);
            thread.setThreadLocal(PackageContext.class, pkgContext);
            try {
                Starlark.execFileProgram(buildFileProgram, module, thread);
            }
            catch (EvalException ex) {
                pkgContext.eventHandler.handle(Package.error(null, ex.getMessageWithStack(), FailureDetails.PackageLoading.Code.STARLARK_EVAL_ERROR));
                pkgBuilder.setContainsErrors();
            }
            catch (InterruptedException ex) {
                if (pkgContext.pkgBuilder.containsErrors()) {
                    Thread.currentThread().interrupt();
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withCause(ex)).log("Suppressing InterruptedException for Package %s because an error was also found", pkgBuilder.getPackageIdentifier().getCanonicalForm());
                }
                throw ex;
            }
            pkgBuilder.setComputationSteps(thread.getExecutedSteps());
        }
        pkgBuilder.addPosts(eventHandler.getPosts());
        pkgBuilder.addEvents(eventHandler.getEvents());
    }

    private static ImmutableList<Label> transitiveClosureOfLabels(ImmutableMap<String, Module> loads) {
        LinkedHashSet<Label> set = Sets.newLinkedHashSet();
        PackageFactory.transitiveClosureOfLabelsRec(set, loads);
        return ImmutableList.copyOf(set);
    }

    public static void transitiveClosureOfLabelsRec(Set<Label> set, ImmutableMap<String, Module> loads) {
        for (Module m4 : loads.values()) {
            BazelModuleContext ctx = BazelModuleContext.of(m4);
            if (!set.add(ctx.label())) continue;
            PackageFactory.transitiveClosureOfLabelsRec(set, ctx.loads());
        }
    }

    public static boolean checkBuildSyntax(StarlarkFile file, final Collection<String> globs, final Collection<String> globsWithDirs, final Collection<String> subpackages, final Map<Location, String> generatorNameByLocation, final Consumer<SyntaxError> errors) {
        final boolean[] success = new boolean[]{true};
        NodeVisitor checker = new NodeVisitor(){

            void error(Location loc, String message) {
                errors.accept(new SyntaxError(loc, message));
                success[0] = false;
            }

            void extractGlobPatterns(CallExpression call) {
                if (call.getFunction() instanceof Identifier) {
                    String functionName = ((Identifier)call.getFunction()).getName();
                    if (!functionName.equals("glob") && !functionName.equals("subpackages")) {
                        return;
                    }
                    Expression excludeDirectories = null;
                    Expression include = null;
                    ImmutableList<Argument> arguments = call.getArguments();
                    for (int i = 0; i < arguments.size(); ++i) {
                        Argument arg = (Argument)arguments.get(i);
                        String name = arg.getName();
                        if (name == null) {
                            if (i != 0) continue;
                            include = arg.getValue();
                            continue;
                        }
                        if (name.equals("include")) {
                            include = arg.getValue();
                            continue;
                        }
                        if (!name.equals("exclude_directories")) continue;
                        excludeDirectories = arg.getValue();
                    }
                    if (include instanceof ListExpression) {
                        for (Expression elem : ((ListExpression)include).getElements()) {
                            Number v;
                            if (!(elem instanceof StringLiteral)) continue;
                            String pattern = ((StringLiteral)elem).getValue();
                            boolean exclude = true;
                            if (excludeDirectories instanceof IntLiteral && (v = ((IntLiteral)excludeDirectories).getValue()) instanceof Integer && (Integer)v == 0) {
                                exclude = false;
                            }
                            if (functionName.equals("glob")) {
                                (exclude ? globs : globsWithDirs).add(pattern);
                                continue;
                            }
                            subpackages.add(pattern);
                        }
                    }
                }
            }

            void rejectStarArgs(CallExpression call) {
                for (Argument arg : call.getArguments()) {
                    if (arg instanceof Argument.StarStar) {
                        this.error(arg.getStartLocation(), "**kwargs arguments are not allowed in BUILD files. Pass the arguments in explicitly.");
                        continue;
                    }
                    if (!(arg instanceof Argument.Star)) continue;
                    this.error(arg.getStartLocation(), "*args arguments are not allowed in BUILD files. Pass the arguments in explicitly.");
                }
            }

            void recordGeneratorName(CallExpression call) {
                for (Argument arg : call.getArguments()) {
                    if (!(arg instanceof Argument.Keyword) || !arg.getName().equals("name") || !(arg.getValue() instanceof StringLiteral)) continue;
                    generatorNameByLocation.put(call.getLparenLocation(), ((StringLiteral)arg.getValue()).getValue());
                }
            }

            @Override
            public void visit(DefStatement node) {
                this.error(node.getStartLocation(), "functions may not be defined in BUILD files. You may move the function to a .bzl file and load it.");
            }

            @Override
            public void visit(LambdaExpression node) {
                this.error(node.getStartLocation(), "functions may not be defined in BUILD files. You may move the function to a .bzl file and load it.");
            }

            @Override
            public void visit(ForStatement node) {
                this.error(node.getStartLocation(), "for statements are not allowed in BUILD files. You may inline the loop, move it to a function definition (in a .bzl file), or as a last resort use a list comprehension.");
            }

            @Override
            public void visit(IfStatement node) {
                this.error(node.getStartLocation(), "if statements are not allowed in BUILD files. You may move conditional logic to a function definition (in a .bzl file), or for simple cases use an if expression.");
            }

            @Override
            public void visit(CallExpression node) {
                this.extractGlobPatterns(node);
                this.rejectStarArgs(node);
                this.recordGeneratorName(node);
                super.visit(node);
            }
        };
        checker.visit(file);
        return success[0];
    }

    static {
        StarlarkFile.setParseProfiler(new StarlarkFile.ParseProfiler(){

            @Override
            public Object start(String filename) {
                return Profiler.instance().profile(ProfilerTask.STARLARK_PARSER, filename);
            }

            @Override
            public void end(Object span) {
                ((SilentCloseable)span).close();
            }
        });
        StarlarkThread.setCallProfiler(new StarlarkThread.CallProfiler(){

            @Override
            public Object start(StarlarkCallable fn) {
                return Profiler.instance().profile(fn instanceof StarlarkFunction ? ProfilerTask.STARLARK_USER_FN : ProfilerTask.STARLARK_BUILTIN_FN, fn.getName());
            }

            @Override
            public void end(Object span) {
                ((SilentCloseable)span).close();
            }
        });
    }

    public static class PackageContext {
        final Package.Builder pkgBuilder;
        final Globber globber;
        final ExtendedEventHandler eventHandler;

        @VisibleForTesting
        public PackageContext(Package.Builder pkgBuilder, Globber globber, ExtendedEventHandler eventHandler) {
            this.pkgBuilder = pkgBuilder;
            this.eventHandler = eventHandler;
            this.globber = globber;
        }

        public Label getLabel() {
            return this.pkgBuilder.getBuildFileLabel();
        }

        public void setMakeVariable(String name, String value) {
            this.pkgBuilder.setMakeVariable(name, value);
        }

        public Package.Builder getBuilder() {
            return this.pkgBuilder;
        }

        public ExtendedEventHandler getEventHandler() {
            return this.eventHandler;
        }
    }

    @VisibleForTesting
    public static abstract class BuilderForTesting {
        protected PackageValidator packageValidator = PackageValidator.NOOP_VALIDATOR;
        protected PackageOverheadEstimator packageOverheadEstimator = PackageOverheadEstimator.NOOP_ESTIMATOR;
        protected boolean doChecksForTesting = true;

        @CanIgnoreReturnValue
        public BuilderForTesting disableChecks() {
            this.doChecksForTesting = false;
            return this;
        }

        @CanIgnoreReturnValue
        public BuilderForTesting setPackageValidator(PackageValidator packageValidator) {
            this.packageValidator = packageValidator;
            return this;
        }

        @CanIgnoreReturnValue
        public BuilderForTesting setPackageOverheadEstimator(PackageOverheadEstimator packageOverheadEstimator) {
            this.packageOverheadEstimator = packageOverheadEstimator;
            return this;
        }

        public abstract PackageFactory build(RuleClassProvider var1, FileSystem var2);
    }

    public static interface EnvironmentExtension {
        public void update(ImmutableMap.Builder<String, Object> var1);

        public Iterable<PackageArgument<?>> getPackageArguments();
    }
}

