/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Interner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.devtools.build.lib.analysis.config.FeatureSet;
import com.google.devtools.build.lib.bugreport.BugReport;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.cmdline.LabelConstants;
import com.google.devtools.build.lib.cmdline.LabelSyntaxException;
import com.google.devtools.build.lib.cmdline.PackageIdentifier;
import com.google.devtools.build.lib.cmdline.RepositoryMapping;
import com.google.devtools.build.lib.cmdline.RepositoryName;
import com.google.devtools.build.lib.cmdline.TargetPattern;
import com.google.devtools.build.lib.collect.CollectionUtils;
import com.google.devtools.build.lib.events.Event;
import com.google.devtools.build.lib.events.EventHandler;
import com.google.devtools.build.lib.events.EventKind;
import com.google.devtools.build.lib.events.ExtendedEventHandler;
import com.google.devtools.build.lib.packages.AggregatingAttributeMapper;
import com.google.devtools.build.lib.packages.Attribute;
import com.google.devtools.build.lib.packages.CallStack;
import com.google.devtools.build.lib.packages.EnvironmentGroup;
import com.google.devtools.build.lib.packages.FileTarget;
import com.google.devtools.build.lib.packages.InputFile;
import com.google.devtools.build.lib.packages.LabelConverter;
import com.google.devtools.build.lib.packages.License;
import com.google.devtools.build.lib.packages.NoSuchPackageException;
import com.google.devtools.build.lib.packages.NoSuchTargetException;
import com.google.devtools.build.lib.packages.OutputFile;
import com.google.devtools.build.lib.packages.PackageCodecDependencies;
import com.google.devtools.build.lib.packages.PackageGroup;
import com.google.devtools.build.lib.packages.PrivateVisibilityInputFile;
import com.google.devtools.build.lib.packages.Rule;
import com.google.devtools.build.lib.packages.RuleClass;
import com.google.devtools.build.lib.packages.RuleVisibility;
import com.google.devtools.build.lib.packages.SnapshottableBiMap;
import com.google.devtools.build.lib.packages.Target;
import com.google.devtools.build.lib.packages.TestSuiteImplicitTestsAccumulator;
import com.google.devtools.build.lib.packages.VisibilityLicenseSpecifiedInputFile;
import com.google.devtools.build.lib.server.FailureDetails;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.devtools.build.lib.util.DetailedExitCode;
import com.google.devtools.build.lib.vfs.Path;
import com.google.devtools.build.lib.vfs.PathFragment;
import com.google.devtools.build.lib.vfs.Root;
import com.google.devtools.build.lib.vfs.RootedPath;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.starlark.java.eval.Module;
import net.starlark.java.eval.StarlarkSemantics;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.spelling.SpellChecker;
import net.starlark.java.syntax.Location;

public class Package {
    private static final String DUMMY_WORKSPACE_NAME_FOR_BZLMOD_PACKAGES = "__dummy_workspace_bzlmod";
    private final PackageIdentifier packageIdentifier;
    private final boolean succinctTargetNotFoundErrors;
    private RootedPath filename;
    private Path packageDirectory;
    private String workspaceName;
    private final Optional<String> associatedModuleName;
    private final Optional<String> associatedModuleVersion;
    private Optional<Root> sourceRoot;
    private ImmutableMap<String, String> makeEnv;
    private ImmutableSortedMap<String, Target> targets;
    private RuleVisibility defaultVisibility;
    private boolean defaultVisibilitySet;
    private ConfigSettingVisibilityPolicy configSettingVisibilityPolicy;
    private boolean defaultTestOnly = false;
    private String defaultDeprecation;
    private String defaultHdrsCheck;
    private InputFile buildFile;
    private boolean containsErrors;
    @Nullable
    private FailureDetails.FailureDetail failureDetail;
    private ImmutableList<Label> starlarkFileDependencies;
    private ImmutableSet<Label> defaultPackageMetadata = ImmutableSet.of();
    private License defaultLicense;
    private Set<License.DistributionType> defaultDistributionSet;
    private ImmutableMap<RepositoryName, ImmutableMap<String, RepositoryName>> externalPackageRepositoryMappings;
    private RepositoryMapping repositoryMapping;
    private RepositoryMapping mainRepositoryMapping;
    private Set<Label> defaultCompatibleWith = ImmutableSet.of();
    private Set<Label> defaultRestrictedTo = ImmutableSet.of();
    private FeatureSet features;
    private ImmutableList<TargetPattern> registeredExecutionPlatforms;
    private ImmutableList<TargetPattern> registeredToolchains;
    private long computationSteps;
    private ImmutableMap<String, Module> loads;

    public long getComputationSteps() {
        return this.computationSteps;
    }

    @Nullable
    public ImmutableMap<String, Module> getLoads() {
        return this.loads;
    }

    private Package(PackageIdentifier packageId, String workspaceName, Optional<String> associatedModuleName, Optional<String> associatedModuleVersion, boolean succinctTargetNotFoundErrors) {
        this.packageIdentifier = packageId;
        this.workspaceName = workspaceName;
        this.associatedModuleName = associatedModuleName;
        this.associatedModuleVersion = associatedModuleVersion;
        this.succinctTargetNotFoundErrors = succinctTargetNotFoundErrors;
    }

    public PackageIdentifier getPackageIdentifier() {
        return this.packageIdentifier;
    }

    private boolean isRepoRulePackage() {
        return this.packageIdentifier.equals(LabelConstants.EXTERNAL_PACKAGE_IDENTIFIER) || this.workspaceName.equals(DUMMY_WORKSPACE_NAME_FOR_BZLMOD_PACKAGES);
    }

    public ImmutableMap<String, RepositoryName> getRepositoryMapping(RepositoryName repository) {
        if (!this.isRepoRulePackage()) {
            throw new UnsupportedOperationException("Can only access the external package repositorymappings from the //external package");
        }
        return this.externalPackageRepositoryMappings.getOrDefault(repository, ImmutableMap.of());
    }

    public RepositoryMapping getRepositoryMapping() {
        return this.repositoryMapping;
    }

    ImmutableMap<RepositoryName, ImmutableMap<String, RepositoryName>> getExternalPackageRepositoryMappings() {
        if (!this.isRepoRulePackage()) {
            throw new UnsupportedOperationException("Can only access the external package repositorymappings from the //external package");
        }
        return this.externalPackageRepositoryMappings;
    }

    private void setDefaultHdrsCheck(String defaultHdrsCheck) {
        this.defaultHdrsCheck = defaultHdrsCheck;
    }

    private void setDefaultTestOnly(boolean testOnly) {
        this.defaultTestOnly = testOnly;
    }

    private void setDefaultDeprecation(String deprecation) {
        this.defaultDeprecation = deprecation;
    }

    private void setDefaultCompatibleWith(Set<Label> environments) {
        this.defaultCompatibleWith = environments;
    }

    private void setDefaultRestrictedTo(Set<Label> environments) {
        this.defaultRestrictedTo = environments;
    }

    public Optional<Root> getSourceRoot() {
        return this.sourceRoot;
    }

    private static Root getSourceRoot(RootedPath buildFileRootedPath, PathFragment packageFragment) {
        PathFragment packageDirectory = buildFileRootedPath.getRootRelativePath().getParentDirectory();
        if (packageFragment.equals(packageDirectory)) {
            return buildFileRootedPath.getRoot();
        }
        PathFragment current = buildFileRootedPath.asPath().asFragment().getParentDirectory();
        int len = packageFragment.segmentCount();
        for (int i = 0; i < len && current != null; current = current.getParentDirectory(), ++i) {
        }
        if (current == null || current.isEmpty()) {
            return buildFileRootedPath.getRoot();
        }
        return Root.fromPath(buildFileRootedPath.getRoot().getRelative(current));
    }

    private void finishInit(Builder builder) {
        this.filename = builder.getFilename();
        this.packageDirectory = this.filename.asPath().getParentDirectory();
        String baseName = this.filename.getRootRelativePath().getBaseName();
        if (Package.isWorkspaceFile(baseName) || Package.isModuleDotBazelFile(baseName)) {
            Preconditions.checkState(this.isRepoRulePackage());
            this.sourceRoot = Optional.empty();
        } else {
            Root sourceRoot = Package.getSourceRoot(this.filename, this.packageIdentifier.getSourceRoot());
            if (sourceRoot.asPath() == null || !sourceRoot.getRelative(this.packageIdentifier.getSourceRoot()).equals(this.packageDirectory)) {
                throw new IllegalArgumentException("Invalid BUILD file name for package '" + this.packageIdentifier + "': " + this.filename + " (in source " + sourceRoot + " with packageDirectory " + this.packageDirectory + " and package identifier source root " + this.packageIdentifier.getSourceRoot() + ")");
            }
            this.sourceRoot = Optional.of(sourceRoot);
        }
        this.makeEnv = ImmutableMap.copyOf(builder.makeEnv);
        this.targets = ImmutableSortedMap.copyOf(builder.targets);
        this.defaultVisibility = builder.defaultVisibility;
        this.defaultVisibilitySet = builder.defaultVisibilitySet;
        this.configSettingVisibilityPolicy = builder.configSettingVisibilityPolicy;
        this.buildFile = builder.buildFile;
        this.containsErrors |= builder.containsErrors;
        this.failureDetail = builder.getFailureDetail();
        this.starlarkFileDependencies = builder.starlarkFileDependencies;
        this.defaultLicense = builder.defaultLicense;
        this.defaultDistributionSet = builder.defaultDistributionSet;
        this.defaultPackageMetadata = ImmutableSortedSet.copyOf(builder.defaultPackageMetadata);
        this.features = builder.features;
        this.registeredExecutionPlatforms = ImmutableList.copyOf(builder.registeredExecutionPlatforms);
        this.registeredToolchains = ImmutableList.copyOf(builder.registeredToolchains);
        this.repositoryMapping = Preconditions.checkNotNull(builder.repositoryMapping);
        this.mainRepositoryMapping = Preconditions.checkNotNull(builder.mainRepositoryMapping);
        ImmutableMap.Builder repositoryMappingsBuilder = ImmutableMap.builder();
        if (!builder.externalPackageRepositoryMappings.isEmpty() && !builder.isRepoRulePackage()) {
            throw new IllegalArgumentException("'repo_mapping' may only be used in the //external package");
        }
        builder.externalPackageRepositoryMappings.forEach((k, v) -> repositoryMappingsBuilder.put(k, ImmutableMap.copyOf(v)));
        this.externalPackageRepositoryMappings = repositoryMappingsBuilder.buildOrThrow();
    }

    private static boolean isWorkspaceFile(String baseFileName) {
        return baseFileName.equals(LabelConstants.WORKSPACE_DOT_BAZEL_FILE_NAME.getPathString()) || baseFileName.equals(LabelConstants.WORKSPACE_FILE_NAME.getPathString());
    }

    private static boolean isModuleDotBazelFile(String baseFileName) {
        return baseFileName.equals(LabelConstants.MODULE_DOT_BAZEL_FILE_NAME.getPathString());
    }

    public ImmutableList<Label> getStarlarkFileDependencies() {
        return this.starlarkFileDependencies;
    }

    public RootedPath getFilename() {
        return this.filename;
    }

    public Path getPackageDirectory() {
        return this.packageDirectory;
    }

    public String getName() {
        return this.packageIdentifier.getPackageFragment().getPathString();
    }

    public PathFragment getNameFragment() {
        return this.packageIdentifier.getPackageFragment();
    }

    public ImmutableMap<String, String> getMakeEnvironment() {
        return this.makeEnv;
    }

    public Label getBuildFileLabel() {
        return this.buildFile.getLabel();
    }

    public InputFile getBuildFile() {
        return this.buildFile;
    }

    public boolean containsErrors() {
        return this.containsErrors;
    }

    void setContainsErrors() {
        this.containsErrors = true;
    }

    @Nullable
    public FailureDetails.FailureDetail getFailureDetail() {
        return this.failureDetail;
    }

    public FailureDetails.FailureDetail contextualizeFailureDetailForTarget(Target target) {
        Preconditions.checkState(target.getPackage().packageIdentifier.equals(this.packageIdentifier), "contextualizeFailureDetailForTarget called for target not in package. target=%s, package=%s", (Object)target, (Object)this);
        Preconditions.checkState(this.containsErrors, "contextualizeFailureDetailForTarget called for package not in error. target=%s", (Object)target);
        String prefix = "Target '" + target.getLabel() + "' contains an error and its package is in error";
        if (this.failureDetail == null) {
            return FailureDetails.FailureDetail.newBuilder().setMessage(prefix).setPackageLoading(FailureDetails.PackageLoading.newBuilder().setCode(FailureDetails.PackageLoading.Code.TARGET_MISSING)).build();
        }
        return this.failureDetail.toBuilder().setMessage(prefix + ": " + this.failureDetail.getMessage()).build();
    }

    public ImmutableSortedMap<String, Target> getTargets() {
        return this.targets;
    }

    private static Set<Target> getTargets(BiMap<String, Target> targetMap) {
        return targetMap.values();
    }

    public <T extends Target> Iterable<T> getTargets(Class<T> targetClass) {
        return Package.getTargets(this.targets, targetClass);
    }

    private static <T extends Target> Iterable<T> getTargets(Map<String, Target> targetMap, Class<T> targetClass) {
        return Iterables.filter(targetMap.values(), targetClass);
    }

    public Rule getRule(String targetName) {
        return (Rule)this.targets.get(targetName);
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public FeatureSet getFeatures() {
        return this.features;
    }

    public Target getTarget(String targetName) throws NoSuchTargetException {
        Label label;
        Target target = this.targets.get(targetName);
        if (target != null) {
            return target;
        }
        try {
            label = Label.create(this.packageIdentifier, targetName);
        }
        catch (LabelSyntaxException e) {
            throw new IllegalArgumentException(targetName, e);
        }
        if (this.succinctTargetNotFoundErrors) {
            throw new NoSuchTargetException(label, String.format("target '%s' not declared in package '%s'", targetName, this.getName()));
        }
        String alternateTargetSuggestion = this.getAlternateTargetSuggestion(targetName);
        throw new NoSuchTargetException(label, String.format("target '%s' not declared in package '%s' defined by %s%s", targetName, this.getName(), this.filename.asPath().getPathString(), alternateTargetSuggestion));
    }

    private String getAlternateTargetSuggestion(String targetName) {
        Path filename = this.packageDirectory.getRelative(targetName);
        if (!PathFragment.isNormalized(targetName) || "*".equals(targetName)) {
            return "";
        }
        if (filename.isDirectory()) {
            return "; however, a source directory of this name exists.  (Perhaps add 'exports_files([\"" + targetName + "\"])' to " + this.getName() + "/BUILD, or define a filegroup?)";
        }
        if (filename.exists()) {
            return "; however, a source file of this name exists.  (Perhaps add 'exports_files([\"" + targetName + "\"])' to " + this.getName() + "/BUILD?)";
        }
        String suggestedTarget = SpellChecker.suggest(targetName, this.targets.keySet());
        String targetSuggestion = suggestedTarget == null ? null : String.format("did you mean '%s'?", suggestedTarget);
        String blazeQuerySuggestion = String.format("Tip: use `query \"%s:*\"` to see all the targets in that package", this.packageIdentifier.getDisplayForm(this.mainRepositoryMapping));
        return String.format(" (%s)", Joiner.on(" ").skipNulls().join(targetSuggestion, blazeQuerySuggestion, new Object[0]));
    }

    public RuleVisibility getDefaultVisibility() {
        return this.defaultVisibility;
    }

    public ConfigSettingVisibilityPolicy getConfigSettingVisibilityPolicy() {
        return this.configSettingVisibilityPolicy;
    }

    public Boolean getDefaultTestOnly() {
        return this.defaultTestOnly;
    }

    public String getDefaultDeprecation() {
        return this.defaultDeprecation;
    }

    public String getDefaultHdrsCheck() {
        return this.defaultHdrsCheck != null ? this.defaultHdrsCheck : "strict";
    }

    public boolean isDefaultHdrsCheckSet() {
        return this.defaultHdrsCheck != null;
    }

    public boolean isDefaultVisibilitySet() {
        return this.defaultVisibilitySet;
    }

    Set<Label> getDefaultPackageMetadata() {
        return this.defaultPackageMetadata;
    }

    License getDefaultLicense() {
        return this.defaultLicense;
    }

    Set<License.DistributionType> getDefaultDistribs() {
        return this.defaultDistributionSet;
    }

    public Set<Label> getDefaultCompatibleWith() {
        return this.defaultCompatibleWith;
    }

    public Set<Label> getDefaultRestrictedTo() {
        return this.defaultRestrictedTo;
    }

    public ImmutableList<TargetPattern> getRegisteredExecutionPlatforms() {
        return this.registeredExecutionPlatforms;
    }

    public ImmutableList<TargetPattern> getRegisteredToolchains() {
        return this.registeredToolchains;
    }

    public String toString() {
        return "Package(" + this.getName() + ")=" + (this.targets != null ? this.getTargets(Rule.class) : "initializing...");
    }

    public void dump(PrintStream out) {
        out.println("  Package " + this.getName() + " (" + this.filename.asPath() + ")");
        out.println("    Rules");
        for (Rule rule : this.getTargets(Rule.class)) {
            out.println("      " + rule.getTargetKind() + " " + rule.getLabel());
            for (Attribute attr : rule.getAttributes()) {
                for (Object possibleValue : AggregatingAttributeMapper.of(rule).visitAttribute(attr.getName(), attr.getType())) {
                    out.println("        " + attr.getName() + " = " + possibleValue);
                }
            }
        }
        out.println("    Files");
        for (FileTarget file : this.getTargets(FileTarget.class)) {
            out.print("      " + file.getTargetKind() + " " + file.getLabel());
            if (file instanceof OutputFile) {
                out.println(" (generated by " + ((OutputFile)file).getGeneratingRule().getLabel() + ")");
                continue;
            }
            out.println();
        }
    }

    public static Builder newExternalPackageBuilder(Builder.PackageSettings helper, RootedPath workspacePath, String workspaceName, RepositoryMapping mainRepoMapping, StarlarkSemantics starlarkSemantics) {
        return new Builder(helper, LabelConstants.EXTERNAL_PACKAGE_IDENTIFIER, workspaceName, Optional.empty(), Optional.empty(), starlarkSemantics.getBool("-incompatible_no_implicit_file_export"), mainRepoMapping, mainRepoMapping).setFilename(workspacePath);
    }

    public static Builder newExternalPackageBuilderForBzlmod(RootedPath moduleFilePath, StarlarkSemantics starlarkSemantics, PackageIdentifier basePackageId, RepositoryMapping repoMapping) {
        return new Builder(Builder.DefaultPackageSettings.INSTANCE, basePackageId, DUMMY_WORKSPACE_NAME_FOR_BZLMOD_PACKAGES, Optional.empty(), Optional.empty(), starlarkSemantics.getBool("-incompatible_no_implicit_file_export"), repoMapping, RepositoryMapping.ALWAYS_FALLBACK).setFilename(moduleFilePath);
    }

    public static Event error(Location location, String message, FailureDetails.PackageLoading.Code code) {
        Event error = Event.error(location, message);
        return error.withProperty(DetailedExitCode.class, Package.createDetailedCode(message, code));
    }

    private static DetailedExitCode createDetailedCode(String errorMessage, FailureDetails.PackageLoading.Code code) {
        return DetailedExitCode.of(FailureDetails.FailureDetail.newBuilder().setMessage(errorMessage).setPackageLoading(FailureDetails.PackageLoading.newBuilder().setCode(code)).build());
    }

    @VisibleForTesting
    static final class PackageCodec
    implements ObjectCodec<Package> {
        PackageCodec() {
        }

        @Override
        public Class<Package> getEncodedClass() {
            return Package.class;
        }

        @Override
        public void serialize(SerializationContext context, Package input, CodedOutputStream codedOut) throws IOException, SerializationException {
            context.checkClassExplicitlyAllowed(Package.class, input);
            PackageCodecDependencies codecDeps = context.getDependency(PackageCodecDependencies.class);
            codecDeps.getPackageSerializer().serialize(context, input, codedOut);
        }

        @Override
        public Package deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
            PackageCodecDependencies codecDeps = context.getDependency(PackageCodecDependencies.class);
            return codecDeps.getPackageSerializer().deserialize(context, codedIn);
        }
    }

    public static class Builder {
        private final Package pkg;
        private final boolean noImplicitFileExport;
        private final HashMap<RepositoryName, HashMap<String, RepositoryName>> externalPackageRepositoryMappings = new HashMap();
        private final RepositoryMapping repositoryMapping;
        private final RepositoryMapping mainRepositoryMapping;
        private final LabelConverter labelConverter;
        private RootedPath filename = null;
        private Label buildFileLabel = null;
        private InputFile buildFile = null;
        private final TreeMap<String, String> makeEnv = new TreeMap();
        private RuleVisibility defaultVisibility = RuleVisibility.PRIVATE;
        private ConfigSettingVisibilityPolicy configSettingVisibilityPolicy;
        private boolean defaultVisibilitySet;
        private FeatureSet features = FeatureSet.EMPTY;
        private final List<Event> events = Lists.newArrayList();
        private final List<ExtendedEventHandler.Postable> posts = Lists.newArrayList();
        @Nullable
        private String ioExceptionMessage = null;
        @Nullable
        private IOException ioException = null;
        @Nullable
        private DetailedExitCode ioExceptionDetailedExitCode = null;
        private boolean containsErrors = false;
        @Nullable
        private FailureDetails.FailureDetail failureDetailOverride = null;
        private ImmutableList<Label> defaultPackageMetadata = ImmutableList.of();
        private License defaultLicense = License.NO_LICENSE;
        private Set<License.DistributionType> defaultDistributionSet = License.DEFAULT_DISTRIB;
        private BiMap<String, Target> targets = new SnapshottableBiMap<String, Target>(target -> target instanceof Rule);
        private final Map<Label, EnvironmentGroup> environmentGroups = new HashMap<Label, EnvironmentGroup>();
        @Nullable
        private Map<Rule, List<Label>> ruleLabels = null;
        private ImmutableList<Label> starlarkFileDependencies = ImmutableList.of();
        private final List<TargetPattern> registeredExecutionPlatforms = new ArrayList<TargetPattern>();
        private final List<TargetPattern> registeredToolchains = new ArrayList<TargetPattern>();
        private boolean packageFunctionUsed;
        private final Map<String, OutputFile> outputFilePrefixes = new HashMap<String, OutputFile>();
        private final Interner<ImmutableList<?>> listInterner = new ThreadCompatibleInterner();
        private ImmutableMap<Location, String> generatorMap = ImmutableMap.of();
        private final TestSuiteImplicitTestsAccumulator testSuiteImplicitTestsAccumulator = new TestSuiteImplicitTestsAccumulator();
        private boolean alreadyBuilt = false;

        @Nullable
        String getGeneratorNameByLocation(Location loc) {
            return this.generatorMap.get(loc);
        }

        @CanIgnoreReturnValue
        public Builder setGeneratorMap(ImmutableMap<Location, String> map) {
            this.generatorMap = map;
            return this;
        }

        List<Label> getTestSuiteImplicitTestsRef(List<String> tags) {
            return this.testSuiteImplicitTestsAccumulator.getTestSuiteImplicitTestsRefForTags(tags);
        }

        Builder(PackageSettings packageSettings, PackageIdentifier id, String workspaceName, Optional<String> associatedModuleName, Optional<String> associatedModuleVersion, boolean noImplicitFileExport, RepositoryMapping repositoryMapping, RepositoryMapping mainRepositoryMapping) {
            this.pkg = new Package(id, workspaceName, associatedModuleName, associatedModuleVersion, packageSettings.succinctTargetNotFoundErrors());
            this.noImplicitFileExport = noImplicitFileExport;
            this.repositoryMapping = repositoryMapping;
            this.mainRepositoryMapping = mainRepositoryMapping;
            this.labelConverter = new LabelConverter(id, repositoryMapping);
            if (this.pkg.getName().startsWith("javatests/")) {
                this.setDefaultTestonly(true);
            }
        }

        PackageIdentifier getPackageIdentifier() {
            return this.pkg.getPackageIdentifier();
        }

        boolean isRepoRulePackage() {
            return this.pkg.isRepoRulePackage();
        }

        String getPackageWorkspaceName() {
            return this.pkg.getWorkspaceName();
        }

        Optional<String> getAssociatedModuleName() {
            return this.pkg.associatedModuleName;
        }

        Optional<String> getAssociatedModuleVersion() {
            return this.pkg.associatedModuleVersion;
        }

        @CanIgnoreReturnValue
        Builder addRepositoryMappingEntry(RepositoryName repoWithin, String localName, RepositoryName mappedName) {
            HashMap mapping = this.externalPackageRepositoryMappings.computeIfAbsent(repoWithin, k -> new HashMap());
            mapping.put(localName, mappedName);
            return this;
        }

        @CanIgnoreReturnValue
        Builder addRepositoryMappings(Package aPackage) {
            ImmutableMap<RepositoryName, ImmutableMap<String, RepositoryName>> repositoryMappings = aPackage.externalPackageRepositoryMappings;
            for (Map.Entry repositoryName : repositoryMappings.entrySet()) {
                for (Map.Entry repositoryNameRepositoryNameEntry : ((ImmutableMap)repositoryName.getValue()).entrySet()) {
                    this.addRepositoryMappingEntry((RepositoryName)repositoryName.getKey(), (String)repositoryNameRepositoryNameEntry.getKey(), (RepositoryName)repositoryNameRepositoryNameEntry.getValue());
                }
            }
            return this;
        }

        public LabelConverter getLabelConverter() {
            return this.labelConverter;
        }

        Interner<ImmutableList<?>> getListInterner() {
            return this.listInterner;
        }

        @CanIgnoreReturnValue
        public Builder setFilename(RootedPath filename) {
            this.filename = filename;
            try {
                this.buildFileLabel = this.createLabel(filename.getRootRelativePath().getBaseName());
                this.addInputFile(this.buildFileLabel, Location.fromFile(filename.asPath().toString()));
            }
            catch (LabelSyntaxException e) {
                throw new AssertionError((Object)("Package BUILD file has an illegal name: " + filename));
            }
            return this;
        }

        Label getBuildFileLabel() {
            return this.buildFileLabel;
        }

        RepositoryMapping getRepositoryMappingFor(RepositoryName name) {
            Map mapping = this.externalPackageRepositoryMappings.get(name);
            if (mapping == null) {
                return RepositoryMapping.ALWAYS_FALLBACK;
            }
            return RepositoryMapping.createAllowingFallback(mapping);
        }

        RootedPath getFilename() {
            return this.filename;
        }

        public List<ExtendedEventHandler.Postable> getPosts() {
            return this.posts;
        }

        public List<Event> getEvents() {
            return this.events;
        }

        @CanIgnoreReturnValue
        Builder setMakeVariable(String name, String value) {
            this.makeEnv.put(name, value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setDefaultVisibility(RuleVisibility visibility) {
            this.defaultVisibility = visibility;
            this.defaultVisibilitySet = true;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setDefaultVisibilitySet(boolean defaultVisibilitySet) {
            this.defaultVisibilitySet = defaultVisibilitySet;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setConfigSettingVisibilityPolicy(ConfigSettingVisibilityPolicy policy) {
            this.configSettingVisibilityPolicy = policy;
            return this;
        }

        @CanIgnoreReturnValue
        Builder setDefaultTestonly(boolean defaultTestonly) {
            this.pkg.setDefaultTestOnly(defaultTestonly);
            return this;
        }

        @CanIgnoreReturnValue
        Builder setDefaultDeprecation(String defaultDeprecation) {
            this.pkg.setDefaultDeprecation(defaultDeprecation);
            return this;
        }

        @CanIgnoreReturnValue
        @VisibleForTesting
        public Builder setWorkspaceName(String workspaceName) {
            this.pkg.workspaceName = workspaceName;
            return this;
        }

        boolean isPackageFunctionUsed() {
            return this.packageFunctionUsed;
        }

        void setPackageFunctionUsed() {
            this.packageFunctionUsed = true;
        }

        void setComputationSteps(long n) {
            this.pkg.computationSteps = n;
        }

        void setLoads(ImmutableMap<String, Module> loads) {
            this.pkg.loads = Preconditions.checkNotNull(loads);
        }

        @CanIgnoreReturnValue
        public Builder setDefaultHdrsCheck(String hdrsCheck) {
            this.pkg.setDefaultHdrsCheck(hdrsCheck);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addFeatures(Iterable<String> features) {
            this.features = FeatureSet.merge(this.features, FeatureSet.parse(features));
            return this;
        }

        Builder setIOException(IOException e, String message, DetailedExitCode detailedExitCode) {
            this.ioException = e;
            this.ioExceptionMessage = message;
            this.ioExceptionDetailedExitCode = detailedExitCode;
            return this.setContainsErrors();
        }

        @CanIgnoreReturnValue
        public Builder setContainsErrors() {
            this.containsErrors = true;
            return this;
        }

        public boolean containsErrors() {
            return this.containsErrors;
        }

        @CanIgnoreReturnValue
        Builder addPosts(Iterable<ExtendedEventHandler.Postable> posts) {
            for (ExtendedEventHandler.Postable post : posts) {
                this.posts.add(post);
            }
            return this;
        }

        @CanIgnoreReturnValue
        Builder addEvents(Iterable<Event> events) {
            for (Event event : events) {
                this.addEvent(event);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addEvent(Event event) {
            this.events.add(event);
            return this;
        }

        void setFailureDetailOverride(FailureDetails.FailureDetail failureDetail) {
            this.failureDetailOverride = failureDetail;
        }

        @Nullable
        FailureDetails.FailureDetail getFailureDetail() {
            if (this.failureDetailOverride != null) {
                return this.failureDetailOverride;
            }
            ArrayList<Event> undetailedEvents = null;
            for (Event event : this.events) {
                if (event.getKind() != EventKind.ERROR) continue;
                DetailedExitCode detailedExitCode = event.getProperty(DetailedExitCode.class);
                if (detailedExitCode != null && detailedExitCode.getFailureDetail() != null) {
                    return detailedExitCode.getFailureDetail();
                }
                if (!this.containsErrors) continue;
                if (undetailedEvents == null) {
                    undetailedEvents = new ArrayList<Event>();
                }
                undetailedEvents.add(event);
            }
            if (undetailedEvents != null) {
                BugReport.sendBugReport(new IllegalStateException("Package has undetailed error from " + undetailedEvents));
            }
            return null;
        }

        @CanIgnoreReturnValue
        public Builder setStarlarkFileDependencies(ImmutableList<Label> starlarkFileDependencies) {
            this.starlarkFileDependencies = starlarkFileDependencies;
            return this;
        }

        void setDefaultPackageMetadata(List<Label> licenses, String attrName, Location location) {
            if (Builder.hasDuplicateLabels(licenses, "package " + this.pkg.getName(), attrName, location, this::addEvent)) {
                this.setContainsErrors();
            }
            this.defaultPackageMetadata = ImmutableList.copyOf(licenses);
        }

        ImmutableList<Label> getDefaultPackageMetadata() {
            return this.defaultPackageMetadata;
        }

        void setDefaultLicense(License license) {
            this.defaultLicense = license;
        }

        License getDefaultLicense() {
            return this.defaultLicense;
        }

        void setDefaultDistribs(Set<License.DistributionType> dists) {
            this.defaultDistributionSet = dists;
        }

        Set<License.DistributionType> getDefaultDistribs() {
            return this.defaultDistributionSet;
        }

        void setDefaultCompatibleWith(List<Label> environments, String attrName, Location location) {
            if (Builder.hasDuplicateLabels(environments, "package " + this.pkg.getName(), attrName, location, this::addEvent)) {
                this.setContainsErrors();
            }
            this.pkg.setDefaultCompatibleWith(ImmutableSet.copyOf(environments));
        }

        void setDefaultRestrictedTo(List<Label> environments, String attrName, Location location) {
            if (Builder.hasDuplicateLabels(environments, "package " + this.pkg.getName(), attrName, location, this::addEvent)) {
                this.setContainsErrors();
            }
            this.pkg.setDefaultRestrictedTo(ImmutableSet.copyOf(environments));
        }

        Rule createRule(Label label, RuleClass ruleClass, List<StarlarkThread.CallStackEntry> callstack) {
            return this.createRule(label, ruleClass, callstack.isEmpty() ? Location.BUILTIN : callstack.get((int)0).location, CallStack.compactInterior(callstack));
        }

        Rule createRule(Label label, RuleClass ruleClass, Location location, @Nullable CallStack.Node interiorCallStack) {
            return new Rule(this.pkg, label, ruleClass, location, interiorCallStack);
        }

        @Nullable
        Target getTarget(String name) {
            return (Target)this.targets.get(name);
        }

        void replaceTarget(Target newTarget) {
            List<Label> ruleLabelsForOldTarget;
            Preconditions.checkArgument(this.targets.containsKey(newTarget.getName()), "No existing target with name '%s' in the targets map", (Object)newTarget.getName());
            Preconditions.checkArgument(newTarget.getPackage() == this.pkg, "Replacement target belongs to package '%s', expected '%s'", (Object)newTarget.getPackage(), (Object)this.pkg);
            Target oldTarget = this.targets.put(newTarget.getName(), newTarget);
            if (newTarget instanceof Rule && this.ruleLabels != null && (ruleLabelsForOldTarget = this.ruleLabels.remove(oldTarget)) != null) {
                this.ruleLabels.put((Rule)newTarget, ruleLabelsForOldTarget);
            }
        }

        public Set<Target> getTargets() {
            return Package.getTargets(this.targets);
        }

        Map<String, Rule> getRulesSnapshotView() {
            if (this.targets instanceof SnapshottableBiMap) {
                return Maps.transformValues(((SnapshottableBiMap)this.targets).getTrackedSnapshot(), target -> (Rule)target);
            }
            throw new IllegalStateException("getRulesSnapshotView() cannot be used after beforeBuild() has been called");
        }

        private Iterable<Rule> getRules() {
            return Package.getTargets(this.targets, Rule.class);
        }

        InputFile createInputFile(String targetName, Location location) throws GeneratedLabelConflict {
            Target existing = (Target)this.targets.get(targetName);
            if (existing == null) {
                try {
                    return this.addInputFile(this.createLabel(targetName), location);
                }
                catch (LabelSyntaxException e) {
                    throw new IllegalArgumentException("FileTarget in package " + this.pkg.getName() + " has illegal name: " + targetName, e);
                }
            }
            if (existing instanceof InputFile) {
                return (InputFile)existing;
            }
            throw new GeneratedLabelConflict("generated label '//" + this.pkg.getName() + ":" + targetName + "' conflicts with existing " + existing.getTargetKind());
        }

        void setVisibilityAndLicense(InputFile inputFile, RuleVisibility visibility, License license) {
            String filename = inputFile.getName();
            Target cacheInstance = (Target)this.targets.get(filename);
            if (!(cacheInstance instanceof InputFile)) {
                throw new IllegalArgumentException("Can't set visibility for nonexistent FileTarget " + filename + " in package " + this.pkg.getName() + ".");
            }
            if (!((InputFile)cacheInstance).isVisibilitySpecified() || cacheInstance.getVisibility() != visibility || !Objects.equals(cacheInstance.getLicense(), license)) {
                this.targets.put(filename, new VisibilityLicenseSpecifiedInputFile(this.pkg, cacheInstance.getLabel(), cacheInstance.getLocation(), visibility, license));
            }
        }

        Label createLabel(String targetName) throws LabelSyntaxException {
            return Label.create(this.pkg.getPackageIdentifier(), targetName);
        }

        void addPackageGroup(String name, Collection<String> packages, Collection<Label> includes, boolean allowPublicPrivate, boolean repoRootMeansCurrentRepo, EventHandler eventHandler, Location location) throws NameConflictException, LabelSyntaxException {
            PackageGroup group = new PackageGroup(this.createLabel(name), this.pkg, packages, includes, allowPublicPrivate, repoRootMeansCurrentRepo, eventHandler, location);
            Target existing = (Target)this.targets.get(group.getName());
            if (existing != null) {
                throw Builder.nameConflict(group, existing);
            }
            this.targets.put(group.getName(), group);
            if (group.containsErrors()) {
                this.setContainsErrors();
            }
        }

        private static boolean hasDuplicateLabels(List<Label> labels, String owner, String attrName, Location location, EventHandler eventHandler) {
            Set<Label> dupes = CollectionUtils.duplicatedElementsOf(labels);
            for (Label dupe : dupes) {
                eventHandler.handle(Package.error(location, String.format("label '%s' is duplicated in the '%s' list of '%s'", dupe, attrName, owner), FailureDetails.PackageLoading.Code.DUPLICATE_LABEL));
            }
            return !dupes.isEmpty();
        }

        void addEnvironmentGroup(String name, List<Label> environments, List<Label> defaults, EventHandler eventHandler, Location location) throws NameConflictException, LabelSyntaxException {
            if (Builder.hasDuplicateLabels(environments, name, "environments", location, eventHandler) || Builder.hasDuplicateLabels(defaults, name, "defaults", location, eventHandler)) {
                this.setContainsErrors();
                return;
            }
            EnvironmentGroup group = new EnvironmentGroup(this.createLabel(name), this.pkg, environments, defaults, location);
            Target existing = (Target)this.targets.get(group.getName());
            if (existing != null) {
                throw Builder.nameConflict(group, existing);
            }
            this.targets.put(group.getName(), group);
            for (Event error : group.validateMembership()) {
                eventHandler.handle(error);
                this.setContainsErrors();
            }
            for (Label environment : group.getEnvironments()) {
                EnvironmentGroup otherGroup = this.environmentGroups.get(environment);
                if (otherGroup != null) {
                    eventHandler.handle(Package.error(location, String.format("environment %s belongs to both %s and %s", environment, group.getLabel(), otherGroup.getLabel()), FailureDetails.PackageLoading.Code.ENVIRONMENT_IN_MULTIPLE_GROUPS));
                    this.setContainsErrors();
                    group.processMemberEnvironments(ImmutableMap.of());
                    continue;
                }
                this.environmentGroups.put(environment, group);
            }
        }

        void addRuleUnchecked(Rule rule) {
            Preconditions.checkArgument(rule.getPackage() == this.pkg);
            for (OutputFile outputFile : rule.getOutputFiles()) {
                this.targets.put(outputFile.getName(), outputFile);
                PathFragment outputFileFragment = PathFragment.create(outputFile.getName());
                int segmentCount = outputFileFragment.segmentCount();
                for (int i = 1; i < segmentCount; ++i) {
                    String prefix = outputFileFragment.subFragment(0, i).toString();
                    this.outputFilePrefixes.putIfAbsent(prefix, outputFile);
                }
            }
            this.targets.put(rule.getName(), rule);
            if (rule.containsErrors()) {
                this.setContainsErrors();
            }
        }

        void addRule(Rule rule) throws NameConflictException {
            List<Label> labels = rule.getLabels();
            this.checkForConflicts(rule, labels);
            this.addRuleUnchecked(rule);
            if (this.ruleLabels == null) {
                this.ruleLabels = new HashMap<Rule, List<Label>>();
            }
            this.ruleLabels.put(rule, labels);
        }

        void addRegisteredExecutionPlatforms(List<TargetPattern> platforms) {
            this.registeredExecutionPlatforms.addAll(platforms);
        }

        void addRegisteredToolchains(List<TargetPattern> toolchains) {
            this.registeredToolchains.addAll(toolchains);
        }

        @CanIgnoreReturnValue
        private Builder beforeBuild(boolean discoverAssumedInputFiles) throws NoSuchPackageException {
            Preconditions.checkNotNull(this.pkg);
            Preconditions.checkNotNull(this.filename);
            Preconditions.checkNotNull(this.buildFileLabel);
            Preconditions.checkNotNull(this.makeEnv);
            if (this.ioException != null) {
                throw new NoSuchPackageException(this.getPackageIdentifier(), this.ioExceptionMessage, this.ioException, this.ioExceptionDetailedExitCode);
            }
            if (this.targets instanceof SnapshottableBiMap) {
                this.targets = ((SnapshottableBiMap)this.targets).getUnderlyingBiMap();
            }
            this.buildFile = (InputFile)Preconditions.checkNotNull((Target)this.targets.get(this.buildFileLabel.getName()));
            this.testSuiteImplicitTestsAccumulator.clearAccumulatedTests();
            HashMap<String, PrivateVisibilityInputFile> newInputFiles = new HashMap<String, PrivateVisibilityInputFile>();
            for (Rule rule : this.getRules()) {
                if (discoverAssumedInputFiles) {
                    List<Label> labels = this.ruleLabels != null ? this.ruleLabels.get(rule) : rule.getLabels();
                    for (Label label : labels) {
                        if (!label.getPackageIdentifier().equals(this.pkg.getPackageIdentifier()) || this.targets.containsKey(label.getName()) || newInputFiles.containsKey(label.getName())) continue;
                        Location loc = rule.getLocation();
                        newInputFiles.put(label.getName(), (PrivateVisibilityInputFile)(this.noImplicitFileExport ? new PrivateVisibilityInputFile(this.pkg, label, loc) : new InputFile(this.pkg, label, loc)));
                    }
                }
                this.testSuiteImplicitTestsAccumulator.processRule(rule);
            }
            this.testSuiteImplicitTestsAccumulator.sortTests();
            for (InputFile file : newInputFiles.values()) {
                this.addInputFile(file);
            }
            return this;
        }

        public Builder buildPartial() throws NoSuchPackageException {
            if (this.alreadyBuilt) {
                return this;
            }
            return this.beforeBuild(true);
        }

        public Package finishBuild() {
            if (this.alreadyBuilt) {
                return this.pkg;
            }
            for (Rule rule : this.getRules()) {
                rule.freeze();
            }
            this.ruleLabels = null;
            this.targets = Maps.unmodifiableBiMap(this.targets);
            this.defaultDistributionSet = Collections.unmodifiableSet(this.defaultDistributionSet);
            for (EnvironmentGroup envGroup : ImmutableSet.copyOf(this.environmentGroups.values())) {
                List<Event> errors = envGroup.processMemberEnvironments(this.targets);
                if (errors.isEmpty()) continue;
                this.addEvents(errors);
                this.setContainsErrors();
            }
            this.pkg.finishInit(this);
            this.alreadyBuilt = true;
            return this.pkg;
        }

        public Package build() throws NoSuchPackageException {
            return this.build(true);
        }

        Package build(boolean discoverAssumedInputFiles) throws NoSuchPackageException {
            if (this.alreadyBuilt) {
                return this.pkg;
            }
            this.beforeBuild(discoverAssumedInputFiles);
            return this.finishBuild();
        }

        private InputFile addInputFile(Label label, Location location) {
            return this.addInputFile(new InputFile(this.pkg, label, location));
        }

        private InputFile addInputFile(InputFile inputFile) {
            Target prev = this.targets.put(inputFile.getLabel().getName(), inputFile);
            Preconditions.checkState(prev == null);
            return inputFile;
        }

        private void checkForConflicts(Rule rule, List<Label> labels) throws NameConflictException {
            String name = rule.getName();
            Target existing = (Target)this.targets.get(name);
            if (existing != null) {
                throw Builder.nameConflict(rule, existing);
            }
            ImmutableList<OutputFile> outputFiles = rule.getOutputFiles();
            HashMap<String, OutputFile> outputFilesByName = Maps.newHashMapWithExpectedSize(outputFiles.size());
            for (OutputFile outputFile : outputFiles) {
                String outputFileName = outputFile.getName();
                if (outputFilesByName.put(outputFileName, outputFile) != null) {
                    throw Builder.duplicateOutputFile(outputFile, outputFile);
                }
                existing = (Target)this.targets.get(outputFileName);
                if (existing != null) {
                    throw Builder.duplicateOutputFile(outputFile, existing);
                }
                if (this.outputFilePrefixes.containsKey(outputFileName)) {
                    throw Builder.conflictingOutputFile(outputFile, this.outputFilePrefixes.get(outputFileName));
                }
                PathFragment outputFileFragment = PathFragment.create(outputFileName);
                int segmentCount = outputFileFragment.segmentCount();
                for (int i = 1; i < segmentCount; ++i) {
                    String prefix = outputFileFragment.subFragment(0, i).toString();
                    if (outputFilesByName.containsKey(prefix)) {
                        throw Builder.conflictingOutputFile(outputFile, (OutputFile)outputFilesByName.get(prefix));
                    }
                    if (this.targets.get(prefix) instanceof OutputFile) {
                        throw Builder.conflictingOutputFile(outputFile, (OutputFile)this.targets.get(prefix));
                    }
                    this.outputFilePrefixes.putIfAbsent(prefix, outputFile);
                }
            }
            Builder.checkForInputOutputConflicts(rule, labels, outputFilesByName.keySet());
        }

        private static void checkForInputOutputConflicts(Rule rule, List<Label> labels, Set<String> outputFiles) throws NameConflictException {
            PackageIdentifier packageIdentifier = rule.getLabel().getPackageIdentifier();
            for (Label inputLabel : labels) {
                if (!packageIdentifier.equals(inputLabel.getPackageIdentifier()) || !outputFiles.contains(inputLabel.getName())) continue;
                throw Builder.inputOutputNameConflict(rule, inputLabel.getName());
            }
        }

        private static NameConflictException duplicateOutputFile(OutputFile duplicate, Target existing) {
            return new NameConflictException(duplicate.getTargetKind() + " '" + duplicate.getName() + "' in rule '" + duplicate.getGeneratingRule().getName() + "' " + Builder.conflictsWith(existing));
        }

        private static NameConflictException nameConflict(Target duplicate, Target existing) {
            return new NameConflictException(duplicate.getTargetKind() + " '" + duplicate.getName() + "' in package '" + duplicate.getLabel().getPackageName() + "' " + Builder.conflictsWith(existing));
        }

        private static NameConflictException inputOutputNameConflict(Rule rule, String conflictingName) {
            return new NameConflictException("rule '" + rule.getName() + "' has file '" + conflictingName + "' as both an input and an output");
        }

        private static NameConflictException conflictingOutputFile(OutputFile added, OutputFile existing) {
            if (added.getGeneratingRule() == existing.getGeneratingRule()) {
                return new NameConflictException(String.format("rule '%s' has conflicting output files '%s' and '%s'", added.getGeneratingRule().getName(), added.getName(), existing.getName()));
            }
            return new NameConflictException(String.format("output file '%s' of rule '%s' conflicts with output file '%s' of rule '%s'", added.getName(), added.getGeneratingRule().getName(), existing.getName(), existing.getGeneratingRule().getName()));
        }

        private static String conflictsWith(Target target) {
            Object message = "conflicts with existing ";
            message = target instanceof OutputFile ? (String)message + "generated file from rule '" + ((OutputFile)target).getGeneratingRule().getName() + "'" : (String)message + target.getTargetKind();
            return (String)message + ", defined at " + target.getLocation();
        }

        static class GeneratedLabelConflict
        extends NameConflictException {
            private GeneratedLabelConflict(String message) {
                super(message);
            }
        }

        private static final class ThreadCompatibleInterner<T>
        implements Interner<T> {
            private final Map<T, T> interns = new HashMap<T, T>();

            private ThreadCompatibleInterner() {
            }

            @Override
            public T intern(T sample) {
                T existing = this.interns.putIfAbsent(sample, sample);
                return MoreObjects.firstNonNull(existing, sample);
            }
        }

        public static class DefaultPackageSettings
        implements PackageSettings {
            public static final DefaultPackageSettings INSTANCE = new DefaultPackageSettings();

            private DefaultPackageSettings() {
            }

            @Override
            public boolean succinctTargetNotFoundErrors() {
                return false;
            }

            @Override
            public boolean recordLoadedModules() {
                return true;
            }
        }

        public static interface PackageSettings {
            public boolean succinctTargetNotFoundErrors();

            public boolean recordLoadedModules();
        }
    }

    public static enum ConfigSettingVisibilityPolicy {
        LEGACY_OFF,
        DEFAULT_PUBLIC,
        DEFAULT_STANDARD;

    }

    public static class NameConflictException
    extends Exception {
        private NameConflictException(String message) {
            super(message);
        }
    }
}

