/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.packages.FileTarget;
import com.google.devtools.build.lib.packages.Package;
import com.google.devtools.build.lib.packages.Rule;
import com.google.devtools.build.lib.packages.RuleVisibility;
import java.util.List;
import net.starlark.java.syntax.Location;

public abstract class OutputFile
extends FileTarget {
    private final Rule generatingRule;
    private final String outputKey;

    static OutputFile createImplicit(Label label, Rule generatingRule, String outputKey) {
        return new Implicit(label, generatingRule, outputKey);
    }

    static OutputFile createExplicit(Label label, Rule generatingRule, String attrName) {
        return new Explicit(label, generatingRule, attrName);
    }

    private OutputFile(Label label, Rule generatingRule, String outputKey) {
        super(generatingRule.getPackage(), label);
        this.generatingRule = generatingRule;
        this.outputKey = outputKey;
    }

    @Override
    public final RuleVisibility getVisibility() {
        return this.generatingRule.getVisibility();
    }

    @Override
    public final Iterable<Label> getVisibilityDependencyLabels() {
        return this.generatingRule.getVisibilityDependencyLabels();
    }

    @Override
    public final List<Label> getVisibilityDeclaredLabels() {
        return this.generatingRule.getVisibilityDeclaredLabels();
    }

    @Override
    public final boolean isConfigurable() {
        return true;
    }

    public final Rule getGeneratingRule() {
        return this.generatingRule;
    }

    @Override
    public final Package getPackage() {
        return this.generatingRule.getPackage();
    }

    public final Kind getKind() {
        return this.generatingRule.getRuleClassObject().getOutputFileKind();
    }

    @Override
    public final String getTargetKind() {
        return OutputFile.targetKind();
    }

    @Override
    public final Rule getAssociatedRule() {
        return this.generatingRule;
    }

    @Override
    public final Location getLocation() {
        return this.generatingRule.getLocation();
    }

    final String getOutputKey() {
        return this.outputKey;
    }

    abstract boolean isImplicit();

    public static String targetKind() {
        return "generated file";
    }

    private static final class Explicit
    extends OutputFile {
        Explicit(Label label, Rule generatingRule, String attrName) {
            super(label, generatingRule, attrName);
        }

        @Override
        boolean isImplicit() {
            return false;
        }
    }

    private static final class Implicit
    extends OutputFile {
        Implicit(Label label, Rule generatingRule, String outputKey) {
            super(label, generatingRule, outputKey);
        }

        @Override
        boolean isImplicit() {
            return true;
        }
    }

    public static enum Kind {
        FILE,
        FILESET;

    }
}

