/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.packages.AbstractAttributeMapper;
import com.google.devtools.build.lib.packages.Rule;
import com.google.devtools.build.lib.packages.Type;
import javax.annotation.Nullable;

public class NonconfigurableAttributeMapper
extends AbstractAttributeMapper {
    private NonconfigurableAttributeMapper(Rule rule) {
        super(rule);
    }

    public static NonconfigurableAttributeMapper of(Rule rule) {
        return new NonconfigurableAttributeMapper(rule);
    }

    @Override
    public <T> T get(String attributeName, Type<T> type) {
        T attr = super.get(attributeName, type);
        Preconditions.checkState(!this.getAttributeDefinition(attributeName).isConfigurable(), "Attribute '%s' is potentially configurable - not allowed here", (Object)attributeName);
        return attr;
    }

    @Nullable
    public static <T> T attributeOrNull(Rule rule, String attributeName, Type<T> type) {
        NonconfigurableAttributeMapper mapper = NonconfigurableAttributeMapper.of(rule);
        if (!mapper.has(attributeName, type)) {
            return null;
        }
        return mapper.get(attributeName, type);
    }
}

