/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.devtools.build.lib.packages.GlobCache;
import com.google.devtools.build.lib.packages.Globber;
import com.google.devtools.build.lib.vfs.Path;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Future;

public class NonSkyframeGlobber
implements Globber {
    private final GlobCache globCache;

    NonSkyframeGlobber(GlobCache globCache) {
        this.globCache = globCache;
    }

    @Override
    public Token runAsync(List<String> includes, List<String> excludes, Globber.Operation globberOperation, boolean allowEmpty) throws Globber.BadGlobException {
        for (String pattern : includes) {
            Future<List<Path>> future = this.globCache.getGlobUnsortedAsync(pattern, globberOperation);
        }
        return new Token(includes, excludes, globberOperation, allowEmpty);
    }

    @Override
    public List<String> fetchUnsorted(Globber.Token token) throws Globber.BadGlobException, IOException, InterruptedException {
        Token ourToken = (Token)token;
        return this.globCache.globUnsorted(ourToken.includes, ourToken.excludes, ourToken.globberOperation, ourToken.allowEmpty);
    }

    @Override
    public void onInterrupt() {
        this.globCache.cancelBackgroundTasks();
    }

    @Override
    public void onCompletion() {
        this.globCache.finishBackgroundTasks();
    }

    public static class Token
    extends Globber.Token {
        private final List<String> includes;
        private final List<String> excludes;
        private final Globber.Operation globberOperation;
        private final boolean allowEmpty;

        private Token(List<String> includes, List<String> excludes, Globber.Operation globberOperation, boolean allowEmpty) {
            this.includes = includes;
            this.excludes = excludes;
            this.globberOperation = globberOperation;
            this.allowEmpty = allowEmpty;
        }
    }
}

