/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Strings;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.packages.BuildFileContainsErrorsException;
import com.google.devtools.build.lib.packages.NoSuchThingException;
import com.google.devtools.build.lib.packages.Target;
import com.google.devtools.build.lib.server.FailureDetails;
import com.google.devtools.build.lib.util.DetailedExitCode;
import javax.annotation.Nullable;

public class NoSuchTargetException
extends NoSuchThingException {
    @Nullable
    private final Label label;
    private final boolean hasTarget;

    public NoSuchTargetException(String message) {
        this(message, null, false);
    }

    public NoSuchTargetException(Label label, String message) {
        this("no such target '" + label + "': " + message, label, false);
    }

    public NoSuchTargetException(Target targetInError) {
        this("Target '" + targetInError.getLabel() + "' contains an error and its package is in error", targetInError.getLabel(), true);
    }

    private NoSuchTargetException(String message, @Nullable Label label, boolean hasTarget) {
        super(message, hasTarget ? new BuildFileContainsErrorsException(label.getPackageIdentifier()) : null);
        this.label = label;
        this.hasTarget = hasTarget;
    }

    @Nullable
    public Label getLabel() {
        return this.label;
    }

    public boolean hasTarget() {
        return this.hasTarget;
    }

    @Override
    public DetailedExitCode getDetailedExitCode() {
        DetailedExitCode uncheckedDetailedExitCode = this.getUncheckedDetailedExitCode();
        return uncheckedDetailedExitCode != null ? uncheckedDetailedExitCode : this.defaultDetailedExitCode();
    }

    private DetailedExitCode defaultDetailedExitCode() {
        return DetailedExitCode.of(FailureDetails.FailureDetail.newBuilder().setMessage(Strings.nullToEmpty(this.getMessage())).setPackageLoading(FailureDetails.PackageLoading.newBuilder().setCode(FailureDetails.PackageLoading.Code.TARGET_MISSING).build()).build());
    }
}

