/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.devtools.build.lib.cmdline.PackageIdentifier;
import com.google.devtools.build.lib.packages.NoSuchThingException;
import com.google.devtools.build.lib.server.FailureDetails;
import com.google.devtools.build.lib.util.DetailedExitCode;

public class NoSuchPackageException
extends NoSuchThingException {
    private final PackageIdentifier packageId;

    public NoSuchPackageException(PackageIdentifier packageId, String message) {
        super(message);
        this.packageId = packageId;
    }

    public NoSuchPackageException(PackageIdentifier packageId, String message, Exception cause) {
        super(message, cause);
        this.packageId = packageId;
    }

    public NoSuchPackageException(PackageIdentifier packageId, String message, DetailedExitCode detailedExitCode) {
        super(message, detailedExitCode);
        this.packageId = packageId;
    }

    public NoSuchPackageException(PackageIdentifier packageId, String message, Exception cause, DetailedExitCode detailedExitCode) {
        super(message, cause, detailedExitCode);
        this.packageId = packageId;
    }

    public PackageIdentifier getPackageId() {
        return this.packageId;
    }

    String getRawMessage() {
        return super.getMessage();
    }

    @Override
    public String getMessage() {
        return String.format("no such package '%s': %s", this.packageId, this.getRawMessage());
    }

    public boolean hasExplicitDetailedExitCode() {
        return this.getUncheckedDetailedExitCode() != null;
    }

    @Override
    public DetailedExitCode getDetailedExitCode() {
        DetailedExitCode uncheckedDetailedExitCode = this.getUncheckedDetailedExitCode();
        return uncheckedDetailedExitCode != null ? uncheckedDetailedExitCode : this.defaultDetailedExitCode();
    }

    private DetailedExitCode defaultDetailedExitCode() {
        return DetailedExitCode.of(FailureDetails.FailureDetail.newBuilder().setMessage(this.getMessage()).setPackageLoading(FailureDetails.PackageLoading.newBuilder().setCode(FailureDetails.PackageLoading.Code.PACKAGE_MISSING).build()).build());
    }
}

