/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.packages.AspectClass;
import com.google.devtools.build.lib.packages.AspectDefinition;
import com.google.devtools.build.lib.packages.AspectParameters;
import com.google.devtools.build.lib.packages.RuleClassProvider;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;

public abstract class NativeAspectClass
implements AspectClass {
    public static final ObjectCodec<NativeAspectClass> CODEC = new Codec();

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    public abstract AspectDefinition getDefinition(AspectParameters var1);

    private static class Codec
    implements ObjectCodec<NativeAspectClass> {
        private Codec() {
        }

        @Override
        public Class<NativeAspectClass> getEncodedClass() {
            return NativeAspectClass.class;
        }

        @Override
        public void serialize(SerializationContext context, NativeAspectClass obj, CodedOutputStream codedOut) throws SerializationException, IOException {
            RuleClassProvider ruleClassProvider = context.getDependency(RuleClassProvider.class);
            NativeAspectClass storedAspect = ruleClassProvider.getNativeAspectClass(obj.getKey());
            Preconditions.checkState(obj == storedAspect, "Not stored right: %s %s %s", (Object)obj, (Object)storedAspect, (Object)ruleClassProvider);
            context.serialize(obj.getKey(), codedOut);
        }

        @Override
        public NativeAspectClass deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
            String aspectKey = (String)context.deserialize(codedIn);
            return Preconditions.checkNotNull(context.getDependency(RuleClassProvider.class).getNativeAspectClass(aspectKey), aspectKey);
        }
    }
}

