/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.cmdline.LabelSyntaxException;
import com.google.devtools.build.lib.starlarkbuildapi.LicenseApi;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import net.starlark.java.eval.Printer;

public final class License
implements LicenseApi {
    private final ImmutableSet<LicenseType> licenseTypes;
    private final ImmutableSet<Label> exceptions;
    public static final License NO_LICENSE = new License(ImmutableSet.of(LicenseType.NONE), ImmutableSet.of());
    public static final Set<DistributionType> DEFAULT_DISTRIB = Collections.singleton(DistributionType.INTERNAL);

    public static LicenseType leastRestrictive(Collection<LicenseType> types) {
        return types.isEmpty() ? LicenseType.BY_EXCEPTION_ONLY : Collections.max(types);
    }

    public static Set<DistributionType> parseDistributions(Collection<String> distStrings) throws LicenseParsingException {
        if (distStrings.isEmpty()) {
            return Collections.unmodifiableSet(EnumSet.of(DistributionType.INTERNAL));
        }
        EnumSet<DistributionType> result = EnumSet.noneOf(DistributionType.class);
        for (String distStr : distStrings) {
            try {
                DistributionType dist = DistributionType.valueOf(distStr.toUpperCase(Locale.ENGLISH));
                result.add(dist);
            }
            catch (IllegalArgumentException e) {
                throw new LicenseParsingException("Invalid distribution type '" + distStr + "'");
            }
        }
        return Collections.unmodifiableSet(result);
    }

    private License(ImmutableSet<LicenseType> licenseTypes, ImmutableSet<Label> exceptions) {
        this.licenseTypes = licenseTypes;
        this.exceptions = exceptions;
    }

    public static License of(Collection<LicenseType> licenses, Collection<Label> exceptions) {
        ImmutableSet<LicenseType> licenseSet = ImmutableSet.copyOf(licenses);
        ImmutableSet<Label> exceptionSet = ImmutableSet.copyOf(exceptions);
        if (exceptionSet.isEmpty() && licenseSet.equals(ImmutableSet.of(LicenseType.NONE))) {
            return NO_LICENSE;
        }
        return new License(licenseSet, exceptionSet);
    }

    public static License parseLicense(List<String> licStrings) throws LicenseParsingException {
        EnumSet<LicenseType> licenseTypes = EnumSet.noneOf(LicenseType.class);
        TreeSet<Label> exceptions = Sets.newTreeSet();
        for (String str : licStrings) {
            if (str.startsWith("exception=")) {
                try {
                    Label label = Label.parseCanonical(str.substring("exception=".length()));
                    exceptions.add(label);
                    continue;
                }
                catch (LabelSyntaxException e) {
                    throw new LicenseParsingException(e.getMessage());
                }
            }
            try {
                licenseTypes.add(LicenseType.valueOf(str.toUpperCase(Locale.ENGLISH)));
            }
            catch (IllegalArgumentException e) {
                throw new LicenseParsingException("invalid license type: '" + str + "'");
            }
        }
        return License.of(licenseTypes, exceptions);
    }

    public Set<LicenseType> getLicenseTypes() {
        return this.licenseTypes;
    }

    public Set<Label> getExceptions() {
        return this.exceptions;
    }

    public boolean isSpecified() {
        return this != NO_LICENSE;
    }

    public String toString() {
        if (this.exceptions.isEmpty()) {
            return this.licenseTypes.toString().toLowerCase();
        }
        return this.licenseTypes.toString().toLowerCase() + " with exceptions " + this.exceptions;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof License && ((License)o).licenseTypes.equals(this.licenseTypes) && ((License)o).exceptions.equals(this.exceptions);
    }

    public int hashCode() {
        return this.licenseTypes.hashCode() * 43 + this.exceptions.hashCode();
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public void repr(Printer printer) {
        printer.append(this.toString());
    }

    public static enum DistributionType {
        INTERNAL,
        WEB,
        CLIENT,
        EMBEDDED;

    }

    public static enum LicenseType {
        BY_EXCEPTION_ONLY,
        RESTRICTED,
        RESTRICTED_IF_STATICALLY_LINKED,
        RECIPROCAL,
        NOTICE,
        PERMISSIVE,
        UNENCUMBERED,
        NONE;

    }

    public static class LicenseParsingException
    extends Exception {
        LicenseParsingException(String s2) {
            super(s2);
        }
    }
}

