/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.packages.AggregatingAttributeMapper;
import com.google.devtools.build.lib.packages.Attribute;
import com.google.devtools.build.lib.packages.BuildType;
import com.google.devtools.build.lib.packages.DependencyFilter;
import com.google.devtools.build.lib.packages.InputFile;
import com.google.devtools.build.lib.packages.OutputFile;
import com.google.devtools.build.lib.packages.PackageGroup;
import com.google.devtools.build.lib.packages.Rule;
import com.google.devtools.build.lib.packages.RuleClass;
import com.google.devtools.build.lib.packages.Target;
import javax.annotation.Nullable;

public final class LabelVisitationUtils {
    private LabelVisitationUtils() {
    }

    public static void visitTarget(Target target, DependencyFilter edgeFilter, LabelProcessor labelProcessor) {
        if (target instanceof OutputFile) {
            labelProcessor.process(target, null, ((OutputFile)target).getGeneratingRule().getLabel());
            LabelVisitationUtils.visitTargetVisibility(target, null, labelProcessor);
            return;
        }
        if (target instanceof InputFile) {
            LabelVisitationUtils.visitTargetVisibility(target, null, labelProcessor);
            return;
        }
        if (target instanceof Rule) {
            Rule rule = (Rule)target;
            LabelVisitationUtils.visitRuleVisibility(rule, edgeFilter, labelProcessor);
            LabelVisitationUtils.visitRule(rule, edgeFilter, labelProcessor);
            return;
        }
        if (target instanceof PackageGroup) {
            LabelVisitationUtils.visitPackageGroup((PackageGroup)target, labelProcessor);
        }
    }

    private static void visitTargetVisibility(Target target, @Nullable Attribute attribute, LabelProcessor labelProcessor) {
        for (Label label : target.getVisibilityDependencyLabels()) {
            labelProcessor.process(target, attribute, label);
        }
    }

    private static void visitRuleVisibility(Rule rule, DependencyFilter edgeFilter, LabelProcessor labelProcessor) {
        RuleClass ruleClass = rule.getRuleClassObject();
        Integer index = ruleClass.getAttributeIndex("visibility");
        if (index == null) {
            return;
        }
        Attribute visibilityAttribute = ruleClass.getAttribute(index);
        if (visibilityAttribute.getType() != BuildType.NODEP_LABEL_LIST) {
            return;
        }
        if (edgeFilter.test(rule, visibilityAttribute)) {
            LabelVisitationUtils.visitTargetVisibility(rule, visibilityAttribute, labelProcessor);
        }
    }

    private static void visitRule(Rule rule, DependencyFilter edgeFilter, LabelProcessor labelProcessor) {
        AggregatingAttributeMapper.of(rule).visitLabels(edgeFilter, (label, attribute) -> {
            if (label == null) {
                return;
            }
            labelProcessor.process(rule, attribute, label);
        });
    }

    private static void visitPackageGroup(PackageGroup packageGroup, LabelProcessor labelProcessor) {
        for (Label label : packageGroup.getIncludes()) {
            labelProcessor.process(packageGroup, null, label);
        }
    }

    public static interface LabelProcessor {
        public void process(Target var1, @Nullable Attribute var2, Label var3);
    }
}

