/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.devtools.build.lib.cmdline.BazelModuleContext;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.cmdline.LabelSyntaxException;
import com.google.devtools.build.lib.cmdline.PackageIdentifier;
import com.google.devtools.build.lib.cmdline.RepositoryMapping;
import java.util.HashMap;
import java.util.Map;
import net.starlark.java.eval.Module;
import net.starlark.java.eval.StarlarkThread;

public class LabelConverter {
    private final Label.PackageContext packageContext;
    private final Map<String, Label> labelCache = new HashMap<String, Label>();

    public static LabelConverter forBzlEvaluatingThread(StarlarkThread thread) {
        BazelModuleContext moduleContext = BazelModuleContext.of(Module.ofInnermostEnclosingStarlarkFunction(thread));
        return new LabelConverter(moduleContext.packageContext());
    }

    public LabelConverter(Label.PackageContext packageContext) {
        this.packageContext = packageContext;
    }

    public LabelConverter(PackageIdentifier base, RepositoryMapping repositoryMapping) {
        this(Label.PackageContext.of(base, repositoryMapping));
    }

    PackageIdentifier getBasePackage() {
        return this.packageContext.packageIdentifier();
    }

    public Label convert(String input) throws LabelSyntaxException {
        Label converted = this.labelCache.get(input);
        if (converted == null) {
            converted = Label.parseWithPackageContext(input, this.packageContext);
            this.labelCache.put(input, converted);
        }
        return converted;
    }

    public String toString() {
        return this.getBasePackage().toString();
    }
}

