/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.packages.FileTarget;
import com.google.devtools.build.lib.packages.License;
import com.google.devtools.build.lib.packages.Package;
import com.google.devtools.build.lib.packages.Rule;
import com.google.devtools.build.lib.packages.RuleVisibility;
import com.google.devtools.build.lib.vfs.Path;
import com.google.devtools.build.lib.vfs.PathFragment;
import javax.annotation.Nullable;
import net.starlark.java.syntax.Location;

public class InputFile
extends FileTarget {
    private final Package pkg;
    private final Location location;

    InputFile(Package pkg, Label label, Location location) {
        super(pkg, label);
        this.pkg = pkg;
        this.location = Preconditions.checkNotNull(location);
    }

    @Override
    public Package getPackage() {
        return this.pkg;
    }

    public boolean isVisibilitySpecified() {
        return false;
    }

    @Override
    public RuleVisibility getVisibility() {
        return this.pkg.getDefaultVisibility();
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    public boolean isLicenseSpecified() {
        return false;
    }

    @Override
    public License getLicense() {
        return License.NO_LICENSE;
    }

    public Path getPath() {
        return this.pkg.getPackageDirectory().getRelative(this.label.getName());
    }

    public PathFragment getExecPath(boolean siblingRepositoryLayout) {
        return this.label.getRepository().getExecPath(siblingRepositoryLayout).getRelative(this.label.getPackageName()).getRelative(this.label.getName());
    }

    @Override
    public String getTargetKind() {
        return InputFile.targetKind();
    }

    @Override
    @Nullable
    public Rule getAssociatedRule() {
        return null;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public static String targetKind() {
        return "source file";
    }
}

