/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.events.EventHandler;
import com.google.devtools.build.lib.packages.Attribute;
import com.google.devtools.build.lib.packages.AttributeMap;
import com.google.devtools.build.lib.packages.AutoValue_ImplicitOutputsFunction_ParsedTemplate;
import com.google.devtools.build.lib.packages.BuildType;
import com.google.devtools.build.lib.packages.StarlarkCallbackHelper;
import com.google.devtools.build.lib.packages.StarlarkInfo;
import com.google.devtools.build.lib.packages.StructProvider;
import com.google.devtools.build.lib.packages.Type;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.SerializationConstant;
import com.google.devtools.build.lib.util.StringUtil;
import com.google.devtools.build.lib.vfs.FileSystemUtils;
import com.google.devtools.build.lib.vfs.PathFragment;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.starlark.java.eval.Dict;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Starlark;

public abstract class ImplicitOutputsFunction {
    private static final Escaper PERCENT_ESCAPER = Escapers.builder().addEscape('%', "%%").build();
    @SerializationConstant
    public static final SafeImplicitOutputsFunction NONE = new SafeImplicitOutputsFunction(){

        @Override
        public Iterable<String> getImplicitOutputs(EventHandler eventHandler, AttributeMap rule) {
            return Collections.emptyList();
        }
    };

    public abstract Iterable<String> getImplicitOutputs(EventHandler var1, AttributeMap var2) throws EvalException, InterruptedException;

    public static SafeImplicitOutputsFunction fromTemplates(String ... templates) {
        return ImplicitOutputsFunction.fromTemplates(Arrays.asList(templates));
    }

    public static SafeImplicitOutputsFunction fromTemplates(Iterable<String> templates) {
        return new TemplateImplicitOutputsFunction(templates);
    }

    private static ImplicitOutputsFunction fromUnsafeTemplates(Iterable<String> templates) {
        return new UnsafeTemplatesImplicitOutputsFunction(templates);
    }

    public static SafeImplicitOutputsFunction fromFunctions(SafeImplicitOutputsFunction ... functions) {
        return ImplicitOutputsFunction.fromFunctions(Arrays.asList(functions));
    }

    public static SafeImplicitOutputsFunction fromFunctions(Iterable<SafeImplicitOutputsFunction> functions) {
        return new FunctionCombinationImplicitOutputsFunction(functions);
    }

    private static ImmutableSet<String> attributeValues(AttributeMap rule, String attrName) {
        if (attrName.equals("dirname")) {
            PathFragment dir = PathFragment.create(rule.getName()).getParentDirectory();
            return dir.isEmpty() ? ImmutableSet.of("") : ImmutableSet.of(dir.getPathString() + "/");
        }
        if (attrName.equals("basename")) {
            return ImmutableSet.of(PathFragment.create(rule.getName()).getBaseName());
        }
        Type<?> attrType = rule.getAttributeType(attrName);
        if (attrType == null) {
            return ImmutableSet.of();
        }
        if (Type.STRING == attrType) {
            return ImmutableSet.of(rule.get(attrName, Type.STRING));
        }
        if (Type.STRING_LIST == attrType) {
            return ImmutableSet.copyOf((Collection)((Object)rule.get(attrName, Type.STRING_LIST)));
        }
        if (BuildType.LABEL == attrType) {
            Label label2 = rule.get(attrName, BuildType.LABEL);
            return ImmutableSet.of(FileSystemUtils.removeExtension(label2.getName()));
        }
        if (BuildType.LABEL_LIST == attrType) {
            return ((List)((Object)rule.get(attrName, BuildType.LABEL_LIST))).stream().map(label -> FileSystemUtils.removeExtension(label.getName())).collect(ImmutableSet.toImmutableSet());
        }
        if (BuildType.OUTPUT == attrType) {
            Label out = rule.get(attrName, BuildType.OUTPUT);
            return ImmutableSet.of(out.getName());
        }
        if (BuildType.OUTPUT_LIST == attrType) {
            return ((List)((Object)rule.get(attrName, BuildType.OUTPUT_LIST))).stream().map(Label::getName).collect(ImmutableSet.toImmutableSet());
        }
        throw new IllegalArgumentException("Don't know how to handle " + attrName + " : " + attrType);
    }

    public static String createPlaceholderSubstitutionFormatString(String template, Collection<String> placeholders) {
        return ImplicitOutputsFunction.createPlaceholderSubstitutionFormatStringRecursive(template, placeholders, new StringBuilder());
    }

    private static String createPlaceholderSubstitutionFormatStringRecursive(String template, Collection<String> placeholders, StringBuilder formatBuilder) {
        int start = template.indexOf("%{");
        if (start < 0) {
            return formatBuilder.append(PERCENT_ESCAPER.escape(template)).toString();
        }
        int end = template.indexOf(125, start + 2);
        if (end < 0) {
            return formatBuilder.append(PERCENT_ESCAPER.escape(template)).toString();
        }
        formatBuilder.append(PERCENT_ESCAPER.escape(template.substring(0, start))).append("%s");
        placeholders.add(template.substring(start + 2, end));
        return ImplicitOutputsFunction.createPlaceholderSubstitutionFormatStringRecursive(template.substring(end + 1), placeholders, formatBuilder);
    }

    public static ImmutableList<String> substitutePlaceholderIntoTemplate(String template, AttributeMap rule) {
        return ImplicitOutputsFunction.substitutePlaceholderIntoTemplate(template, rule, ImplicitOutputsFunction::attributeValues);
    }

    public static ImmutableList<String> substitutePlaceholderIntoTemplate(String template, AttributeMap rule, AttributeValueGetter attributeGetter) {
        ParsedTemplate parsedTemplate = ParsedTemplate.parse(template);
        return parsedTemplate.substituteAttributes(rule, attributeGetter);
    }

    private static ImmutableList<String> substitutePlaceholderIntoUnsafeTemplate(String unsafeTemplate, AttributeMap rule, AttributeValueGetter attributeGetter) throws EvalException {
        ParsedTemplate parsedTemplate = ParsedTemplate.parse(unsafeTemplate);
        for (String placeholder : parsedTemplate.attributeNames()) {
            if (!rule.isConfigurable(placeholder)) continue;
            throw Starlark.errorf("Attribute %s is configurable and cannot be used in outputs", placeholder);
        }
        return parsedTemplate.substituteAttributes(rule, attributeGetter);
    }

    @AutoValue
    static abstract class ParsedTemplate {
        ParsedTemplate() {
        }

        abstract String template();

        abstract String formatStr();

        abstract List<String> attributeNames();

        static ParsedTemplate parse(String rawTemplate) {
            AbstractCollection placeholders = Lists.newArrayList();
            String formatStr = ImplicitOutputsFunction.createPlaceholderSubstitutionFormatString(rawTemplate, placeholders);
            if (placeholders.isEmpty()) {
                placeholders = ImmutableList.of();
            }
            return new AutoValue_ImplicitOutputsFunction_ParsedTemplate(rawTemplate, formatStr, (List<String>)((Object)placeholders));
        }

        ImmutableList<String> substituteAttributes(AttributeMap attributeMap, AttributeValueGetter attributeGetter) {
            if (this.attributeNames().isEmpty()) {
                return ImmutableList.of(this.template());
            }
            ArrayList<Set<String>> values = Lists.newArrayListWithCapacity(this.attributeNames().size());
            for (String placeholder : this.attributeNames()) {
                Set<String> attrValues = attributeGetter.get(attributeMap, placeholder);
                if (attrValues.isEmpty()) {
                    return ImmutableList.of();
                }
                values.add(attrValues);
            }
            ImmutableList.Builder out = new ImmutableList.Builder();
            for (List combination : Sets.cartesianProduct(values)) {
                out.add(String.format(this.formatStr(), combination.toArray()));
            }
            return out.build();
        }
    }

    private static class FunctionCombinationImplicitOutputsFunction
    extends SafeImplicitOutputsFunction {
        private final Iterable<SafeImplicitOutputsFunction> functions;

        FunctionCombinationImplicitOutputsFunction(Iterable<SafeImplicitOutputsFunction> functions) {
            this.functions = functions;
        }

        @Override
        public Iterable<String> getImplicitOutputs(EventHandler eventHandler, AttributeMap rule) {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            for (SafeImplicitOutputsFunction function : this.functions) {
                Iterables.addAll(result, function.getImplicitOutputs(eventHandler, rule));
            }
            return result;
        }

        public String toString() {
            return StringUtil.joinEnglishList(this.functions);
        }
    }

    private static class UnsafeTemplatesImplicitOutputsFunction
    extends ImplicitOutputsFunction {
        private final Iterable<String> templates;

        UnsafeTemplatesImplicitOutputsFunction(Iterable<String> templates) {
            this.templates = templates;
        }

        @Override
        public Iterable<String> getImplicitOutputs(EventHandler eventHandler, AttributeMap rule) throws EvalException {
            ImmutableSet.Builder result = new ImmutableSet.Builder();
            for (String template : this.templates) {
                ImmutableList<String> substitutions = ImplicitOutputsFunction.substitutePlaceholderIntoUnsafeTemplate(template, rule, (x$0, x$1) -> ImplicitOutputsFunction.attributeValues(x$0, x$1));
                if (substitutions.isEmpty()) continue;
                result.addAll(substitutions);
            }
            return result.build();
        }

        public String toString() {
            return StringUtil.joinEnglishList(this.templates);
        }
    }

    private static class TemplateImplicitOutputsFunction
    extends SafeImplicitOutputsFunction {
        private final Iterable<String> templates;

        TemplateImplicitOutputsFunction(Iterable<String> templates) {
            this.templates = templates;
        }

        @Override
        public Iterable<String> getImplicitOutputs(EventHandler eventHandler, AttributeMap rule) {
            ImmutableSet.Builder result = new ImmutableSet.Builder();
            for (String template : this.templates) {
                ImmutableList<String> substitutions = TemplateImplicitOutputsFunction.substitutePlaceholderIntoTemplate(template, rule);
                if (substitutions.isEmpty()) continue;
                result.addAll(substitutions);
            }
            return result.build();
        }

        public String toString() {
            return StringUtil.joinEnglishList(this.templates);
        }
    }

    public static interface AttributeValueGetter {
        public Set<String> get(AttributeMap var1, String var2);
    }

    public static abstract class SafeImplicitOutputsFunction
    extends ImplicitOutputsFunction {
        @Override
        public abstract Iterable<String> getImplicitOutputs(EventHandler var1, AttributeMap var2);
    }

    public static final class StarlarkImplicitOutputsFunctionWithMap
    extends StarlarkImplicitOutputsFunction {
        private final ImmutableMap<String, String> outputMap;

        public StarlarkImplicitOutputsFunctionWithMap(ImmutableMap<String, String> outputMap) {
            this.outputMap = outputMap;
        }

        @Override
        public ImmutableMap<String, String> calculateOutputs(EventHandler eventHandler, AttributeMap map) throws EvalException, InterruptedException {
            ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
            for (Map.Entry entry : this.outputMap.entrySet()) {
                ImplicitOutputsFunction outputsFunction = ImplicitOutputsFunction.fromUnsafeTemplates(ImmutableList.of((String)entry.getValue()));
                Iterable<String> substitutions = outputsFunction.getImplicitOutputs(eventHandler, map);
                if (Iterables.isEmpty(substitutions)) {
                    throw Starlark.errorf("For attribute '%s' in outputs: Invalid placeholder(s) in template", entry.getKey());
                }
                builder.put((String)entry.getKey(), Iterables.getOnlyElement(substitutions));
            }
            return builder.buildOrThrow();
        }
    }

    public static final class StarlarkImplicitOutputsFunctionWithCallback
    extends StarlarkImplicitOutputsFunction {
        private final StarlarkCallbackHelper callback;

        public StarlarkImplicitOutputsFunctionWithCallback(StarlarkCallbackHelper callback) {
            this.callback = callback;
        }

        @Override
        public ImmutableMap<String, String> calculateOutputs(EventHandler eventHandler, AttributeMap map) throws EvalException, InterruptedException {
            HashMap<String, Object> attrValues = new HashMap<String, Object>();
            for (String attrName : map.getAttributeNames()) {
                Type<?> attrType = map.getAttributeType(attrName);
                if (map.isConfigurable(attrName)) continue;
                Object value = map.get(attrName, attrType);
                attrValues.put(Attribute.getStarlarkName(attrName), Attribute.valueToStarlark(value));
            }
            StarlarkInfo attrs = StructProvider.STRUCT.create(attrValues, "Attribute '%s' either doesn't exist or uses a select() (i.e. could have multiple values)");
            try {
                ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
                for (Map.Entry<String, String> entry : Dict.cast(this.callback.call(eventHandler, attrs, new Object[0]), String.class, String.class, "implicit outputs function return value").entrySet()) {
                    Iterable<String> substitutions = StarlarkImplicitOutputsFunctionWithCallback.fromTemplates(entry.getValue()).getImplicitOutputs(eventHandler, map);
                    if (Iterables.isEmpty(substitutions)) {
                        throw Starlark.errorf("For attribute '%s' in outputs: Invalid placeholder(s) in template", entry.getKey());
                    }
                    builder.put(entry.getKey(), Iterables.getOnlyElement(substitutions));
                }
                return builder.buildOrThrow();
            }
            catch (IllegalArgumentException ex) {
                throw new EvalException(ex);
            }
        }
    }

    public static abstract class StarlarkImplicitOutputsFunction
    extends ImplicitOutputsFunction {
        public abstract ImmutableMap<String, String> calculateOutputs(EventHandler var1, AttributeMap var2) throws EvalException, InterruptedException;

        @Override
        public Iterable<String> getImplicitOutputs(EventHandler eventHandler, AttributeMap map) throws EvalException, InterruptedException {
            return this.calculateOutputs(eventHandler, map).values();
        }
    }
}

