/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.packages.License;
import com.google.devtools.build.lib.packages.Package;
import com.google.devtools.build.lib.packages.Target;
import com.google.devtools.build.lib.util.FileType;
import java.util.Set;

public abstract class FileTarget
implements Target,
FileType.HasFileType {
    final Label label;

    FileTarget(Package pkg, Label label) {
        Preconditions.checkArgument(label.getPackageFragment().equals(pkg.getNameFragment()));
        this.label = label;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    public String getFilename() {
        return this.label.getName();
    }

    @Override
    public Label getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.label.getName();
    }

    @Override
    public String filePathForFileTypeMatcher() {
        return this.getFilename();
    }

    public String toString() {
        return this.getTargetKind() + "(" + this.label + ")";
    }

    @Override
    public Set<License.DistributionType> getDistributions() {
        return this.getPackage().getDefaultDistribs();
    }

    @Override
    public License getLicense() {
        return this.getPackage().getDefaultLicense();
    }
}

