/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.build.lib.analysis.config.ToolchainTypeRequirement;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.packages.AutoValue_ExecGroup;
import com.google.devtools.build.lib.starlarkbuildapi.ExecGroupApi;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import javax.annotation.Nullable;

@AutoValue
public abstract class ExecGroup
implements ExecGroupApi {
    public static final String DEFAULT_EXEC_GROUP_NAME = "default-exec-group";

    public static Builder builder() {
        return new AutoValue_ExecGroup.Builder().toolchainTypes(ImmutableSet.of()).execCompatibleWith(ImmutableSet.of());
    }

    public static ExecGroup copyFromDefault() {
        return ExecGroup.builder().copyFrom(DEFAULT_EXEC_GROUP_NAME).build();
    }

    public ImmutableSet<ToolchainTypeRequirement> toolchainTypes() {
        return ImmutableSet.copyOf(this.toolchainTypesMap().values());
    }

    @Nullable
    public ToolchainTypeRequirement toolchainType(Label label) {
        return this.toolchainTypesMap().get(label);
    }

    public abstract ImmutableMap<Label, ToolchainTypeRequirement> toolchainTypesMap();

    public abstract ImmutableSet<Label> execCompatibleWith();

    @Nullable
    public abstract String copyFrom();

    public ExecGroup inheritFrom(ExecGroup other) {
        Builder builder = ExecGroup.builder().copyFrom(null);
        builder.toolchainTypesMapBuilder().putAll(this.toolchainTypesMap());
        builder.toolchainTypesMapBuilder().putAll(other.toolchainTypesMap());
        builder.execCompatibleWith((ImmutableSet<Label>)((ImmutableSet.Builder)((ImmutableSet.Builder)new ImmutableSet.Builder().addAll(this.execCompatibleWith())).addAll(other.execCompatibleWith())).build());
        return builder.build();
    }

    @AutoValue.Builder
    public static interface Builder {
        @CanIgnoreReturnValue
        default public Builder toolchainTypes(ImmutableSet<ToolchainTypeRequirement> toolchainTypes) {
            toolchainTypes.forEach(this::addToolchainType);
            return this;
        }

        public ImmutableMap.Builder<Label, ToolchainTypeRequirement> toolchainTypesMapBuilder();

        @CanIgnoreReturnValue
        default public Builder addToolchainType(ToolchainTypeRequirement toolchainTypeRequirement) {
            this.toolchainTypesMapBuilder().put(toolchainTypeRequirement.toolchainType(), toolchainTypeRequirement);
            return this;
        }

        public Builder execCompatibleWith(ImmutableSet<Label> var1);

        public Builder copyFrom(@Nullable String var1);

        public ExecGroup build();
    }
}

