/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.collect.nestedset.NestedSet;
import com.google.devtools.build.lib.collect.nestedset.NestedSetBuilder;
import com.google.devtools.build.lib.collect.nestedset.Order;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class EnvironmentLabels {
    final Label label;
    final ImmutableSet<Label> environments;
    final ImmutableSet<Label> defaults;
    private Map<Label, NestedSet<Label>> fulfillersMap;

    EnvironmentLabels(Label label, Collection<Label> environments, Collection<Label> defaults) {
        this(label, environments, defaults, null);
    }

    private EnvironmentLabels(Label label, Collection<Label> environments, Collection<Label> defaults, Map<Label, NestedSet<Label>> fulfillersMap) {
        this.label = label;
        this.environments = ImmutableSet.copyOf(environments);
        this.defaults = ImmutableSet.copyOf(defaults);
        this.fulfillersMap = fulfillersMap;
    }

    void assertNotInitialized() {
        Preconditions.checkState(this.fulfillersMap == null, this);
    }

    void checkInitialized() {
        Preconditions.checkNotNull(this.fulfillersMap, this);
    }

    void setFulfillersMap(Map<Label, NestedSet<Label>> fulfillersMap) {
        Preconditions.checkState(this.fulfillersMap == null, this);
        this.fulfillersMap = Collections.unmodifiableMap(fulfillersMap);
    }

    public Set<Label> getEnvironments() {
        this.checkInitialized();
        return this.environments;
    }

    public Set<Label> getDefaults() {
        this.checkInitialized();
        return this.defaults;
    }

    public boolean isDefault(Label environment) {
        this.checkInitialized();
        return this.defaults.contains(environment);
    }

    public NestedSet<Label> getFulfillers(Label environment) {
        this.checkInitialized();
        NestedSet<Label> ans = this.fulfillersMap.get(environment);
        return ans == null ? NestedSetBuilder.emptySet(Order.STABLE_ORDER) : ans;
    }

    public Label getLabel() {
        this.checkInitialized();
        return this.label;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("label", this.label).add("sizes", this.environments.size() + ", " + this.defaults.size() + ", " + this.fulfillersMap.size()).add("environments", this.environments).add("defaults", this.defaults).add("fulfillersMap", this.fulfillersMap).toString();
    }

    public int hashCode() {
        this.checkInitialized();
        return Objects.hash(this.label, this.environments, this.defaults, this.fulfillersMap.keySet());
    }

    private static boolean fulfillerMapsEqual(Map<Label, NestedSet<Label>> map1, Map<Label, NestedSet<Label>> map2) {
        if (map1 == map2) {
            return true;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<Label, NestedSet<Label>> entry : map1.entrySet()) {
            NestedSet<Label> secondValue = map2.get(entry.getKey());
            if (secondValue != null && (entry.getValue().shallowEquals(secondValue) || entry.getValue().toList().equals(secondValue.toList()))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        this.checkInitialized();
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnvironmentLabels that = (EnvironmentLabels)o;
        that.checkInitialized();
        return this.label.equals(that.label) && this.environments.equals(that.environments) && this.defaults.equals(that.defaults) && EnvironmentLabels.fulfillerMapsEqual(this.fulfillersMap, that.fulfillersMap);
    }
}

