/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.collect.nestedset.NestedSet;
import com.google.devtools.build.lib.collect.nestedset.NestedSetBuilder;
import com.google.devtools.build.lib.collect.nestedset.Order;
import com.google.devtools.build.lib.events.Event;
import com.google.devtools.build.lib.packages.BuildType;
import com.google.devtools.build.lib.packages.EnvironmentLabels;
import com.google.devtools.build.lib.packages.License;
import com.google.devtools.build.lib.packages.NonconfigurableAttributeMapper;
import com.google.devtools.build.lib.packages.Package;
import com.google.devtools.build.lib.packages.Rule;
import com.google.devtools.build.lib.packages.RuleVisibility;
import com.google.devtools.build.lib.packages.Target;
import com.google.devtools.build.lib.server.FailureDetails;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.starlark.java.syntax.Location;

public class EnvironmentGroup
implements Target {
    private final EnvironmentLabels environmentLabels;
    private final Location location;
    private final Package containingPackage;

    EnvironmentGroup(Label label, Package pkg, List<Label> environments, List<Label> defaults, Location location) {
        this.environmentLabels = new EnvironmentLabels(label, environments, defaults);
        this.location = location;
        this.containingPackage = pkg;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    public EnvironmentLabels getEnvironmentLabels() {
        this.environmentLabels.checkInitialized();
        return this.environmentLabels;
    }

    List<Event> validateMembership() {
        ArrayList<Event> events = new ArrayList<Event>();
        for (Label environment : Iterables.filter(this.environmentLabels.environments, new DifferentPackage(this.containingPackage))) {
            events.add(Package.error(this.location, environment + " is not in the same package as group " + this.environmentLabels.label, FailureDetails.PackageLoading.Code.ENVIRONMENT_IN_DIFFERENT_PACKAGE));
        }
        for (Label unknownDefault : Sets.difference(this.environmentLabels.defaults, this.environmentLabels.environments)) {
            events.add(Package.error(this.location, String.format("default %s is not a declared environment for group %s", unknownDefault, this.getLabel()), FailureDetails.PackageLoading.Code.DEFAULT_ENVIRONMENT_UNDECLARED));
        }
        return events;
    }

    List<Event> processMemberEnvironments(Map<String, Target> pkgTargets) {
        ArrayList<Event> events = new ArrayList<Event>();
        HashMultimap<Label, Label> directFulfillers = HashMultimap.create();
        for (Label envName : this.environmentLabels.environments) {
            Target env = pkgTargets.get(envName.getName());
            if (!this.isValidEnvironment(env, envName, "", events)) continue;
            NonconfigurableAttributeMapper attr = NonconfigurableAttributeMapper.of((Rule)env);
            for (Label fulfilledEnv : (List)((Object)attr.get("fulfills", BuildType.LABEL_LIST))) {
                if (!this.isValidEnvironment(pkgTargets.get(fulfilledEnv.getName()), fulfilledEnv, "in \"fulfills\" attribute of " + envName + ": ", events)) continue;
                directFulfillers.put(fulfilledEnv, envName);
            }
        }
        HashMap<Label, NestedSet<Label>> fulfillersMap = new HashMap<Label, NestedSet<Label>>();
        this.environmentLabels.assertNotInitialized();
        for (Label envName : this.environmentLabels.environments) {
            EnvironmentGroup.setTransitiveFulfillers(envName, directFulfillers, fulfillersMap);
        }
        this.environmentLabels.setFulfillersMap(fulfillersMap);
        return events;
    }

    private static NestedSet<Label> setTransitiveFulfillers(Label env, Multimap<Label, Label> directFulfillers, Map<Label, NestedSet<Label>> transitiveFulfillers) {
        if (transitiveFulfillers.containsKey(env)) {
            return transitiveFulfillers.get(env);
        }
        if (!directFulfillers.containsKey(env)) {
            NestedSet<Label> emptySet = NestedSetBuilder.emptySet(Order.STABLE_ORDER);
            transitiveFulfillers.put(env, emptySet);
            return emptySet;
        }
        NestedSetBuilder<Label> set = NestedSetBuilder.stableOrder();
        for (Label fulfillingEnv : directFulfillers.get(env)) {
            set.add(fulfillingEnv);
            set.addTransitive(EnvironmentGroup.setTransitiveFulfillers(fulfillingEnv, directFulfillers, transitiveFulfillers));
        }
        NestedSet<Label> builtSet = set.build();
        transitiveFulfillers.put(env, builtSet);
        return builtSet;
    }

    private boolean isValidEnvironment(Target env, Label envName, String prefix, List<Event> events) {
        if (env == null) {
            events.add(Package.error(this.location, prefix + "environment " + envName + " does not exist", FailureDetails.PackageLoading.Code.ENVIRONMENT_DOES_NOT_EXIST));
            return false;
        }
        if (!env.getTargetKind().equals("environment rule")) {
            events.add(Package.error(this.location, prefix + env.getLabel() + " is not a valid environment", FailureDetails.PackageLoading.Code.ENVIRONMENT_INVALID));
            return false;
        }
        if (!this.environmentLabels.environments.contains(env.getLabel())) {
            events.add(Package.error(this.location, prefix + env.getLabel() + " is not a member of this group", FailureDetails.PackageLoading.Code.ENVIRONMENT_NOT_IN_GROUP));
            return false;
        }
        return true;
    }

    public Set<Label> getEnvironments() {
        return this.environmentLabels.environments;
    }

    public Set<Label> getDefaults() {
        return this.environmentLabels.defaults;
    }

    @Override
    public Label getLabel() {
        return this.environmentLabels.label;
    }

    @Override
    public String getName() {
        return this.environmentLabels.label.getName();
    }

    @Override
    public Package getPackage() {
        return this.containingPackage;
    }

    @Override
    public String getTargetKind() {
        return EnvironmentGroup.targetKind();
    }

    @Override
    public Rule getAssociatedRule() {
        return null;
    }

    @Override
    public License getLicense() {
        return License.NO_LICENSE;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public String toString() {
        return EnvironmentGroup.targetKind() + " " + this.getLabel();
    }

    @Override
    public Set<License.DistributionType> getDistributions() {
        return Collections.emptySet();
    }

    @Override
    public RuleVisibility getVisibility() {
        return RuleVisibility.PRIVATE;
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    public static String targetKind() {
        return "environment group";
    }

    private static final class DifferentPackage
    implements Predicate<Label> {
        private final Package containingPackage;

        private DifferentPackage(Package containingPackage) {
            this.containingPackage = containingPackage;
        }

        @Override
        public boolean apply(Label environment) {
            return !environment.getPackageName().equals(this.containingPackage.getName());
        }
    }
}

